import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Organizations
*/
export interface OrganizationsOrganizationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/organizations_organization#aws_service_access_principals OrganizationsOrganization#aws_service_access_principals}
    */
    readonly awsServiceAccessPrincipals?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/organizations_organization#enabled_policy_types OrganizationsOrganization#enabled_policy_types}
    */
    readonly enabledPolicyTypes?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/organizations_organization#feature_set OrganizationsOrganization#feature_set}
    */
    readonly featureSet?: string;
}
export interface OrganizationsOrganizationAccounts {
}
export declare function organizationsOrganizationAccountsToTerraform(struct?: OrganizationsOrganizationAccounts): any;
export declare class OrganizationsOrganizationAccountsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OrganizationsOrganizationAccounts | undefined;
    set internalValue(value: OrganizationsOrganizationAccounts | undefined);
    get arn(): string;
    get email(): string;
    get id(): string;
    get name(): string;
    get status(): string;
}
export declare class OrganizationsOrganizationAccountsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OrganizationsOrganizationAccountsOutputReference;
}
export interface OrganizationsOrganizationNonMasterAccounts {
}
export declare function organizationsOrganizationNonMasterAccountsToTerraform(struct?: OrganizationsOrganizationNonMasterAccounts): any;
export declare class OrganizationsOrganizationNonMasterAccountsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OrganizationsOrganizationNonMasterAccounts | undefined;
    set internalValue(value: OrganizationsOrganizationNonMasterAccounts | undefined);
    get arn(): string;
    get email(): string;
    get id(): string;
    get name(): string;
    get status(): string;
}
export declare class OrganizationsOrganizationNonMasterAccountsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OrganizationsOrganizationNonMasterAccountsOutputReference;
}
export interface OrganizationsOrganizationRootsPolicyTypes {
}
export declare function organizationsOrganizationRootsPolicyTypesToTerraform(struct?: OrganizationsOrganizationRootsPolicyTypes): any;
export declare class OrganizationsOrganizationRootsPolicyTypesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OrganizationsOrganizationRootsPolicyTypes | undefined;
    set internalValue(value: OrganizationsOrganizationRootsPolicyTypes | undefined);
    get status(): string;
    get type(): string;
}
export declare class OrganizationsOrganizationRootsPolicyTypesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OrganizationsOrganizationRootsPolicyTypesOutputReference;
}
export interface OrganizationsOrganizationRoots {
}
export declare function organizationsOrganizationRootsToTerraform(struct?: OrganizationsOrganizationRoots): any;
export declare class OrganizationsOrganizationRootsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OrganizationsOrganizationRoots | undefined;
    set internalValue(value: OrganizationsOrganizationRoots | undefined);
    get arn(): string;
    get id(): string;
    get name(): string;
    private _policyTypes;
    get policyTypes(): OrganizationsOrganizationRootsPolicyTypesList;
}
export declare class OrganizationsOrganizationRootsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OrganizationsOrganizationRootsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/organizations_organization aws_organizations_organization}
*/
export declare class OrganizationsOrganization extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_organizations_organization";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/organizations_organization aws_organizations_organization} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options OrganizationsOrganizationConfig = {}
    */
    constructor(scope: Construct, id: string, config?: OrganizationsOrganizationConfig);
    private _accounts;
    get accounts(): OrganizationsOrganizationAccountsList;
    get arn(): string;
    private _awsServiceAccessPrincipals?;
    get awsServiceAccessPrincipals(): string[];
    set awsServiceAccessPrincipals(value: string[]);
    resetAwsServiceAccessPrincipals(): void;
    get awsServiceAccessPrincipalsInput(): string[] | undefined;
    private _enabledPolicyTypes?;
    get enabledPolicyTypes(): string[];
    set enabledPolicyTypes(value: string[]);
    resetEnabledPolicyTypes(): void;
    get enabledPolicyTypesInput(): string[] | undefined;
    private _featureSet?;
    get featureSet(): string;
    set featureSet(value: string);
    resetFeatureSet(): void;
    get featureSetInput(): string | undefined;
    get id(): string;
    get masterAccountArn(): string;
    get masterAccountEmail(): string;
    get masterAccountId(): string;
    private _nonMasterAccounts;
    get nonMasterAccounts(): OrganizationsOrganizationNonMasterAccountsList;
    private _roots;
    get roots(): OrganizationsOrganizationRootsList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=organizations-organization.d.ts.map