import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Pinpoint
*/
export interface PinpointAppConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/pinpoint_app#name PinpointApp#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/pinpoint_app#name_prefix PinpointApp#name_prefix}
    */
    readonly namePrefix?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/pinpoint_app#tags PinpointApp#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/pinpoint_app#tags_all PinpointApp#tags_all}
    */
    readonly tagsAll?: {
        [key: string]: string;
    };
    /**
    * campaign_hook block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/pinpoint_app#campaign_hook PinpointApp#campaign_hook}
    */
    readonly campaignHook?: PinpointAppCampaignHook;
    /**
    * limits block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/pinpoint_app#limits PinpointApp#limits}
    */
    readonly limits?: PinpointAppLimits;
    /**
    * quiet_time block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/pinpoint_app#quiet_time PinpointApp#quiet_time}
    */
    readonly quietTime?: PinpointAppQuietTime;
}
export interface PinpointAppCampaignHook {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/pinpoint_app#lambda_function_name PinpointApp#lambda_function_name}
    */
    readonly lambdaFunctionName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/pinpoint_app#mode PinpointApp#mode}
    */
    readonly mode?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/pinpoint_app#web_url PinpointApp#web_url}
    */
    readonly webUrl?: string;
}
export declare function pinpointAppCampaignHookToTerraform(struct?: PinpointAppCampaignHookOutputReference | PinpointAppCampaignHook): any;
export declare class PinpointAppCampaignHookOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PinpointAppCampaignHook | undefined;
    set internalValue(value: PinpointAppCampaignHook | undefined);
    private _lambdaFunctionName?;
    get lambdaFunctionName(): string;
    set lambdaFunctionName(value: string);
    resetLambdaFunctionName(): void;
    get lambdaFunctionNameInput(): string | undefined;
    private _mode?;
    get mode(): string;
    set mode(value: string);
    resetMode(): void;
    get modeInput(): string | undefined;
    private _webUrl?;
    get webUrl(): string;
    set webUrl(value: string);
    resetWebUrl(): void;
    get webUrlInput(): string | undefined;
}
export interface PinpointAppLimits {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/pinpoint_app#daily PinpointApp#daily}
    */
    readonly daily?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/pinpoint_app#maximum_duration PinpointApp#maximum_duration}
    */
    readonly maximumDuration?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/pinpoint_app#messages_per_second PinpointApp#messages_per_second}
    */
    readonly messagesPerSecond?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/pinpoint_app#total PinpointApp#total}
    */
    readonly total?: number;
}
export declare function pinpointAppLimitsToTerraform(struct?: PinpointAppLimitsOutputReference | PinpointAppLimits): any;
export declare class PinpointAppLimitsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PinpointAppLimits | undefined;
    set internalValue(value: PinpointAppLimits | undefined);
    private _daily?;
    get daily(): number;
    set daily(value: number);
    resetDaily(): void;
    get dailyInput(): number | undefined;
    private _maximumDuration?;
    get maximumDuration(): number;
    set maximumDuration(value: number);
    resetMaximumDuration(): void;
    get maximumDurationInput(): number | undefined;
    private _messagesPerSecond?;
    get messagesPerSecond(): number;
    set messagesPerSecond(value: number);
    resetMessagesPerSecond(): void;
    get messagesPerSecondInput(): number | undefined;
    private _total?;
    get total(): number;
    set total(value: number);
    resetTotal(): void;
    get totalInput(): number | undefined;
}
export interface PinpointAppQuietTime {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/pinpoint_app#end PinpointApp#end}
    */
    readonly end?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/pinpoint_app#start PinpointApp#start}
    */
    readonly start?: string;
}
export declare function pinpointAppQuietTimeToTerraform(struct?: PinpointAppQuietTimeOutputReference | PinpointAppQuietTime): any;
export declare class PinpointAppQuietTimeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PinpointAppQuietTime | undefined;
    set internalValue(value: PinpointAppQuietTime | undefined);
    private _end?;
    get end(): string;
    set end(value: string);
    resetEnd(): void;
    get endInput(): string | undefined;
    private _start?;
    get start(): string;
    set start(value: string);
    resetStart(): void;
    get startInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/pinpoint_app aws_pinpoint_app}
*/
export declare class PinpointApp extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_pinpoint_app";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/pinpoint_app aws_pinpoint_app} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PinpointAppConfig = {}
    */
    constructor(scope: Construct, id: string, config?: PinpointAppConfig);
    get applicationId(): string;
    get arn(): string;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _namePrefix?;
    get namePrefix(): string;
    set namePrefix(value: string);
    resetNamePrefix(): void;
    get namePrefixInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _tagsAll?;
    get tagsAll(): {
        [key: string]: string;
    };
    set tagsAll(value: {
        [key: string]: string;
    });
    resetTagsAll(): void;
    get tagsAllInput(): {
        [key: string]: string;
    } | undefined;
    private _campaignHook;
    get campaignHook(): PinpointAppCampaignHookOutputReference;
    putCampaignHook(value: PinpointAppCampaignHook): void;
    resetCampaignHook(): void;
    get campaignHookInput(): PinpointAppCampaignHook | undefined;
    private _limits;
    get limits(): PinpointAppLimitsOutputReference;
    putLimits(value: PinpointAppLimits): void;
    resetLimits(): void;
    get limitsInput(): PinpointAppLimits | undefined;
    private _quietTime;
    get quietTime(): PinpointAppQuietTimeOutputReference;
    putQuietTime(value: PinpointAppQuietTime): void;
    resetQuietTime(): void;
    get quietTimeInput(): PinpointAppQuietTime | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=pinpoint-app.d.ts.map