import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Quantum Ledger Database
*/
export interface DataAwsQldbLedgerConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/qldb_ledger#name DataAwsQldbLedger#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/qldb_ledger#tags DataAwsQldbLedger#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/d/qldb_ledger aws_qldb_ledger}
*/
export declare class DataAwsQldbLedger extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "aws_qldb_ledger";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/d/qldb_ledger aws_qldb_ledger} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAwsQldbLedgerConfig
    */
    constructor(scope: Construct, id: string, config: DataAwsQldbLedgerConfig);
    get arn(): string;
    get deletionProtection(): cdktf.IResolvable;
    get id(): string;
    get kmsKey(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get permissionsMode(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-aws-qldb-ledger.d.ts.map