import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Quantum Ledger Database
*/
export interface QldbStreamConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/qldb_stream#exclusive_end_time QldbStream#exclusive_end_time}
    */
    readonly exclusiveEndTime?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/qldb_stream#inclusive_start_time QldbStream#inclusive_start_time}
    */
    readonly inclusiveStartTime: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/qldb_stream#ledger_name QldbStream#ledger_name}
    */
    readonly ledgerName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/qldb_stream#role_arn QldbStream#role_arn}
    */
    readonly roleArn: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/qldb_stream#stream_name QldbStream#stream_name}
    */
    readonly streamName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/qldb_stream#tags QldbStream#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/qldb_stream#tags_all QldbStream#tags_all}
    */
    readonly tagsAll?: {
        [key: string]: string;
    };
    /**
    * kinesis_configuration block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/qldb_stream#kinesis_configuration QldbStream#kinesis_configuration}
    */
    readonly kinesisConfiguration: QldbStreamKinesisConfiguration;
}
export interface QldbStreamKinesisConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/qldb_stream#aggregation_enabled QldbStream#aggregation_enabled}
    */
    readonly aggregationEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/qldb_stream#stream_arn QldbStream#stream_arn}
    */
    readonly streamArn: string;
}
export declare function qldbStreamKinesisConfigurationToTerraform(struct?: QldbStreamKinesisConfigurationOutputReference | QldbStreamKinesisConfiguration): any;
export declare class QldbStreamKinesisConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): QldbStreamKinesisConfiguration | undefined;
    set internalValue(value: QldbStreamKinesisConfiguration | undefined);
    private _aggregationEnabled?;
    get aggregationEnabled(): boolean | cdktf.IResolvable;
    set aggregationEnabled(value: boolean | cdktf.IResolvable);
    resetAggregationEnabled(): void;
    get aggregationEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _streamArn?;
    get streamArn(): string;
    set streamArn(value: string);
    get streamArnInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/qldb_stream aws_qldb_stream}
*/
export declare class QldbStream extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_qldb_stream";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/qldb_stream aws_qldb_stream} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options QldbStreamConfig
    */
    constructor(scope: Construct, id: string, config: QldbStreamConfig);
    get arn(): string;
    private _exclusiveEndTime?;
    get exclusiveEndTime(): string;
    set exclusiveEndTime(value: string);
    resetExclusiveEndTime(): void;
    get exclusiveEndTimeInput(): string | undefined;
    get id(): string;
    private _inclusiveStartTime?;
    get inclusiveStartTime(): string;
    set inclusiveStartTime(value: string);
    get inclusiveStartTimeInput(): string | undefined;
    private _ledgerName?;
    get ledgerName(): string;
    set ledgerName(value: string);
    get ledgerNameInput(): string | undefined;
    private _roleArn?;
    get roleArn(): string;
    set roleArn(value: string);
    get roleArnInput(): string | undefined;
    private _streamName?;
    get streamName(): string;
    set streamName(value: string);
    get streamNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _tagsAll?;
    get tagsAll(): {
        [key: string]: string;
    };
    set tagsAll(value: {
        [key: string]: string;
    });
    resetTagsAll(): void;
    get tagsAllInput(): {
        [key: string]: string;
    } | undefined;
    private _kinesisConfiguration;
    get kinesisConfiguration(): QldbStreamKinesisConfigurationOutputReference;
    putKinesisConfiguration(value: QldbStreamKinesisConfiguration): void;
    get kinesisConfigurationInput(): QldbStreamKinesisConfiguration | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=qldb-stream.d.ts.map