import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Relational Database Service
*/
export interface DataAwsDbProxyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/db_proxy#name DataAwsDbProxy#name}
    */
    readonly name: string;
}
export interface DataAwsDbProxyAuth {
}
export declare function dataAwsDbProxyAuthToTerraform(struct?: DataAwsDbProxyAuth): any;
export declare class DataAwsDbProxyAuthOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAwsDbProxyAuth | undefined;
    set internalValue(value: DataAwsDbProxyAuth | undefined);
    get authScheme(): string;
    get description(): string;
    get iamAuth(): string;
    get secretArn(): string;
    get username(): string;
}
export declare class DataAwsDbProxyAuthList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAwsDbProxyAuthOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/d/db_proxy aws_db_proxy}
*/
export declare class DataAwsDbProxy extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "aws_db_proxy";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/d/db_proxy aws_db_proxy} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAwsDbProxyConfig
    */
    constructor(scope: Construct, id: string, config: DataAwsDbProxyConfig);
    get arn(): string;
    private _auth;
    get auth(): DataAwsDbProxyAuthList;
    get debugLogging(): cdktf.IResolvable;
    get endpoint(): string;
    get engineFamily(): string;
    get id(): string;
    get idleClientTimeout(): number;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get requireTls(): cdktf.IResolvable;
    get roleArn(): string;
    get vpcId(): string;
    get vpcSecurityGroupIds(): string[];
    get vpcSubnetIds(): string[];
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-aws-db-proxy.d.ts.map