import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Relational Database Service
*/
export interface RdsClusterActivityStreamConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/rds_cluster_activity_stream#engine_native_audit_fields_included RdsClusterActivityStream#engine_native_audit_fields_included}
    */
    readonly engineNativeAuditFieldsIncluded?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/rds_cluster_activity_stream#kms_key_id RdsClusterActivityStream#kms_key_id}
    */
    readonly kmsKeyId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/rds_cluster_activity_stream#mode RdsClusterActivityStream#mode}
    */
    readonly mode: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/rds_cluster_activity_stream#resource_arn RdsClusterActivityStream#resource_arn}
    */
    readonly resourceArn: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/rds_cluster_activity_stream aws_rds_cluster_activity_stream}
*/
export declare class RdsClusterActivityStream extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_rds_cluster_activity_stream";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/rds_cluster_activity_stream aws_rds_cluster_activity_stream} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options RdsClusterActivityStreamConfig
    */
    constructor(scope: Construct, id: string, config: RdsClusterActivityStreamConfig);
    private _engineNativeAuditFieldsIncluded?;
    get engineNativeAuditFieldsIncluded(): boolean | cdktf.IResolvable;
    set engineNativeAuditFieldsIncluded(value: boolean | cdktf.IResolvable);
    resetEngineNativeAuditFieldsIncluded(): void;
    get engineNativeAuditFieldsIncludedInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    get kinesisStreamName(): string;
    private _kmsKeyId?;
    get kmsKeyId(): string;
    set kmsKeyId(value: string);
    get kmsKeyIdInput(): string | undefined;
    private _mode?;
    get mode(): string;
    set mode(value: string);
    get modeInput(): string | undefined;
    private _resourceArn?;
    get resourceArn(): string;
    set resourceArn(value: string);
    get resourceArnInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=rds-cluster-activity-stream.d.ts.map