import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Redshift
*/
export interface DataAwsRedshiftClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/redshift_cluster#cluster_identifier DataAwsRedshiftCluster#cluster_identifier}
    */
    readonly clusterIdentifier: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/redshift_cluster#tags DataAwsRedshiftCluster#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/d/redshift_cluster aws_redshift_cluster}
*/
export declare class DataAwsRedshiftCluster extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "aws_redshift_cluster";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/d/redshift_cluster aws_redshift_cluster} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAwsRedshiftClusterConfig
    */
    constructor(scope: Construct, id: string, config: DataAwsRedshiftClusterConfig);
    get allowVersionUpgrade(): cdktf.IResolvable;
    get automatedSnapshotRetentionPeriod(): number;
    get availabilityZone(): string;
    get availabilityZoneRelocationEnabled(): cdktf.IResolvable;
    get bucketName(): string;
    private _clusterIdentifier?;
    get clusterIdentifier(): string;
    set clusterIdentifier(value: string);
    get clusterIdentifierInput(): string | undefined;
    get clusterParameterGroupName(): string;
    get clusterPublicKey(): string;
    get clusterRevisionNumber(): string;
    get clusterSecurityGroups(): string[];
    get clusterSubnetGroupName(): string;
    get clusterType(): string;
    get clusterVersion(): string;
    get databaseName(): string;
    get elasticIp(): string;
    get enableLogging(): cdktf.IResolvable;
    get encrypted(): cdktf.IResolvable;
    get endpoint(): string;
    get enhancedVpcRouting(): cdktf.IResolvable;
    get iamRoles(): string[];
    get id(): string;
    get kmsKeyId(): string;
    get masterUsername(): string;
    get nodeType(): string;
    get numberOfNodes(): number;
    get port(): number;
    get preferredMaintenanceWindow(): string;
    get publiclyAccessible(): cdktf.IResolvable;
    get s3KeyPrefix(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    get vpcId(): string;
    get vpcSecurityGroupIds(): string[];
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-aws-redshift-cluster.d.ts.map