import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Resource Groups
*/
export interface DataAwsResourcegroupstaggingapiResourcesConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/resourcegroupstaggingapi_resources#exclude_compliant_resources DataAwsResourcegroupstaggingapiResources#exclude_compliant_resources}
    */
    readonly excludeCompliantResources?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/resourcegroupstaggingapi_resources#include_compliance_details DataAwsResourcegroupstaggingapiResources#include_compliance_details}
    */
    readonly includeComplianceDetails?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/resourcegroupstaggingapi_resources#resource_arn_list DataAwsResourcegroupstaggingapiResources#resource_arn_list}
    */
    readonly resourceArnList?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/resourcegroupstaggingapi_resources#resource_type_filters DataAwsResourcegroupstaggingapiResources#resource_type_filters}
    */
    readonly resourceTypeFilters?: string[];
    /**
    * tag_filter block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/resourcegroupstaggingapi_resources#tag_filter DataAwsResourcegroupstaggingapiResources#tag_filter}
    */
    readonly tagFilter?: DataAwsResourcegroupstaggingapiResourcesTagFilter[] | cdktf.IResolvable;
}
export interface DataAwsResourcegroupstaggingapiResourcesResourceTagMappingListComplianceDetails {
}
export declare function dataAwsResourcegroupstaggingapiResourcesResourceTagMappingListComplianceDetailsToTerraform(struct?: DataAwsResourcegroupstaggingapiResourcesResourceTagMappingListComplianceDetails): any;
export declare class DataAwsResourcegroupstaggingapiResourcesResourceTagMappingListComplianceDetailsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAwsResourcegroupstaggingapiResourcesResourceTagMappingListComplianceDetails | undefined;
    set internalValue(value: DataAwsResourcegroupstaggingapiResourcesResourceTagMappingListComplianceDetails | undefined);
    get complianceStatus(): cdktf.IResolvable;
    get keysWithNoncompliantValues(): string[];
    get nonCompliantKeys(): string[];
}
export declare class DataAwsResourcegroupstaggingapiResourcesResourceTagMappingListComplianceDetailsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAwsResourcegroupstaggingapiResourcesResourceTagMappingListComplianceDetailsOutputReference;
}
export interface DataAwsResourcegroupstaggingapiResourcesResourceTagMappingList {
}
export declare function dataAwsResourcegroupstaggingapiResourcesResourceTagMappingListToTerraform(struct?: DataAwsResourcegroupstaggingapiResourcesResourceTagMappingList): any;
export declare class DataAwsResourcegroupstaggingapiResourcesResourceTagMappingListOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAwsResourcegroupstaggingapiResourcesResourceTagMappingList | undefined;
    set internalValue(value: DataAwsResourcegroupstaggingapiResourcesResourceTagMappingList | undefined);
    private _complianceDetails;
    get complianceDetails(): DataAwsResourcegroupstaggingapiResourcesResourceTagMappingListComplianceDetailsList;
    get resourceArn(): string;
    tags(key: string): string | cdktf.IResolvable;
}
export declare class DataAwsResourcegroupstaggingapiResourcesResourceTagMappingListList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAwsResourcegroupstaggingapiResourcesResourceTagMappingListOutputReference;
}
export interface DataAwsResourcegroupstaggingapiResourcesTagFilter {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/resourcegroupstaggingapi_resources#key DataAwsResourcegroupstaggingapiResources#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/resourcegroupstaggingapi_resources#values DataAwsResourcegroupstaggingapiResources#values}
    */
    readonly values?: string[];
}
export declare function dataAwsResourcegroupstaggingapiResourcesTagFilterToTerraform(struct?: DataAwsResourcegroupstaggingapiResourcesTagFilter | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/d/resourcegroupstaggingapi_resources aws_resourcegroupstaggingapi_resources}
*/
export declare class DataAwsResourcegroupstaggingapiResources extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "aws_resourcegroupstaggingapi_resources";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/d/resourcegroupstaggingapi_resources aws_resourcegroupstaggingapi_resources} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAwsResourcegroupstaggingapiResourcesConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataAwsResourcegroupstaggingapiResourcesConfig);
    private _excludeCompliantResources?;
    get excludeCompliantResources(): boolean | cdktf.IResolvable;
    set excludeCompliantResources(value: boolean | cdktf.IResolvable);
    resetExcludeCompliantResources(): void;
    get excludeCompliantResourcesInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _includeComplianceDetails?;
    get includeComplianceDetails(): boolean | cdktf.IResolvable;
    set includeComplianceDetails(value: boolean | cdktf.IResolvable);
    resetIncludeComplianceDetails(): void;
    get includeComplianceDetailsInput(): boolean | cdktf.IResolvable | undefined;
    private _resourceArnList?;
    get resourceArnList(): string[];
    set resourceArnList(value: string[]);
    resetResourceArnList(): void;
    get resourceArnListInput(): string[] | undefined;
    private _resourceTagMappingList;
    get resourceTagMappingList(): DataAwsResourcegroupstaggingapiResourcesResourceTagMappingListList;
    private _resourceTypeFilters?;
    get resourceTypeFilters(): string[];
    set resourceTypeFilters(value: string[]);
    resetResourceTypeFilters(): void;
    get resourceTypeFiltersInput(): string[] | undefined;
    private _tagFilter?;
    get tagFilter(): DataAwsResourcegroupstaggingapiResourcesTagFilter[] | cdktf.IResolvable;
    set tagFilter(value: DataAwsResourcegroupstaggingapiResourcesTagFilter[] | cdktf.IResolvable);
    resetTagFilter(): void;
    get tagFilterInput(): cdktf.IResolvable | DataAwsResourcegroupstaggingapiResourcesTagFilter[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-aws-resourcegroupstaggingapi-resources.d.ts.map