import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Route 53
*/
export interface DataAwsRoute53TrafficPolicyDocumentConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/route53_traffic_policy_document#record_type DataAwsRoute53TrafficPolicyDocument#record_type}
    */
    readonly recordType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/route53_traffic_policy_document#start_endpoint DataAwsRoute53TrafficPolicyDocument#start_endpoint}
    */
    readonly startEndpoint?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/route53_traffic_policy_document#start_rule DataAwsRoute53TrafficPolicyDocument#start_rule}
    */
    readonly startRule?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/route53_traffic_policy_document#version DataAwsRoute53TrafficPolicyDocument#version}
    */
    readonly version?: string;
    /**
    * endpoint block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/route53_traffic_policy_document#endpoint DataAwsRoute53TrafficPolicyDocument#endpoint}
    */
    readonly endpoint?: DataAwsRoute53TrafficPolicyDocumentEndpoint[] | cdktf.IResolvable;
    /**
    * rule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/route53_traffic_policy_document#rule DataAwsRoute53TrafficPolicyDocument#rule}
    */
    readonly rule?: DataAwsRoute53TrafficPolicyDocumentRule[] | cdktf.IResolvable;
}
export interface DataAwsRoute53TrafficPolicyDocumentEndpoint {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/route53_traffic_policy_document#id DataAwsRoute53TrafficPolicyDocument#id}
    */
    readonly id: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/route53_traffic_policy_document#region DataAwsRoute53TrafficPolicyDocument#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/route53_traffic_policy_document#type DataAwsRoute53TrafficPolicyDocument#type}
    */
    readonly type?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/route53_traffic_policy_document#value DataAwsRoute53TrafficPolicyDocument#value}
    */
    readonly value?: string;
}
export declare function dataAwsRoute53TrafficPolicyDocumentEndpointToTerraform(struct?: DataAwsRoute53TrafficPolicyDocumentEndpoint | cdktf.IResolvable): any;
export interface DataAwsRoute53TrafficPolicyDocumentRuleGeoProximityLocation {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/route53_traffic_policy_document#bias DataAwsRoute53TrafficPolicyDocument#bias}
    */
    readonly bias?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/route53_traffic_policy_document#endpoint_reference DataAwsRoute53TrafficPolicyDocument#endpoint_reference}
    */
    readonly endpointReference?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/route53_traffic_policy_document#evaluate_target_health DataAwsRoute53TrafficPolicyDocument#evaluate_target_health}
    */
    readonly evaluateTargetHealth?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/route53_traffic_policy_document#health_check DataAwsRoute53TrafficPolicyDocument#health_check}
    */
    readonly healthCheck?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/route53_traffic_policy_document#latitude DataAwsRoute53TrafficPolicyDocument#latitude}
    */
    readonly latitude?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/route53_traffic_policy_document#longitude DataAwsRoute53TrafficPolicyDocument#longitude}
    */
    readonly longitude?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/route53_traffic_policy_document#region DataAwsRoute53TrafficPolicyDocument#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/route53_traffic_policy_document#rule_reference DataAwsRoute53TrafficPolicyDocument#rule_reference}
    */
    readonly ruleReference?: string;
}
export declare function dataAwsRoute53TrafficPolicyDocumentRuleGeoProximityLocationToTerraform(struct?: DataAwsRoute53TrafficPolicyDocumentRuleGeoProximityLocation | cdktf.IResolvable): any;
export interface DataAwsRoute53TrafficPolicyDocumentRuleItems {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/route53_traffic_policy_document#endpoint_reference DataAwsRoute53TrafficPolicyDocument#endpoint_reference}
    */
    readonly endpointReference?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/route53_traffic_policy_document#health_check DataAwsRoute53TrafficPolicyDocument#health_check}
    */
    readonly healthCheck?: string;
}
export declare function dataAwsRoute53TrafficPolicyDocumentRuleItemsToTerraform(struct?: DataAwsRoute53TrafficPolicyDocumentRuleItems | cdktf.IResolvable): any;
export interface DataAwsRoute53TrafficPolicyDocumentRuleLocation {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/route53_traffic_policy_document#continent DataAwsRoute53TrafficPolicyDocument#continent}
    */
    readonly continent?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/route53_traffic_policy_document#country DataAwsRoute53TrafficPolicyDocument#country}
    */
    readonly country?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/route53_traffic_policy_document#endpoint_reference DataAwsRoute53TrafficPolicyDocument#endpoint_reference}
    */
    readonly endpointReference?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/route53_traffic_policy_document#evaluate_target_health DataAwsRoute53TrafficPolicyDocument#evaluate_target_health}
    */
    readonly evaluateTargetHealth?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/route53_traffic_policy_document#health_check DataAwsRoute53TrafficPolicyDocument#health_check}
    */
    readonly healthCheck?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/route53_traffic_policy_document#is_default DataAwsRoute53TrafficPolicyDocument#is_default}
    */
    readonly isDefault?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/route53_traffic_policy_document#rule_reference DataAwsRoute53TrafficPolicyDocument#rule_reference}
    */
    readonly ruleReference?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/route53_traffic_policy_document#subdivision DataAwsRoute53TrafficPolicyDocument#subdivision}
    */
    readonly subdivision?: string;
}
export declare function dataAwsRoute53TrafficPolicyDocumentRuleLocationToTerraform(struct?: DataAwsRoute53TrafficPolicyDocumentRuleLocation | cdktf.IResolvable): any;
export interface DataAwsRoute53TrafficPolicyDocumentRulePrimary {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/route53_traffic_policy_document#endpoint_reference DataAwsRoute53TrafficPolicyDocument#endpoint_reference}
    */
    readonly endpointReference?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/route53_traffic_policy_document#evaluate_target_health DataAwsRoute53TrafficPolicyDocument#evaluate_target_health}
    */
    readonly evaluateTargetHealth?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/route53_traffic_policy_document#health_check DataAwsRoute53TrafficPolicyDocument#health_check}
    */
    readonly healthCheck?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/route53_traffic_policy_document#rule_reference DataAwsRoute53TrafficPolicyDocument#rule_reference}
    */
    readonly ruleReference?: string;
}
export declare function dataAwsRoute53TrafficPolicyDocumentRulePrimaryToTerraform(struct?: DataAwsRoute53TrafficPolicyDocumentRulePrimaryOutputReference | DataAwsRoute53TrafficPolicyDocumentRulePrimary): any;
export declare class DataAwsRoute53TrafficPolicyDocumentRulePrimaryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAwsRoute53TrafficPolicyDocumentRulePrimary | undefined;
    set internalValue(value: DataAwsRoute53TrafficPolicyDocumentRulePrimary | undefined);
    private _endpointReference?;
    get endpointReference(): string;
    set endpointReference(value: string);
    resetEndpointReference(): void;
    get endpointReferenceInput(): string | undefined;
    private _evaluateTargetHealth?;
    get evaluateTargetHealth(): boolean | cdktf.IResolvable;
    set evaluateTargetHealth(value: boolean | cdktf.IResolvable);
    resetEvaluateTargetHealth(): void;
    get evaluateTargetHealthInput(): boolean | cdktf.IResolvable | undefined;
    private _healthCheck?;
    get healthCheck(): string;
    set healthCheck(value: string);
    resetHealthCheck(): void;
    get healthCheckInput(): string | undefined;
    private _ruleReference?;
    get ruleReference(): string;
    set ruleReference(value: string);
    resetRuleReference(): void;
    get ruleReferenceInput(): string | undefined;
}
export interface DataAwsRoute53TrafficPolicyDocumentRuleRegion {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/route53_traffic_policy_document#endpoint_reference DataAwsRoute53TrafficPolicyDocument#endpoint_reference}
    */
    readonly endpointReference?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/route53_traffic_policy_document#evaluate_target_health DataAwsRoute53TrafficPolicyDocument#evaluate_target_health}
    */
    readonly evaluateTargetHealth?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/route53_traffic_policy_document#health_check DataAwsRoute53TrafficPolicyDocument#health_check}
    */
    readonly healthCheck?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/route53_traffic_policy_document#region DataAwsRoute53TrafficPolicyDocument#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/route53_traffic_policy_document#rule_reference DataAwsRoute53TrafficPolicyDocument#rule_reference}
    */
    readonly ruleReference?: string;
}
export declare function dataAwsRoute53TrafficPolicyDocumentRuleRegionToTerraform(struct?: DataAwsRoute53TrafficPolicyDocumentRuleRegion | cdktf.IResolvable): any;
export interface DataAwsRoute53TrafficPolicyDocumentRuleSecondary {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/route53_traffic_policy_document#endpoint_reference DataAwsRoute53TrafficPolicyDocument#endpoint_reference}
    */
    readonly endpointReference?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/route53_traffic_policy_document#evaluate_target_health DataAwsRoute53TrafficPolicyDocument#evaluate_target_health}
    */
    readonly evaluateTargetHealth?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/route53_traffic_policy_document#health_check DataAwsRoute53TrafficPolicyDocument#health_check}
    */
    readonly healthCheck?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/route53_traffic_policy_document#rule_reference DataAwsRoute53TrafficPolicyDocument#rule_reference}
    */
    readonly ruleReference?: string;
}
export declare function dataAwsRoute53TrafficPolicyDocumentRuleSecondaryToTerraform(struct?: DataAwsRoute53TrafficPolicyDocumentRuleSecondaryOutputReference | DataAwsRoute53TrafficPolicyDocumentRuleSecondary): any;
export declare class DataAwsRoute53TrafficPolicyDocumentRuleSecondaryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAwsRoute53TrafficPolicyDocumentRuleSecondary | undefined;
    set internalValue(value: DataAwsRoute53TrafficPolicyDocumentRuleSecondary | undefined);
    private _endpointReference?;
    get endpointReference(): string;
    set endpointReference(value: string);
    resetEndpointReference(): void;
    get endpointReferenceInput(): string | undefined;
    private _evaluateTargetHealth?;
    get evaluateTargetHealth(): boolean | cdktf.IResolvable;
    set evaluateTargetHealth(value: boolean | cdktf.IResolvable);
    resetEvaluateTargetHealth(): void;
    get evaluateTargetHealthInput(): boolean | cdktf.IResolvable | undefined;
    private _healthCheck?;
    get healthCheck(): string;
    set healthCheck(value: string);
    resetHealthCheck(): void;
    get healthCheckInput(): string | undefined;
    private _ruleReference?;
    get ruleReference(): string;
    set ruleReference(value: string);
    resetRuleReference(): void;
    get ruleReferenceInput(): string | undefined;
}
export interface DataAwsRoute53TrafficPolicyDocumentRule {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/route53_traffic_policy_document#id DataAwsRoute53TrafficPolicyDocument#id}
    */
    readonly id: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/route53_traffic_policy_document#type DataAwsRoute53TrafficPolicyDocument#type}
    */
    readonly type?: string;
    /**
    * geo_proximity_location block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/route53_traffic_policy_document#geo_proximity_location DataAwsRoute53TrafficPolicyDocument#geo_proximity_location}
    */
    readonly geoProximityLocation?: DataAwsRoute53TrafficPolicyDocumentRuleGeoProximityLocation[] | cdktf.IResolvable;
    /**
    * items block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/route53_traffic_policy_document#items DataAwsRoute53TrafficPolicyDocument#items}
    */
    readonly items?: DataAwsRoute53TrafficPolicyDocumentRuleItems[] | cdktf.IResolvable;
    /**
    * location block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/route53_traffic_policy_document#location DataAwsRoute53TrafficPolicyDocument#location}
    */
    readonly location?: DataAwsRoute53TrafficPolicyDocumentRuleLocation[] | cdktf.IResolvable;
    /**
    * primary block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/route53_traffic_policy_document#primary DataAwsRoute53TrafficPolicyDocument#primary}
    */
    readonly primary?: DataAwsRoute53TrafficPolicyDocumentRulePrimary;
    /**
    * region block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/route53_traffic_policy_document#region DataAwsRoute53TrafficPolicyDocument#region}
    */
    readonly region?: DataAwsRoute53TrafficPolicyDocumentRuleRegion[] | cdktf.IResolvable;
    /**
    * secondary block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/route53_traffic_policy_document#secondary DataAwsRoute53TrafficPolicyDocument#secondary}
    */
    readonly secondary?: DataAwsRoute53TrafficPolicyDocumentRuleSecondary;
}
export declare function dataAwsRoute53TrafficPolicyDocumentRuleToTerraform(struct?: DataAwsRoute53TrafficPolicyDocumentRule | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/d/route53_traffic_policy_document aws_route53_traffic_policy_document}
*/
export declare class DataAwsRoute53TrafficPolicyDocument extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "aws_route53_traffic_policy_document";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/d/route53_traffic_policy_document aws_route53_traffic_policy_document} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAwsRoute53TrafficPolicyDocumentConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataAwsRoute53TrafficPolicyDocumentConfig);
    get id(): string;
    get json(): string;
    private _recordType?;
    get recordType(): string;
    set recordType(value: string);
    resetRecordType(): void;
    get recordTypeInput(): string | undefined;
    private _startEndpoint?;
    get startEndpoint(): string;
    set startEndpoint(value: string);
    resetStartEndpoint(): void;
    get startEndpointInput(): string | undefined;
    private _startRule?;
    get startRule(): string;
    set startRule(value: string);
    resetStartRule(): void;
    get startRuleInput(): string | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    resetVersion(): void;
    get versionInput(): string | undefined;
    private _endpoint?;
    get endpoint(): DataAwsRoute53TrafficPolicyDocumentEndpoint[] | cdktf.IResolvable;
    set endpoint(value: DataAwsRoute53TrafficPolicyDocumentEndpoint[] | cdktf.IResolvable);
    resetEndpoint(): void;
    get endpointInput(): cdktf.IResolvable | DataAwsRoute53TrafficPolicyDocumentEndpoint[] | undefined;
    private _rule?;
    get rule(): DataAwsRoute53TrafficPolicyDocumentRule[] | cdktf.IResolvable;
    set rule(value: DataAwsRoute53TrafficPolicyDocumentRule[] | cdktf.IResolvable);
    resetRule(): void;
    get ruleInput(): cdktf.IResolvable | DataAwsRoute53TrafficPolicyDocumentRule[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-aws-route53-traffic-policy-document.d.ts.map