import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Route 53
*/
export interface Route53RecordConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/route53_record#allow_overwrite Route53Record#allow_overwrite}
    */
    readonly allowOverwrite?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/route53_record#health_check_id Route53Record#health_check_id}
    */
    readonly healthCheckId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/route53_record#multivalue_answer_routing_policy Route53Record#multivalue_answer_routing_policy}
    */
    readonly multivalueAnswerRoutingPolicy?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/route53_record#name Route53Record#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/route53_record#records Route53Record#records}
    */
    readonly records?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/route53_record#set_identifier Route53Record#set_identifier}
    */
    readonly setIdentifier?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/route53_record#ttl Route53Record#ttl}
    */
    readonly ttl?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/route53_record#type Route53Record#type}
    */
    readonly type: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/route53_record#zone_id Route53Record#zone_id}
    */
    readonly zoneId: string;
    /**
    * alias block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/route53_record#alias Route53Record#alias}
    */
    readonly alias?: Route53RecordAlias[] | cdktf.IResolvable;
    /**
    * failover_routing_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/route53_record#failover_routing_policy Route53Record#failover_routing_policy}
    */
    readonly failoverRoutingPolicy?: Route53RecordFailoverRoutingPolicy[] | cdktf.IResolvable;
    /**
    * geolocation_routing_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/route53_record#geolocation_routing_policy Route53Record#geolocation_routing_policy}
    */
    readonly geolocationRoutingPolicy?: Route53RecordGeolocationRoutingPolicy[] | cdktf.IResolvable;
    /**
    * latency_routing_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/route53_record#latency_routing_policy Route53Record#latency_routing_policy}
    */
    readonly latencyRoutingPolicy?: Route53RecordLatencyRoutingPolicy[] | cdktf.IResolvable;
    /**
    * weighted_routing_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/route53_record#weighted_routing_policy Route53Record#weighted_routing_policy}
    */
    readonly weightedRoutingPolicy?: Route53RecordWeightedRoutingPolicy[] | cdktf.IResolvable;
}
export interface Route53RecordAlias {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/route53_record#evaluate_target_health Route53Record#evaluate_target_health}
    */
    readonly evaluateTargetHealth: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/route53_record#name Route53Record#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/route53_record#zone_id Route53Record#zone_id}
    */
    readonly zoneId: string;
}
export declare function route53RecordAliasToTerraform(struct?: Route53RecordAlias | cdktf.IResolvable): any;
export interface Route53RecordFailoverRoutingPolicy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/route53_record#type Route53Record#type}
    */
    readonly type: string;
}
export declare function route53RecordFailoverRoutingPolicyToTerraform(struct?: Route53RecordFailoverRoutingPolicy | cdktf.IResolvable): any;
export interface Route53RecordGeolocationRoutingPolicy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/route53_record#continent Route53Record#continent}
    */
    readonly continent?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/route53_record#country Route53Record#country}
    */
    readonly country?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/route53_record#subdivision Route53Record#subdivision}
    */
    readonly subdivision?: string;
}
export declare function route53RecordGeolocationRoutingPolicyToTerraform(struct?: Route53RecordGeolocationRoutingPolicy | cdktf.IResolvable): any;
export interface Route53RecordLatencyRoutingPolicy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/route53_record#region Route53Record#region}
    */
    readonly region: string;
}
export declare function route53RecordLatencyRoutingPolicyToTerraform(struct?: Route53RecordLatencyRoutingPolicy | cdktf.IResolvable): any;
export interface Route53RecordWeightedRoutingPolicy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/route53_record#weight Route53Record#weight}
    */
    readonly weight: number;
}
export declare function route53RecordWeightedRoutingPolicyToTerraform(struct?: Route53RecordWeightedRoutingPolicy | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/route53_record aws_route53_record}
*/
export declare class Route53Record extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_route53_record";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/route53_record aws_route53_record} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options Route53RecordConfig
    */
    constructor(scope: Construct, id: string, config: Route53RecordConfig);
    private _allowOverwrite?;
    get allowOverwrite(): boolean | cdktf.IResolvable;
    set allowOverwrite(value: boolean | cdktf.IResolvable);
    resetAllowOverwrite(): void;
    get allowOverwriteInput(): boolean | cdktf.IResolvable | undefined;
    get fqdn(): string;
    private _healthCheckId?;
    get healthCheckId(): string;
    set healthCheckId(value: string);
    resetHealthCheckId(): void;
    get healthCheckIdInput(): string | undefined;
    get id(): string;
    private _multivalueAnswerRoutingPolicy?;
    get multivalueAnswerRoutingPolicy(): boolean | cdktf.IResolvable;
    set multivalueAnswerRoutingPolicy(value: boolean | cdktf.IResolvable);
    resetMultivalueAnswerRoutingPolicy(): void;
    get multivalueAnswerRoutingPolicyInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _records?;
    get records(): string[];
    set records(value: string[]);
    resetRecords(): void;
    get recordsInput(): string[] | undefined;
    private _setIdentifier?;
    get setIdentifier(): string;
    set setIdentifier(value: string);
    resetSetIdentifier(): void;
    get setIdentifierInput(): string | undefined;
    private _ttl?;
    get ttl(): number;
    set ttl(value: number);
    resetTtl(): void;
    get ttlInput(): number | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _zoneId?;
    get zoneId(): string;
    set zoneId(value: string);
    get zoneIdInput(): string | undefined;
    private _alias?;
    get alias(): Route53RecordAlias[] | cdktf.IResolvable;
    set alias(value: Route53RecordAlias[] | cdktf.IResolvable);
    resetAlias(): void;
    get aliasInput(): cdktf.IResolvable | Route53RecordAlias[] | undefined;
    private _failoverRoutingPolicy?;
    get failoverRoutingPolicy(): Route53RecordFailoverRoutingPolicy[] | cdktf.IResolvable;
    set failoverRoutingPolicy(value: Route53RecordFailoverRoutingPolicy[] | cdktf.IResolvable);
    resetFailoverRoutingPolicy(): void;
    get failoverRoutingPolicyInput(): cdktf.IResolvable | Route53RecordFailoverRoutingPolicy[] | undefined;
    private _geolocationRoutingPolicy?;
    get geolocationRoutingPolicy(): Route53RecordGeolocationRoutingPolicy[] | cdktf.IResolvable;
    set geolocationRoutingPolicy(value: Route53RecordGeolocationRoutingPolicy[] | cdktf.IResolvable);
    resetGeolocationRoutingPolicy(): void;
    get geolocationRoutingPolicyInput(): cdktf.IResolvable | Route53RecordGeolocationRoutingPolicy[] | undefined;
    private _latencyRoutingPolicy?;
    get latencyRoutingPolicy(): Route53RecordLatencyRoutingPolicy[] | cdktf.IResolvable;
    set latencyRoutingPolicy(value: Route53RecordLatencyRoutingPolicy[] | cdktf.IResolvable);
    resetLatencyRoutingPolicy(): void;
    get latencyRoutingPolicyInput(): cdktf.IResolvable | Route53RecordLatencyRoutingPolicy[] | undefined;
    private _weightedRoutingPolicy?;
    get weightedRoutingPolicy(): Route53RecordWeightedRoutingPolicy[] | cdktf.IResolvable;
    set weightedRoutingPolicy(value: Route53RecordWeightedRoutingPolicy[] | cdktf.IResolvable);
    resetWeightedRoutingPolicy(): void;
    get weightedRoutingPolicyInput(): cdktf.IResolvable | Route53RecordWeightedRoutingPolicy[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=route53-record.d.ts.map