import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Route 53
*/
export interface Route53RecoverycontrolconfigClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/route53recoverycontrolconfig_cluster#name Route53RecoverycontrolconfigCluster#name}
    */
    readonly name: string;
}
export interface Route53RecoverycontrolconfigClusterClusterEndpoints {
}
export declare function route53RecoverycontrolconfigClusterClusterEndpointsToTerraform(struct?: Route53RecoverycontrolconfigClusterClusterEndpoints): any;
export declare class Route53RecoverycontrolconfigClusterClusterEndpointsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): Route53RecoverycontrolconfigClusterClusterEndpoints | undefined;
    set internalValue(value: Route53RecoverycontrolconfigClusterClusterEndpoints | undefined);
    get endpoint(): string;
    get region(): string;
}
export declare class Route53RecoverycontrolconfigClusterClusterEndpointsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): Route53RecoverycontrolconfigClusterClusterEndpointsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/route53recoverycontrolconfig_cluster aws_route53recoverycontrolconfig_cluster}
*/
export declare class Route53RecoverycontrolconfigCluster extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_route53recoverycontrolconfig_cluster";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/route53recoverycontrolconfig_cluster aws_route53recoverycontrolconfig_cluster} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options Route53RecoverycontrolconfigClusterConfig
    */
    constructor(scope: Construct, id: string, config: Route53RecoverycontrolconfigClusterConfig);
    get arn(): string;
    private _clusterEndpoints;
    get clusterEndpoints(): Route53RecoverycontrolconfigClusterClusterEndpointsList;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get status(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=route53recoverycontrolconfig-cluster.d.ts.map