import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Simple Storage Service
*/
export interface S3BucketAclConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/s3_bucket_acl#acl S3BucketAcl#acl}
    */
    readonly acl?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/s3_bucket_acl#bucket S3BucketAcl#bucket}
    */
    readonly bucket: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/s3_bucket_acl#expected_bucket_owner S3BucketAcl#expected_bucket_owner}
    */
    readonly expectedBucketOwner?: string;
    /**
    * access_control_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/s3_bucket_acl#access_control_policy S3BucketAcl#access_control_policy}
    */
    readonly accessControlPolicy?: S3BucketAclAccessControlPolicy;
}
export interface S3BucketAclAccessControlPolicyGrantGrantee {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/s3_bucket_acl#email_address S3BucketAcl#email_address}
    */
    readonly emailAddress?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/s3_bucket_acl#id S3BucketAcl#id}
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/s3_bucket_acl#type S3BucketAcl#type}
    */
    readonly type: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/s3_bucket_acl#uri S3BucketAcl#uri}
    */
    readonly uri?: string;
}
export declare function s3BucketAclAccessControlPolicyGrantGranteeToTerraform(struct?: S3BucketAclAccessControlPolicyGrantGranteeOutputReference | S3BucketAclAccessControlPolicyGrantGrantee): any;
export declare class S3BucketAclAccessControlPolicyGrantGranteeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): S3BucketAclAccessControlPolicyGrantGrantee | undefined;
    set internalValue(value: S3BucketAclAccessControlPolicyGrantGrantee | undefined);
    get displayName(): string;
    private _emailAddress?;
    get emailAddress(): string;
    set emailAddress(value: string);
    resetEmailAddress(): void;
    get emailAddressInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _uri?;
    get uri(): string;
    set uri(value: string);
    resetUri(): void;
    get uriInput(): string | undefined;
}
export interface S3BucketAclAccessControlPolicyGrant {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/s3_bucket_acl#permission S3BucketAcl#permission}
    */
    readonly permission: string;
    /**
    * grantee block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/s3_bucket_acl#grantee S3BucketAcl#grantee}
    */
    readonly grantee?: S3BucketAclAccessControlPolicyGrantGrantee;
}
export declare function s3BucketAclAccessControlPolicyGrantToTerraform(struct?: S3BucketAclAccessControlPolicyGrant | cdktf.IResolvable): any;
export interface S3BucketAclAccessControlPolicyOwner {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/s3_bucket_acl#display_name S3BucketAcl#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/s3_bucket_acl#id S3BucketAcl#id}
    */
    readonly id: string;
}
export declare function s3BucketAclAccessControlPolicyOwnerToTerraform(struct?: S3BucketAclAccessControlPolicyOwnerOutputReference | S3BucketAclAccessControlPolicyOwner): any;
export declare class S3BucketAclAccessControlPolicyOwnerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): S3BucketAclAccessControlPolicyOwner | undefined;
    set internalValue(value: S3BucketAclAccessControlPolicyOwner | undefined);
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    get idInput(): string | undefined;
}
export interface S3BucketAclAccessControlPolicy {
    /**
    * grant block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/s3_bucket_acl#grant S3BucketAcl#grant}
    */
    readonly grant?: S3BucketAclAccessControlPolicyGrant[] | cdktf.IResolvable;
    /**
    * owner block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/s3_bucket_acl#owner S3BucketAcl#owner}
    */
    readonly owner: S3BucketAclAccessControlPolicyOwner;
}
export declare function s3BucketAclAccessControlPolicyToTerraform(struct?: S3BucketAclAccessControlPolicyOutputReference | S3BucketAclAccessControlPolicy): any;
export declare class S3BucketAclAccessControlPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): S3BucketAclAccessControlPolicy | undefined;
    set internalValue(value: S3BucketAclAccessControlPolicy | undefined);
    private _grant?;
    get grant(): S3BucketAclAccessControlPolicyGrant[] | cdktf.IResolvable;
    set grant(value: S3BucketAclAccessControlPolicyGrant[] | cdktf.IResolvable);
    resetGrant(): void;
    get grantInput(): cdktf.IResolvable | S3BucketAclAccessControlPolicyGrant[] | undefined;
    private _owner;
    get owner(): S3BucketAclAccessControlPolicyOwnerOutputReference;
    putOwner(value: S3BucketAclAccessControlPolicyOwner): void;
    get ownerInput(): S3BucketAclAccessControlPolicyOwner | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/s3_bucket_acl aws_s3_bucket_acl}
*/
export declare class S3BucketAcl extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_s3_bucket_acl";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/s3_bucket_acl aws_s3_bucket_acl} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options S3BucketAclConfig
    */
    constructor(scope: Construct, id: string, config: S3BucketAclConfig);
    private _acl?;
    get acl(): string;
    set acl(value: string);
    resetAcl(): void;
    get aclInput(): string | undefined;
    private _bucket?;
    get bucket(): string;
    set bucket(value: string);
    get bucketInput(): string | undefined;
    private _expectedBucketOwner?;
    get expectedBucketOwner(): string;
    set expectedBucketOwner(value: string);
    resetExpectedBucketOwner(): void;
    get expectedBucketOwnerInput(): string | undefined;
    get id(): string;
    private _accessControlPolicy;
    get accessControlPolicy(): S3BucketAclAccessControlPolicyOutputReference;
    putAccessControlPolicy(value: S3BucketAclAccessControlPolicy): void;
    resetAccessControlPolicy(): void;
    get accessControlPolicyInput(): S3BucketAclAccessControlPolicy | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=s3-bucket-acl.d.ts.map