"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.S3BucketNotification = exports.s3BucketNotificationTopicToTerraform = exports.s3BucketNotificationQueueToTerraform = exports.s3BucketNotificationLambdaFunctionToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function s3BucketNotificationLambdaFunctionToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        events: cdktf.listMapper(cdktf.stringToTerraform)(struct.events),
        filter_prefix: cdktf.stringToTerraform(struct.filterPrefix),
        filter_suffix: cdktf.stringToTerraform(struct.filterSuffix),
        lambda_function_arn: cdktf.stringToTerraform(struct.lambdaFunctionArn),
    };
}
exports.s3BucketNotificationLambdaFunctionToTerraform = s3BucketNotificationLambdaFunctionToTerraform;
function s3BucketNotificationQueueToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        events: cdktf.listMapper(cdktf.stringToTerraform)(struct.events),
        filter_prefix: cdktf.stringToTerraform(struct.filterPrefix),
        filter_suffix: cdktf.stringToTerraform(struct.filterSuffix),
        queue_arn: cdktf.stringToTerraform(struct.queueArn),
    };
}
exports.s3BucketNotificationQueueToTerraform = s3BucketNotificationQueueToTerraform;
function s3BucketNotificationTopicToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        events: cdktf.listMapper(cdktf.stringToTerraform)(struct.events),
        filter_prefix: cdktf.stringToTerraform(struct.filterPrefix),
        filter_suffix: cdktf.stringToTerraform(struct.filterSuffix),
        topic_arn: cdktf.stringToTerraform(struct.topicArn),
    };
}
exports.s3BucketNotificationTopicToTerraform = s3BucketNotificationTopicToTerraform;
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/s3_bucket_notification aws_s3_bucket_notification}
*/
class S3BucketNotification extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/s3_bucket_notification aws_s3_bucket_notification} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options S3BucketNotificationConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'aws_s3_bucket_notification',
            terraformGeneratorMetadata: {
                providerName: 'aws',
                providerVersion: '4.15.1',
                providerVersionConstraint: '~> 4.0'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._bucket = config.bucket;
        this._eventbridge = config.eventbridge;
        this._lambdaFunction = config.lambdaFunction;
        this._queue = config.queue;
        this._topic = config.topic;
    }
    get bucket() {
        return this.getStringAttribute('bucket');
    }
    set bucket(value) {
        this._bucket = value;
    }
    // Temporarily expose input value. Use with caution.
    get bucketInput() {
        return this._bucket;
    }
    get eventbridge() {
        return this.getBooleanAttribute('eventbridge');
    }
    set eventbridge(value) {
        this._eventbridge = value;
    }
    resetEventbridge() {
        this._eventbridge = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get eventbridgeInput() {
        return this._eventbridge;
    }
    // id - computed: true, optional: true, required: false
    get id() {
        return this.getStringAttribute('id');
    }
    get lambdaFunction() {
        // Getting the computed value is not yet implemented
        return this.interpolationForAttribute('lambda_function');
    }
    set lambdaFunction(value) {
        this._lambdaFunction = value;
    }
    resetLambdaFunction() {
        this._lambdaFunction = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get lambdaFunctionInput() {
        return this._lambdaFunction;
    }
    get queue() {
        // Getting the computed value is not yet implemented
        return this.interpolationForAttribute('queue');
    }
    set queue(value) {
        this._queue = value;
    }
    resetQueue() {
        this._queue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get queueInput() {
        return this._queue;
    }
    get topic() {
        // Getting the computed value is not yet implemented
        return this.interpolationForAttribute('topic');
    }
    set topic(value) {
        this._topic = value;
    }
    resetTopic() {
        this._topic = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get topicInput() {
        return this._topic;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            bucket: cdktf.stringToTerraform(this._bucket),
            eventbridge: cdktf.booleanToTerraform(this._eventbridge),
            lambda_function: cdktf.listMapper(s3BucketNotificationLambdaFunctionToTerraform)(this._lambdaFunction),
            queue: cdktf.listMapper(s3BucketNotificationQueueToTerraform)(this._queue),
            topic: cdktf.listMapper(s3BucketNotificationTopicToTerraform)(this._topic),
        };
    }
}
exports.S3BucketNotification = S3BucketNotification;
_a = JSII_RTTI_SYMBOL_1;
S3BucketNotification[_a] = { fqn: "@cdktf/provider-aws.s3.S3BucketNotification", version: "7.0.64" };
// =================
// STATIC PROPERTIES
// =================
S3BucketNotification.tfResourceType = "aws_s3_bucket_notification";
//# sourceMappingURL=data:application/json;base64,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