"use strict";
var _a, _b, _c, _d, _e, _f;
Object.defineProperty(exports, "__esModule", { value: true });
exports.S3BucketWebsiteConfiguration = exports.s3BucketWebsiteConfigurationRoutingRuleToTerraform = exports.S3BucketWebsiteConfigurationRoutingRuleRedirectOutputReference = exports.s3BucketWebsiteConfigurationRoutingRuleRedirectToTerraform = exports.S3BucketWebsiteConfigurationRoutingRuleConditionOutputReference = exports.s3BucketWebsiteConfigurationRoutingRuleConditionToTerraform = exports.S3BucketWebsiteConfigurationRedirectAllRequestsToOutputReference = exports.s3BucketWebsiteConfigurationRedirectAllRequestsToToTerraform = exports.S3BucketWebsiteConfigurationIndexDocumentOutputReference = exports.s3BucketWebsiteConfigurationIndexDocumentToTerraform = exports.S3BucketWebsiteConfigurationErrorDocumentOutputReference = exports.s3BucketWebsiteConfigurationErrorDocumentToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function s3BucketWebsiteConfigurationErrorDocumentToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        key: cdktf.stringToTerraform(struct.key),
    };
}
exports.s3BucketWebsiteConfigurationErrorDocumentToTerraform = s3BucketWebsiteConfigurationErrorDocumentToTerraform;
class S3BucketWebsiteConfigurationErrorDocumentOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._key !== undefined) {
            hasAnyValues = true;
            internalValueResult.key = this._key;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._key = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._key = value.key;
        }
    }
    get key() {
        return this.getStringAttribute('key');
    }
    set key(value) {
        this._key = value;
    }
    // Temporarily expose input value. Use with caution.
    get keyInput() {
        return this._key;
    }
}
exports.S3BucketWebsiteConfigurationErrorDocumentOutputReference = S3BucketWebsiteConfigurationErrorDocumentOutputReference;
_a = JSII_RTTI_SYMBOL_1;
S3BucketWebsiteConfigurationErrorDocumentOutputReference[_a] = { fqn: "@cdktf/provider-aws.s3.S3BucketWebsiteConfigurationErrorDocumentOutputReference", version: "7.0.64" };
function s3BucketWebsiteConfigurationIndexDocumentToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        suffix: cdktf.stringToTerraform(struct.suffix),
    };
}
exports.s3BucketWebsiteConfigurationIndexDocumentToTerraform = s3BucketWebsiteConfigurationIndexDocumentToTerraform;
class S3BucketWebsiteConfigurationIndexDocumentOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._suffix !== undefined) {
            hasAnyValues = true;
            internalValueResult.suffix = this._suffix;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._suffix = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._suffix = value.suffix;
        }
    }
    get suffix() {
        return this.getStringAttribute('suffix');
    }
    set suffix(value) {
        this._suffix = value;
    }
    // Temporarily expose input value. Use with caution.
    get suffixInput() {
        return this._suffix;
    }
}
exports.S3BucketWebsiteConfigurationIndexDocumentOutputReference = S3BucketWebsiteConfigurationIndexDocumentOutputReference;
_b = JSII_RTTI_SYMBOL_1;
S3BucketWebsiteConfigurationIndexDocumentOutputReference[_b] = { fqn: "@cdktf/provider-aws.s3.S3BucketWebsiteConfigurationIndexDocumentOutputReference", version: "7.0.64" };
function s3BucketWebsiteConfigurationRedirectAllRequestsToToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        host_name: cdktf.stringToTerraform(struct.hostName),
        protocol: cdktf.stringToTerraform(struct.protocol),
    };
}
exports.s3BucketWebsiteConfigurationRedirectAllRequestsToToTerraform = s3BucketWebsiteConfigurationRedirectAllRequestsToToTerraform;
class S3BucketWebsiteConfigurationRedirectAllRequestsToOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._hostName !== undefined) {
            hasAnyValues = true;
            internalValueResult.hostName = this._hostName;
        }
        if (this._protocol !== undefined) {
            hasAnyValues = true;
            internalValueResult.protocol = this._protocol;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._hostName = undefined;
            this._protocol = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._hostName = value.hostName;
            this._protocol = value.protocol;
        }
    }
    get hostName() {
        return this.getStringAttribute('host_name');
    }
    set hostName(value) {
        this._hostName = value;
    }
    // Temporarily expose input value. Use with caution.
    get hostNameInput() {
        return this._hostName;
    }
    get protocol() {
        return this.getStringAttribute('protocol');
    }
    set protocol(value) {
        this._protocol = value;
    }
    resetProtocol() {
        this._protocol = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get protocolInput() {
        return this._protocol;
    }
}
exports.S3BucketWebsiteConfigurationRedirectAllRequestsToOutputReference = S3BucketWebsiteConfigurationRedirectAllRequestsToOutputReference;
_c = JSII_RTTI_SYMBOL_1;
S3BucketWebsiteConfigurationRedirectAllRequestsToOutputReference[_c] = { fqn: "@cdktf/provider-aws.s3.S3BucketWebsiteConfigurationRedirectAllRequestsToOutputReference", version: "7.0.64" };
function s3BucketWebsiteConfigurationRoutingRuleConditionToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        http_error_code_returned_equals: cdktf.stringToTerraform(struct.httpErrorCodeReturnedEquals),
        key_prefix_equals: cdktf.stringToTerraform(struct.keyPrefixEquals),
    };
}
exports.s3BucketWebsiteConfigurationRoutingRuleConditionToTerraform = s3BucketWebsiteConfigurationRoutingRuleConditionToTerraform;
class S3BucketWebsiteConfigurationRoutingRuleConditionOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._httpErrorCodeReturnedEquals !== undefined) {
            hasAnyValues = true;
            internalValueResult.httpErrorCodeReturnedEquals = this._httpErrorCodeReturnedEquals;
        }
        if (this._keyPrefixEquals !== undefined) {
            hasAnyValues = true;
            internalValueResult.keyPrefixEquals = this._keyPrefixEquals;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._httpErrorCodeReturnedEquals = undefined;
            this._keyPrefixEquals = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._httpErrorCodeReturnedEquals = value.httpErrorCodeReturnedEquals;
            this._keyPrefixEquals = value.keyPrefixEquals;
        }
    }
    get httpErrorCodeReturnedEquals() {
        return this.getStringAttribute('http_error_code_returned_equals');
    }
    set httpErrorCodeReturnedEquals(value) {
        this._httpErrorCodeReturnedEquals = value;
    }
    resetHttpErrorCodeReturnedEquals() {
        this._httpErrorCodeReturnedEquals = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get httpErrorCodeReturnedEqualsInput() {
        return this._httpErrorCodeReturnedEquals;
    }
    get keyPrefixEquals() {
        return this.getStringAttribute('key_prefix_equals');
    }
    set keyPrefixEquals(value) {
        this._keyPrefixEquals = value;
    }
    resetKeyPrefixEquals() {
        this._keyPrefixEquals = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get keyPrefixEqualsInput() {
        return this._keyPrefixEquals;
    }
}
exports.S3BucketWebsiteConfigurationRoutingRuleConditionOutputReference = S3BucketWebsiteConfigurationRoutingRuleConditionOutputReference;
_d = JSII_RTTI_SYMBOL_1;
S3BucketWebsiteConfigurationRoutingRuleConditionOutputReference[_d] = { fqn: "@cdktf/provider-aws.s3.S3BucketWebsiteConfigurationRoutingRuleConditionOutputReference", version: "7.0.64" };
function s3BucketWebsiteConfigurationRoutingRuleRedirectToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        host_name: cdktf.stringToTerraform(struct.hostName),
        http_redirect_code: cdktf.stringToTerraform(struct.httpRedirectCode),
        protocol: cdktf.stringToTerraform(struct.protocol),
        replace_key_prefix_with: cdktf.stringToTerraform(struct.replaceKeyPrefixWith),
        replace_key_with: cdktf.stringToTerraform(struct.replaceKeyWith),
    };
}
exports.s3BucketWebsiteConfigurationRoutingRuleRedirectToTerraform = s3BucketWebsiteConfigurationRoutingRuleRedirectToTerraform;
class S3BucketWebsiteConfigurationRoutingRuleRedirectOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._hostName !== undefined) {
            hasAnyValues = true;
            internalValueResult.hostName = this._hostName;
        }
        if (this._httpRedirectCode !== undefined) {
            hasAnyValues = true;
            internalValueResult.httpRedirectCode = this._httpRedirectCode;
        }
        if (this._protocol !== undefined) {
            hasAnyValues = true;
            internalValueResult.protocol = this._protocol;
        }
        if (this._replaceKeyPrefixWith !== undefined) {
            hasAnyValues = true;
            internalValueResult.replaceKeyPrefixWith = this._replaceKeyPrefixWith;
        }
        if (this._replaceKeyWith !== undefined) {
            hasAnyValues = true;
            internalValueResult.replaceKeyWith = this._replaceKeyWith;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._hostName = undefined;
            this._httpRedirectCode = undefined;
            this._protocol = undefined;
            this._replaceKeyPrefixWith = undefined;
            this._replaceKeyWith = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._hostName = value.hostName;
            this._httpRedirectCode = value.httpRedirectCode;
            this._protocol = value.protocol;
            this._replaceKeyPrefixWith = value.replaceKeyPrefixWith;
            this._replaceKeyWith = value.replaceKeyWith;
        }
    }
    get hostName() {
        return this.getStringAttribute('host_name');
    }
    set hostName(value) {
        this._hostName = value;
    }
    resetHostName() {
        this._hostName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get hostNameInput() {
        return this._hostName;
    }
    get httpRedirectCode() {
        return this.getStringAttribute('http_redirect_code');
    }
    set httpRedirectCode(value) {
        this._httpRedirectCode = value;
    }
    resetHttpRedirectCode() {
        this._httpRedirectCode = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get httpRedirectCodeInput() {
        return this._httpRedirectCode;
    }
    get protocol() {
        return this.getStringAttribute('protocol');
    }
    set protocol(value) {
        this._protocol = value;
    }
    resetProtocol() {
        this._protocol = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get protocolInput() {
        return this._protocol;
    }
    get replaceKeyPrefixWith() {
        return this.getStringAttribute('replace_key_prefix_with');
    }
    set replaceKeyPrefixWith(value) {
        this._replaceKeyPrefixWith = value;
    }
    resetReplaceKeyPrefixWith() {
        this._replaceKeyPrefixWith = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get replaceKeyPrefixWithInput() {
        return this._replaceKeyPrefixWith;
    }
    get replaceKeyWith() {
        return this.getStringAttribute('replace_key_with');
    }
    set replaceKeyWith(value) {
        this._replaceKeyWith = value;
    }
    resetReplaceKeyWith() {
        this._replaceKeyWith = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get replaceKeyWithInput() {
        return this._replaceKeyWith;
    }
}
exports.S3BucketWebsiteConfigurationRoutingRuleRedirectOutputReference = S3BucketWebsiteConfigurationRoutingRuleRedirectOutputReference;
_e = JSII_RTTI_SYMBOL_1;
S3BucketWebsiteConfigurationRoutingRuleRedirectOutputReference[_e] = { fqn: "@cdktf/provider-aws.s3.S3BucketWebsiteConfigurationRoutingRuleRedirectOutputReference", version: "7.0.64" };
function s3BucketWebsiteConfigurationRoutingRuleToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        condition: s3BucketWebsiteConfigurationRoutingRuleConditionToTerraform(struct.condition),
        redirect: s3BucketWebsiteConfigurationRoutingRuleRedirectToTerraform(struct.redirect),
    };
}
exports.s3BucketWebsiteConfigurationRoutingRuleToTerraform = s3BucketWebsiteConfigurationRoutingRuleToTerraform;
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/s3_bucket_website_configuration aws_s3_bucket_website_configuration}
*/
class S3BucketWebsiteConfiguration extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/s3_bucket_website_configuration aws_s3_bucket_website_configuration} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options S3BucketWebsiteConfigurationConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'aws_s3_bucket_website_configuration',
            terraformGeneratorMetadata: {
                providerName: 'aws',
                providerVersion: '4.15.1',
                providerVersionConstraint: '~> 4.0'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        // error_document - computed: false, optional: true, required: false
        this._errorDocument = new S3BucketWebsiteConfigurationErrorDocumentOutputReference(this, "error_document");
        // index_document - computed: false, optional: true, required: false
        this._indexDocument = new S3BucketWebsiteConfigurationIndexDocumentOutputReference(this, "index_document");
        // redirect_all_requests_to - computed: false, optional: true, required: false
        this._redirectAllRequestsTo = new S3BucketWebsiteConfigurationRedirectAllRequestsToOutputReference(this, "redirect_all_requests_to");
        this._bucket = config.bucket;
        this._expectedBucketOwner = config.expectedBucketOwner;
        this._routingRules = config.routingRules;
        this._errorDocument.internalValue = config.errorDocument;
        this._indexDocument.internalValue = config.indexDocument;
        this._redirectAllRequestsTo.internalValue = config.redirectAllRequestsTo;
        this._routingRule = config.routingRule;
    }
    get bucket() {
        return this.getStringAttribute('bucket');
    }
    set bucket(value) {
        this._bucket = value;
    }
    // Temporarily expose input value. Use with caution.
    get bucketInput() {
        return this._bucket;
    }
    get expectedBucketOwner() {
        return this.getStringAttribute('expected_bucket_owner');
    }
    set expectedBucketOwner(value) {
        this._expectedBucketOwner = value;
    }
    resetExpectedBucketOwner() {
        this._expectedBucketOwner = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get expectedBucketOwnerInput() {
        return this._expectedBucketOwner;
    }
    // id - computed: true, optional: true, required: false
    get id() {
        return this.getStringAttribute('id');
    }
    get routingRules() {
        return this.getStringAttribute('routing_rules');
    }
    set routingRules(value) {
        this._routingRules = value;
    }
    resetRoutingRules() {
        this._routingRules = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get routingRulesInput() {
        return this._routingRules;
    }
    // website_domain - computed: true, optional: false, required: false
    get websiteDomain() {
        return this.getStringAttribute('website_domain');
    }
    // website_endpoint - computed: true, optional: false, required: false
    get websiteEndpoint() {
        return this.getStringAttribute('website_endpoint');
    }
    get errorDocument() {
        return this._errorDocument;
    }
    putErrorDocument(value) {
        this._errorDocument.internalValue = value;
    }
    resetErrorDocument() {
        this._errorDocument.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get errorDocumentInput() {
        return this._errorDocument.internalValue;
    }
    get indexDocument() {
        return this._indexDocument;
    }
    putIndexDocument(value) {
        this._indexDocument.internalValue = value;
    }
    resetIndexDocument() {
        this._indexDocument.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get indexDocumentInput() {
        return this._indexDocument.internalValue;
    }
    get redirectAllRequestsTo() {
        return this._redirectAllRequestsTo;
    }
    putRedirectAllRequestsTo(value) {
        this._redirectAllRequestsTo.internalValue = value;
    }
    resetRedirectAllRequestsTo() {
        this._redirectAllRequestsTo.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get redirectAllRequestsToInput() {
        return this._redirectAllRequestsTo.internalValue;
    }
    get routingRule() {
        // Getting the computed value is not yet implemented
        return this.interpolationForAttribute('routing_rule');
    }
    set routingRule(value) {
        this._routingRule = value;
    }
    resetRoutingRule() {
        this._routingRule = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get routingRuleInput() {
        return this._routingRule;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            bucket: cdktf.stringToTerraform(this._bucket),
            expected_bucket_owner: cdktf.stringToTerraform(this._expectedBucketOwner),
            routing_rules: cdktf.stringToTerraform(this._routingRules),
            error_document: s3BucketWebsiteConfigurationErrorDocumentToTerraform(this._errorDocument.internalValue),
            index_document: s3BucketWebsiteConfigurationIndexDocumentToTerraform(this._indexDocument.internalValue),
            redirect_all_requests_to: s3BucketWebsiteConfigurationRedirectAllRequestsToToTerraform(this._redirectAllRequestsTo.internalValue),
            routing_rule: cdktf.listMapper(s3BucketWebsiteConfigurationRoutingRuleToTerraform)(this._routingRule),
        };
    }
}
exports.S3BucketWebsiteConfiguration = S3BucketWebsiteConfiguration;
_f = JSII_RTTI_SYMBOL_1;
S3BucketWebsiteConfiguration[_f] = { fqn: "@cdktf/provider-aws.s3.S3BucketWebsiteConfiguration", version: "7.0.64" };
// =================
// STATIC PROPERTIES
// =================
S3BucketWebsiteConfiguration.tfResourceType = "aws_s3_bucket_website_configuration";
//# sourceMappingURL=data:application/json;base64,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