import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS SageMaker
*/
export interface SagemakerProjectConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/sagemaker_project#project_description SagemakerProject#project_description}
    */
    readonly projectDescription?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/sagemaker_project#project_name SagemakerProject#project_name}
    */
    readonly projectName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/sagemaker_project#tags SagemakerProject#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/sagemaker_project#tags_all SagemakerProject#tags_all}
    */
    readonly tagsAll?: {
        [key: string]: string;
    };
    /**
    * service_catalog_provisioning_details block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/sagemaker_project#service_catalog_provisioning_details SagemakerProject#service_catalog_provisioning_details}
    */
    readonly serviceCatalogProvisioningDetails: SagemakerProjectServiceCatalogProvisioningDetails;
}
export interface SagemakerProjectServiceCatalogProvisioningDetailsProvisioningParameter {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/sagemaker_project#key SagemakerProject#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/sagemaker_project#value SagemakerProject#value}
    */
    readonly value?: string;
}
export declare function sagemakerProjectServiceCatalogProvisioningDetailsProvisioningParameterToTerraform(struct?: SagemakerProjectServiceCatalogProvisioningDetailsProvisioningParameter | cdktf.IResolvable): any;
export interface SagemakerProjectServiceCatalogProvisioningDetails {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/sagemaker_project#path_id SagemakerProject#path_id}
    */
    readonly pathId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/sagemaker_project#product_id SagemakerProject#product_id}
    */
    readonly productId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/sagemaker_project#provisioning_artifact_id SagemakerProject#provisioning_artifact_id}
    */
    readonly provisioningArtifactId?: string;
    /**
    * provisioning_parameter block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/sagemaker_project#provisioning_parameter SagemakerProject#provisioning_parameter}
    */
    readonly provisioningParameter?: SagemakerProjectServiceCatalogProvisioningDetailsProvisioningParameter[] | cdktf.IResolvable;
}
export declare function sagemakerProjectServiceCatalogProvisioningDetailsToTerraform(struct?: SagemakerProjectServiceCatalogProvisioningDetailsOutputReference | SagemakerProjectServiceCatalogProvisioningDetails): any;
export declare class SagemakerProjectServiceCatalogProvisioningDetailsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SagemakerProjectServiceCatalogProvisioningDetails | undefined;
    set internalValue(value: SagemakerProjectServiceCatalogProvisioningDetails | undefined);
    private _pathId?;
    get pathId(): string;
    set pathId(value: string);
    resetPathId(): void;
    get pathIdInput(): string | undefined;
    private _productId?;
    get productId(): string;
    set productId(value: string);
    get productIdInput(): string | undefined;
    private _provisioningArtifactId?;
    get provisioningArtifactId(): string;
    set provisioningArtifactId(value: string);
    resetProvisioningArtifactId(): void;
    get provisioningArtifactIdInput(): string | undefined;
    private _provisioningParameter?;
    get provisioningParameter(): SagemakerProjectServiceCatalogProvisioningDetailsProvisioningParameter[] | cdktf.IResolvable;
    set provisioningParameter(value: SagemakerProjectServiceCatalogProvisioningDetailsProvisioningParameter[] | cdktf.IResolvable);
    resetProvisioningParameter(): void;
    get provisioningParameterInput(): cdktf.IResolvable | SagemakerProjectServiceCatalogProvisioningDetailsProvisioningParameter[] | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/sagemaker_project aws_sagemaker_project}
*/
export declare class SagemakerProject extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_sagemaker_project";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/sagemaker_project aws_sagemaker_project} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SagemakerProjectConfig
    */
    constructor(scope: Construct, id: string, config: SagemakerProjectConfig);
    get arn(): string;
    get id(): string;
    private _projectDescription?;
    get projectDescription(): string;
    set projectDescription(value: string);
    resetProjectDescription(): void;
    get projectDescriptionInput(): string | undefined;
    get projectId(): string;
    private _projectName?;
    get projectName(): string;
    set projectName(value: string);
    get projectNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _tagsAll?;
    get tagsAll(): {
        [key: string]: string;
    };
    set tagsAll(value: {
        [key: string]: string;
    });
    resetTagsAll(): void;
    get tagsAllInput(): {
        [key: string]: string;
    } | undefined;
    private _serviceCatalogProvisioningDetails;
    get serviceCatalogProvisioningDetails(): SagemakerProjectServiceCatalogProvisioningDetailsOutputReference;
    putServiceCatalogProvisioningDetails(value: SagemakerProjectServiceCatalogProvisioningDetails): void;
    get serviceCatalogProvisioningDetailsInput(): SagemakerProjectServiceCatalogProvisioningDetails | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=sagemaker-project.d.ts.map