"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SagemakerProject = exports.SagemakerProjectServiceCatalogProvisioningDetailsOutputReference = exports.sagemakerProjectServiceCatalogProvisioningDetailsToTerraform = exports.sagemakerProjectServiceCatalogProvisioningDetailsProvisioningParameterToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function sagemakerProjectServiceCatalogProvisioningDetailsProvisioningParameterToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        key: cdktf.stringToTerraform(struct.key),
        value: cdktf.stringToTerraform(struct.value),
    };
}
exports.sagemakerProjectServiceCatalogProvisioningDetailsProvisioningParameterToTerraform = sagemakerProjectServiceCatalogProvisioningDetailsProvisioningParameterToTerraform;
function sagemakerProjectServiceCatalogProvisioningDetailsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        path_id: cdktf.stringToTerraform(struct.pathId),
        product_id: cdktf.stringToTerraform(struct.productId),
        provisioning_artifact_id: cdktf.stringToTerraform(struct.provisioningArtifactId),
        provisioning_parameter: cdktf.listMapper(sagemakerProjectServiceCatalogProvisioningDetailsProvisioningParameterToTerraform)(struct.provisioningParameter),
    };
}
exports.sagemakerProjectServiceCatalogProvisioningDetailsToTerraform = sagemakerProjectServiceCatalogProvisioningDetailsToTerraform;
class SagemakerProjectServiceCatalogProvisioningDetailsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._pathId !== undefined) {
            hasAnyValues = true;
            internalValueResult.pathId = this._pathId;
        }
        if (this._productId !== undefined) {
            hasAnyValues = true;
            internalValueResult.productId = this._productId;
        }
        if (this._provisioningArtifactId !== undefined) {
            hasAnyValues = true;
            internalValueResult.provisioningArtifactId = this._provisioningArtifactId;
        }
        if (this._provisioningParameter !== undefined) {
            hasAnyValues = true;
            internalValueResult.provisioningParameter = this._provisioningParameter;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._pathId = undefined;
            this._productId = undefined;
            this._provisioningArtifactId = undefined;
            this._provisioningParameter = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._pathId = value.pathId;
            this._productId = value.productId;
            this._provisioningArtifactId = value.provisioningArtifactId;
            this._provisioningParameter = value.provisioningParameter;
        }
    }
    get pathId() {
        return this.getStringAttribute('path_id');
    }
    set pathId(value) {
        this._pathId = value;
    }
    resetPathId() {
        this._pathId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get pathIdInput() {
        return this._pathId;
    }
    get productId() {
        return this.getStringAttribute('product_id');
    }
    set productId(value) {
        this._productId = value;
    }
    // Temporarily expose input value. Use with caution.
    get productIdInput() {
        return this._productId;
    }
    get provisioningArtifactId() {
        return this.getStringAttribute('provisioning_artifact_id');
    }
    set provisioningArtifactId(value) {
        this._provisioningArtifactId = value;
    }
    resetProvisioningArtifactId() {
        this._provisioningArtifactId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get provisioningArtifactIdInput() {
        return this._provisioningArtifactId;
    }
    get provisioningParameter() {
        // Getting the computed value is not yet implemented
        return this.interpolationForAttribute('provisioning_parameter');
    }
    set provisioningParameter(value) {
        this._provisioningParameter = value;
    }
    resetProvisioningParameter() {
        this._provisioningParameter = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get provisioningParameterInput() {
        return this._provisioningParameter;
    }
}
exports.SagemakerProjectServiceCatalogProvisioningDetailsOutputReference = SagemakerProjectServiceCatalogProvisioningDetailsOutputReference;
_a = JSII_RTTI_SYMBOL_1;
SagemakerProjectServiceCatalogProvisioningDetailsOutputReference[_a] = { fqn: "@cdktf/provider-aws.sagemaker.SagemakerProjectServiceCatalogProvisioningDetailsOutputReference", version: "7.0.64" };
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/sagemaker_project aws_sagemaker_project}
*/
class SagemakerProject extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/sagemaker_project aws_sagemaker_project} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SagemakerProjectConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'aws_sagemaker_project',
            terraformGeneratorMetadata: {
                providerName: 'aws',
                providerVersion: '4.15.1',
                providerVersionConstraint: '~> 4.0'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        // service_catalog_provisioning_details - computed: false, optional: false, required: true
        this._serviceCatalogProvisioningDetails = new SagemakerProjectServiceCatalogProvisioningDetailsOutputReference(this, "service_catalog_provisioning_details");
        this._projectDescription = config.projectDescription;
        this._projectName = config.projectName;
        this._tags = config.tags;
        this._tagsAll = config.tagsAll;
        this._serviceCatalogProvisioningDetails.internalValue = config.serviceCatalogProvisioningDetails;
    }
    // ==========
    // ATTRIBUTES
    // ==========
    // arn - computed: true, optional: false, required: false
    get arn() {
        return this.getStringAttribute('arn');
    }
    // id - computed: true, optional: true, required: false
    get id() {
        return this.getStringAttribute('id');
    }
    get projectDescription() {
        return this.getStringAttribute('project_description');
    }
    set projectDescription(value) {
        this._projectDescription = value;
    }
    resetProjectDescription() {
        this._projectDescription = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get projectDescriptionInput() {
        return this._projectDescription;
    }
    // project_id - computed: true, optional: false, required: false
    get projectId() {
        return this.getStringAttribute('project_id');
    }
    get projectName() {
        return this.getStringAttribute('project_name');
    }
    set projectName(value) {
        this._projectName = value;
    }
    // Temporarily expose input value. Use with caution.
    get projectNameInput() {
        return this._projectName;
    }
    get tags() {
        return this.getStringMapAttribute('tags');
    }
    set tags(value) {
        this._tags = value;
    }
    resetTags() {
        this._tags = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tagsInput() {
        return this._tags;
    }
    get tagsAll() {
        return this.getStringMapAttribute('tags_all');
    }
    set tagsAll(value) {
        this._tagsAll = value;
    }
    resetTagsAll() {
        this._tagsAll = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tagsAllInput() {
        return this._tagsAll;
    }
    get serviceCatalogProvisioningDetails() {
        return this._serviceCatalogProvisioningDetails;
    }
    putServiceCatalogProvisioningDetails(value) {
        this._serviceCatalogProvisioningDetails.internalValue = value;
    }
    // Temporarily expose input value. Use with caution.
    get serviceCatalogProvisioningDetailsInput() {
        return this._serviceCatalogProvisioningDetails.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            project_description: cdktf.stringToTerraform(this._projectDescription),
            project_name: cdktf.stringToTerraform(this._projectName),
            tags: cdktf.hashMapper(cdktf.stringToTerraform)(this._tags),
            tags_all: cdktf.hashMapper(cdktf.stringToTerraform)(this._tagsAll),
            service_catalog_provisioning_details: sagemakerProjectServiceCatalogProvisioningDetailsToTerraform(this._serviceCatalogProvisioningDetails.internalValue),
        };
    }
}
exports.SagemakerProject = SagemakerProject;
_b = JSII_RTTI_SYMBOL_1;
SagemakerProject[_b] = { fqn: "@cdktf/provider-aws.sagemaker.SagemakerProject", version: "7.0.64" };
// =================
// STATIC PROPERTIES
// =================
SagemakerProject.tfResourceType = "aws_sagemaker_project";
//# sourceMappingURL=data:application/json;base64,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