import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS SageMaker
*/
export interface SagemakerWorkteamConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/sagemaker_workteam#description SagemakerWorkteam#description}
    */
    readonly description: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/sagemaker_workteam#tags SagemakerWorkteam#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/sagemaker_workteam#tags_all SagemakerWorkteam#tags_all}
    */
    readonly tagsAll?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/sagemaker_workteam#workforce_name SagemakerWorkteam#workforce_name}
    */
    readonly workforceName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/sagemaker_workteam#workteam_name SagemakerWorkteam#workteam_name}
    */
    readonly workteamName: string;
    /**
    * member_definition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/sagemaker_workteam#member_definition SagemakerWorkteam#member_definition}
    */
    readonly memberDefinition: SagemakerWorkteamMemberDefinition[] | cdktf.IResolvable;
    /**
    * notification_configuration block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/sagemaker_workteam#notification_configuration SagemakerWorkteam#notification_configuration}
    */
    readonly notificationConfiguration?: SagemakerWorkteamNotificationConfiguration;
}
export interface SagemakerWorkteamMemberDefinitionCognitoMemberDefinition {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/sagemaker_workteam#client_id SagemakerWorkteam#client_id}
    */
    readonly clientId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/sagemaker_workteam#user_group SagemakerWorkteam#user_group}
    */
    readonly userGroup: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/sagemaker_workteam#user_pool SagemakerWorkteam#user_pool}
    */
    readonly userPool: string;
}
export declare function sagemakerWorkteamMemberDefinitionCognitoMemberDefinitionToTerraform(struct?: SagemakerWorkteamMemberDefinitionCognitoMemberDefinitionOutputReference | SagemakerWorkteamMemberDefinitionCognitoMemberDefinition): any;
export declare class SagemakerWorkteamMemberDefinitionCognitoMemberDefinitionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SagemakerWorkteamMemberDefinitionCognitoMemberDefinition | undefined;
    set internalValue(value: SagemakerWorkteamMemberDefinitionCognitoMemberDefinition | undefined);
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
    private _userGroup?;
    get userGroup(): string;
    set userGroup(value: string);
    get userGroupInput(): string | undefined;
    private _userPool?;
    get userPool(): string;
    set userPool(value: string);
    get userPoolInput(): string | undefined;
}
export interface SagemakerWorkteamMemberDefinitionOidcMemberDefinition {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/sagemaker_workteam#groups SagemakerWorkteam#groups}
    */
    readonly groups: string[];
}
export declare function sagemakerWorkteamMemberDefinitionOidcMemberDefinitionToTerraform(struct?: SagemakerWorkteamMemberDefinitionOidcMemberDefinitionOutputReference | SagemakerWorkteamMemberDefinitionOidcMemberDefinition): any;
export declare class SagemakerWorkteamMemberDefinitionOidcMemberDefinitionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SagemakerWorkteamMemberDefinitionOidcMemberDefinition | undefined;
    set internalValue(value: SagemakerWorkteamMemberDefinitionOidcMemberDefinition | undefined);
    private _groups?;
    get groups(): string[];
    set groups(value: string[]);
    get groupsInput(): string[] | undefined;
}
export interface SagemakerWorkteamMemberDefinition {
    /**
    * cognito_member_definition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/sagemaker_workteam#cognito_member_definition SagemakerWorkteam#cognito_member_definition}
    */
    readonly cognitoMemberDefinition?: SagemakerWorkteamMemberDefinitionCognitoMemberDefinition;
    /**
    * oidc_member_definition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/sagemaker_workteam#oidc_member_definition SagemakerWorkteam#oidc_member_definition}
    */
    readonly oidcMemberDefinition?: SagemakerWorkteamMemberDefinitionOidcMemberDefinition;
}
export declare function sagemakerWorkteamMemberDefinitionToTerraform(struct?: SagemakerWorkteamMemberDefinition | cdktf.IResolvable): any;
export interface SagemakerWorkteamNotificationConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/sagemaker_workteam#notification_topic_arn SagemakerWorkteam#notification_topic_arn}
    */
    readonly notificationTopicArn?: string;
}
export declare function sagemakerWorkteamNotificationConfigurationToTerraform(struct?: SagemakerWorkteamNotificationConfigurationOutputReference | SagemakerWorkteamNotificationConfiguration): any;
export declare class SagemakerWorkteamNotificationConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SagemakerWorkteamNotificationConfiguration | undefined;
    set internalValue(value: SagemakerWorkteamNotificationConfiguration | undefined);
    private _notificationTopicArn?;
    get notificationTopicArn(): string;
    set notificationTopicArn(value: string);
    resetNotificationTopicArn(): void;
    get notificationTopicArnInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/sagemaker_workteam aws_sagemaker_workteam}
*/
export declare class SagemakerWorkteam extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_sagemaker_workteam";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/sagemaker_workteam aws_sagemaker_workteam} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SagemakerWorkteamConfig
    */
    constructor(scope: Construct, id: string, config: SagemakerWorkteamConfig);
    get arn(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    get descriptionInput(): string | undefined;
    get id(): string;
    get subdomain(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _tagsAll?;
    get tagsAll(): {
        [key: string]: string;
    };
    set tagsAll(value: {
        [key: string]: string;
    });
    resetTagsAll(): void;
    get tagsAllInput(): {
        [key: string]: string;
    } | undefined;
    private _workforceName?;
    get workforceName(): string;
    set workforceName(value: string);
    get workforceNameInput(): string | undefined;
    private _workteamName?;
    get workteamName(): string;
    set workteamName(value: string);
    get workteamNameInput(): string | undefined;
    private _memberDefinition?;
    get memberDefinition(): SagemakerWorkteamMemberDefinition[] | cdktf.IResolvable;
    set memberDefinition(value: SagemakerWorkteamMemberDefinition[] | cdktf.IResolvable);
    get memberDefinitionInput(): cdktf.IResolvable | SagemakerWorkteamMemberDefinition[] | undefined;
    private _notificationConfiguration;
    get notificationConfiguration(): SagemakerWorkteamNotificationConfigurationOutputReference;
    putNotificationConfiguration(value: SagemakerWorkteamNotificationConfiguration): void;
    resetNotificationConfiguration(): void;
    get notificationConfigurationInput(): SagemakerWorkteamNotificationConfiguration | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=sagemaker-workteam.d.ts.map