import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Secrets Manager
*/
export interface DataAwsSecretsmanagerSecretRotationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/secretsmanager_secret_rotation#secret_id DataAwsSecretsmanagerSecretRotation#secret_id}
    */
    readonly secretId: string;
}
export interface DataAwsSecretsmanagerSecretRotationRotationRules {
}
export declare function dataAwsSecretsmanagerSecretRotationRotationRulesToTerraform(struct?: DataAwsSecretsmanagerSecretRotationRotationRules): any;
export declare class DataAwsSecretsmanagerSecretRotationRotationRulesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAwsSecretsmanagerSecretRotationRotationRules | undefined;
    set internalValue(value: DataAwsSecretsmanagerSecretRotationRotationRules | undefined);
    get automaticallyAfterDays(): number;
}
export declare class DataAwsSecretsmanagerSecretRotationRotationRulesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAwsSecretsmanagerSecretRotationRotationRulesOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/d/secretsmanager_secret_rotation aws_secretsmanager_secret_rotation}
*/
export declare class DataAwsSecretsmanagerSecretRotation extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "aws_secretsmanager_secret_rotation";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/d/secretsmanager_secret_rotation aws_secretsmanager_secret_rotation} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAwsSecretsmanagerSecretRotationConfig
    */
    constructor(scope: Construct, id: string, config: DataAwsSecretsmanagerSecretRotationConfig);
    get id(): string;
    get rotationEnabled(): cdktf.IResolvable;
    get rotationLambdaArn(): string;
    private _rotationRules;
    get rotationRules(): DataAwsSecretsmanagerSecretRotationRotationRulesList;
    private _secretId?;
    get secretId(): string;
    set secretId(value: string);
    get secretIdInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-aws-secretsmanager-secret-rotation.d.ts.map