import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Secrets Manager
*/
export interface DataAwsSecretsmanagerSecretConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/secretsmanager_secret#arn DataAwsSecretsmanagerSecret#arn}
    */
    readonly arn?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/secretsmanager_secret#name DataAwsSecretsmanagerSecret#name}
    */
    readonly name?: string;
}
export interface DataAwsSecretsmanagerSecretRotationRules {
}
export declare function dataAwsSecretsmanagerSecretRotationRulesToTerraform(struct?: DataAwsSecretsmanagerSecretRotationRules): any;
export declare class DataAwsSecretsmanagerSecretRotationRulesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAwsSecretsmanagerSecretRotationRules | undefined;
    set internalValue(value: DataAwsSecretsmanagerSecretRotationRules | undefined);
    get automaticallyAfterDays(): number;
}
export declare class DataAwsSecretsmanagerSecretRotationRulesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAwsSecretsmanagerSecretRotationRulesOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/d/secretsmanager_secret aws_secretsmanager_secret}
*/
export declare class DataAwsSecretsmanagerSecret extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "aws_secretsmanager_secret";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/d/secretsmanager_secret aws_secretsmanager_secret} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAwsSecretsmanagerSecretConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataAwsSecretsmanagerSecretConfig);
    private _arn?;
    get arn(): string;
    set arn(value: string);
    resetArn(): void;
    get arnInput(): string | undefined;
    get description(): string;
    get id(): string;
    get kmsKeyId(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    get policy(): string;
    get rotationEnabled(): cdktf.IResolvable;
    get rotationLambdaArn(): string;
    private _rotationRules;
    get rotationRules(): DataAwsSecretsmanagerSecretRotationRulesList;
    tags(key: string): string | cdktf.IResolvable;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-aws-secretsmanager-secret.d.ts.map