import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Secrets Manager
*/
export interface DataAwsSecretsmanagerSecretsConfig extends cdktf.TerraformMetaArguments {
    /**
    * filter block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/secretsmanager_secrets#filter DataAwsSecretsmanagerSecrets#filter}
    */
    readonly filter?: DataAwsSecretsmanagerSecretsFilter[] | cdktf.IResolvable;
}
export interface DataAwsSecretsmanagerSecretsFilter {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/secretsmanager_secrets#name DataAwsSecretsmanagerSecrets#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/secretsmanager_secrets#values DataAwsSecretsmanagerSecrets#values}
    */
    readonly values: string[];
}
export declare function dataAwsSecretsmanagerSecretsFilterToTerraform(struct?: DataAwsSecretsmanagerSecretsFilter | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/d/secretsmanager_secrets aws_secretsmanager_secrets}
*/
export declare class DataAwsSecretsmanagerSecrets extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "aws_secretsmanager_secrets";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/d/secretsmanager_secrets aws_secretsmanager_secrets} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAwsSecretsmanagerSecretsConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataAwsSecretsmanagerSecretsConfig);
    get arns(): string[];
    get id(): string;
    get names(): string[];
    private _filter?;
    get filter(): DataAwsSecretsmanagerSecretsFilter[] | cdktf.IResolvable;
    set filter(value: DataAwsSecretsmanagerSecretsFilter[] | cdktf.IResolvable);
    resetFilter(): void;
    get filterInput(): cdktf.IResolvable | DataAwsSecretsmanagerSecretsFilter[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-aws-secretsmanager-secrets.d.ts.map