import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Security Hub
*/
export interface SecurityhubInsightConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#group_by_attribute SecurityhubInsight#group_by_attribute}
    */
    readonly groupByAttribute: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#name SecurityhubInsight#name}
    */
    readonly name: string;
    /**
    * filters block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#filters SecurityhubInsight#filters}
    */
    readonly filters: SecurityhubInsightFilters;
}
export interface SecurityhubInsightFiltersAwsAccountId {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#comparison SecurityhubInsight#comparison}
    */
    readonly comparison: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#value SecurityhubInsight#value}
    */
    readonly value: string;
}
export declare function securityhubInsightFiltersAwsAccountIdToTerraform(struct?: SecurityhubInsightFiltersAwsAccountId | cdktf.IResolvable): any;
export interface SecurityhubInsightFiltersCompanyName {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#comparison SecurityhubInsight#comparison}
    */
    readonly comparison: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#value SecurityhubInsight#value}
    */
    readonly value: string;
}
export declare function securityhubInsightFiltersCompanyNameToTerraform(struct?: SecurityhubInsightFiltersCompanyName | cdktf.IResolvable): any;
export interface SecurityhubInsightFiltersComplianceStatus {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#comparison SecurityhubInsight#comparison}
    */
    readonly comparison: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#value SecurityhubInsight#value}
    */
    readonly value: string;
}
export declare function securityhubInsightFiltersComplianceStatusToTerraform(struct?: SecurityhubInsightFiltersComplianceStatus | cdktf.IResolvable): any;
export interface SecurityhubInsightFiltersConfidence {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#eq SecurityhubInsight#eq}
    */
    readonly eq?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#gte SecurityhubInsight#gte}
    */
    readonly gte?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#lte SecurityhubInsight#lte}
    */
    readonly lte?: string;
}
export declare function securityhubInsightFiltersConfidenceToTerraform(struct?: SecurityhubInsightFiltersConfidence | cdktf.IResolvable): any;
export interface SecurityhubInsightFiltersCreatedAtDateRange {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#unit SecurityhubInsight#unit}
    */
    readonly unit: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#value SecurityhubInsight#value}
    */
    readonly value: number;
}
export declare function securityhubInsightFiltersCreatedAtDateRangeToTerraform(struct?: SecurityhubInsightFiltersCreatedAtDateRangeOutputReference | SecurityhubInsightFiltersCreatedAtDateRange): any;
export declare class SecurityhubInsightFiltersCreatedAtDateRangeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SecurityhubInsightFiltersCreatedAtDateRange | undefined;
    set internalValue(value: SecurityhubInsightFiltersCreatedAtDateRange | undefined);
    private _unit?;
    get unit(): string;
    set unit(value: string);
    get unitInput(): string | undefined;
    private _value?;
    get value(): number;
    set value(value: number);
    get valueInput(): number | undefined;
}
export interface SecurityhubInsightFiltersCreatedAt {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#end SecurityhubInsight#end}
    */
    readonly end?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#start SecurityhubInsight#start}
    */
    readonly start?: string;
    /**
    * date_range block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#date_range SecurityhubInsight#date_range}
    */
    readonly dateRange?: SecurityhubInsightFiltersCreatedAtDateRange;
}
export declare function securityhubInsightFiltersCreatedAtToTerraform(struct?: SecurityhubInsightFiltersCreatedAt | cdktf.IResolvable): any;
export interface SecurityhubInsightFiltersCriticality {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#eq SecurityhubInsight#eq}
    */
    readonly eq?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#gte SecurityhubInsight#gte}
    */
    readonly gte?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#lte SecurityhubInsight#lte}
    */
    readonly lte?: string;
}
export declare function securityhubInsightFiltersCriticalityToTerraform(struct?: SecurityhubInsightFiltersCriticality | cdktf.IResolvable): any;
export interface SecurityhubInsightFiltersDescription {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#comparison SecurityhubInsight#comparison}
    */
    readonly comparison: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#value SecurityhubInsight#value}
    */
    readonly value: string;
}
export declare function securityhubInsightFiltersDescriptionToTerraform(struct?: SecurityhubInsightFiltersDescription | cdktf.IResolvable): any;
export interface SecurityhubInsightFiltersFindingProviderFieldsConfidence {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#eq SecurityhubInsight#eq}
    */
    readonly eq?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#gte SecurityhubInsight#gte}
    */
    readonly gte?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#lte SecurityhubInsight#lte}
    */
    readonly lte?: string;
}
export declare function securityhubInsightFiltersFindingProviderFieldsConfidenceToTerraform(struct?: SecurityhubInsightFiltersFindingProviderFieldsConfidence | cdktf.IResolvable): any;
export interface SecurityhubInsightFiltersFindingProviderFieldsCriticality {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#eq SecurityhubInsight#eq}
    */
    readonly eq?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#gte SecurityhubInsight#gte}
    */
    readonly gte?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#lte SecurityhubInsight#lte}
    */
    readonly lte?: string;
}
export declare function securityhubInsightFiltersFindingProviderFieldsCriticalityToTerraform(struct?: SecurityhubInsightFiltersFindingProviderFieldsCriticality | cdktf.IResolvable): any;
export interface SecurityhubInsightFiltersFindingProviderFieldsRelatedFindingsId {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#comparison SecurityhubInsight#comparison}
    */
    readonly comparison: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#value SecurityhubInsight#value}
    */
    readonly value: string;
}
export declare function securityhubInsightFiltersFindingProviderFieldsRelatedFindingsIdToTerraform(struct?: SecurityhubInsightFiltersFindingProviderFieldsRelatedFindingsId | cdktf.IResolvable): any;
export interface SecurityhubInsightFiltersFindingProviderFieldsRelatedFindingsProductArn {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#comparison SecurityhubInsight#comparison}
    */
    readonly comparison: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#value SecurityhubInsight#value}
    */
    readonly value: string;
}
export declare function securityhubInsightFiltersFindingProviderFieldsRelatedFindingsProductArnToTerraform(struct?: SecurityhubInsightFiltersFindingProviderFieldsRelatedFindingsProductArn | cdktf.IResolvable): any;
export interface SecurityhubInsightFiltersFindingProviderFieldsSeverityLabel {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#comparison SecurityhubInsight#comparison}
    */
    readonly comparison: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#value SecurityhubInsight#value}
    */
    readonly value: string;
}
export declare function securityhubInsightFiltersFindingProviderFieldsSeverityLabelToTerraform(struct?: SecurityhubInsightFiltersFindingProviderFieldsSeverityLabel | cdktf.IResolvable): any;
export interface SecurityhubInsightFiltersFindingProviderFieldsSeverityOriginal {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#comparison SecurityhubInsight#comparison}
    */
    readonly comparison: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#value SecurityhubInsight#value}
    */
    readonly value: string;
}
export declare function securityhubInsightFiltersFindingProviderFieldsSeverityOriginalToTerraform(struct?: SecurityhubInsightFiltersFindingProviderFieldsSeverityOriginal | cdktf.IResolvable): any;
export interface SecurityhubInsightFiltersFindingProviderFieldsTypes {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#comparison SecurityhubInsight#comparison}
    */
    readonly comparison: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#value SecurityhubInsight#value}
    */
    readonly value: string;
}
export declare function securityhubInsightFiltersFindingProviderFieldsTypesToTerraform(struct?: SecurityhubInsightFiltersFindingProviderFieldsTypes | cdktf.IResolvable): any;
export interface SecurityhubInsightFiltersFirstObservedAtDateRange {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#unit SecurityhubInsight#unit}
    */
    readonly unit: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#value SecurityhubInsight#value}
    */
    readonly value: number;
}
export declare function securityhubInsightFiltersFirstObservedAtDateRangeToTerraform(struct?: SecurityhubInsightFiltersFirstObservedAtDateRangeOutputReference | SecurityhubInsightFiltersFirstObservedAtDateRange): any;
export declare class SecurityhubInsightFiltersFirstObservedAtDateRangeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SecurityhubInsightFiltersFirstObservedAtDateRange | undefined;
    set internalValue(value: SecurityhubInsightFiltersFirstObservedAtDateRange | undefined);
    private _unit?;
    get unit(): string;
    set unit(value: string);
    get unitInput(): string | undefined;
    private _value?;
    get value(): number;
    set value(value: number);
    get valueInput(): number | undefined;
}
export interface SecurityhubInsightFiltersFirstObservedAt {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#end SecurityhubInsight#end}
    */
    readonly end?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#start SecurityhubInsight#start}
    */
    readonly start?: string;
    /**
    * date_range block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#date_range SecurityhubInsight#date_range}
    */
    readonly dateRange?: SecurityhubInsightFiltersFirstObservedAtDateRange;
}
export declare function securityhubInsightFiltersFirstObservedAtToTerraform(struct?: SecurityhubInsightFiltersFirstObservedAt | cdktf.IResolvable): any;
export interface SecurityhubInsightFiltersGeneratorId {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#comparison SecurityhubInsight#comparison}
    */
    readonly comparison: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#value SecurityhubInsight#value}
    */
    readonly value: string;
}
export declare function securityhubInsightFiltersGeneratorIdToTerraform(struct?: SecurityhubInsightFiltersGeneratorId | cdktf.IResolvable): any;
export interface SecurityhubInsightFiltersId {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#comparison SecurityhubInsight#comparison}
    */
    readonly comparison: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#value SecurityhubInsight#value}
    */
    readonly value: string;
}
export declare function securityhubInsightFiltersIdToTerraform(struct?: SecurityhubInsightFiltersId | cdktf.IResolvable): any;
export interface SecurityhubInsightFiltersKeyword {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#value SecurityhubInsight#value}
    */
    readonly value: string;
}
export declare function securityhubInsightFiltersKeywordToTerraform(struct?: SecurityhubInsightFiltersKeyword | cdktf.IResolvable): any;
export interface SecurityhubInsightFiltersLastObservedAtDateRange {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#unit SecurityhubInsight#unit}
    */
    readonly unit: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#value SecurityhubInsight#value}
    */
    readonly value: number;
}
export declare function securityhubInsightFiltersLastObservedAtDateRangeToTerraform(struct?: SecurityhubInsightFiltersLastObservedAtDateRangeOutputReference | SecurityhubInsightFiltersLastObservedAtDateRange): any;
export declare class SecurityhubInsightFiltersLastObservedAtDateRangeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SecurityhubInsightFiltersLastObservedAtDateRange | undefined;
    set internalValue(value: SecurityhubInsightFiltersLastObservedAtDateRange | undefined);
    private _unit?;
    get unit(): string;
    set unit(value: string);
    get unitInput(): string | undefined;
    private _value?;
    get value(): number;
    set value(value: number);
    get valueInput(): number | undefined;
}
export interface SecurityhubInsightFiltersLastObservedAt {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#end SecurityhubInsight#end}
    */
    readonly end?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#start SecurityhubInsight#start}
    */
    readonly start?: string;
    /**
    * date_range block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#date_range SecurityhubInsight#date_range}
    */
    readonly dateRange?: SecurityhubInsightFiltersLastObservedAtDateRange;
}
export declare function securityhubInsightFiltersLastObservedAtToTerraform(struct?: SecurityhubInsightFiltersLastObservedAt | cdktf.IResolvable): any;
export interface SecurityhubInsightFiltersMalwareName {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#comparison SecurityhubInsight#comparison}
    */
    readonly comparison: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#value SecurityhubInsight#value}
    */
    readonly value: string;
}
export declare function securityhubInsightFiltersMalwareNameToTerraform(struct?: SecurityhubInsightFiltersMalwareName | cdktf.IResolvable): any;
export interface SecurityhubInsightFiltersMalwarePath {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#comparison SecurityhubInsight#comparison}
    */
    readonly comparison: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#value SecurityhubInsight#value}
    */
    readonly value: string;
}
export declare function securityhubInsightFiltersMalwarePathToTerraform(struct?: SecurityhubInsightFiltersMalwarePath | cdktf.IResolvable): any;
export interface SecurityhubInsightFiltersMalwareState {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#comparison SecurityhubInsight#comparison}
    */
    readonly comparison: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#value SecurityhubInsight#value}
    */
    readonly value: string;
}
export declare function securityhubInsightFiltersMalwareStateToTerraform(struct?: SecurityhubInsightFiltersMalwareState | cdktf.IResolvable): any;
export interface SecurityhubInsightFiltersMalwareType {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#comparison SecurityhubInsight#comparison}
    */
    readonly comparison: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#value SecurityhubInsight#value}
    */
    readonly value: string;
}
export declare function securityhubInsightFiltersMalwareTypeToTerraform(struct?: SecurityhubInsightFiltersMalwareType | cdktf.IResolvable): any;
export interface SecurityhubInsightFiltersNetworkDestinationDomain {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#comparison SecurityhubInsight#comparison}
    */
    readonly comparison: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#value SecurityhubInsight#value}
    */
    readonly value: string;
}
export declare function securityhubInsightFiltersNetworkDestinationDomainToTerraform(struct?: SecurityhubInsightFiltersNetworkDestinationDomain | cdktf.IResolvable): any;
export interface SecurityhubInsightFiltersNetworkDestinationIpv4 {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#cidr SecurityhubInsight#cidr}
    */
    readonly cidr: string;
}
export declare function securityhubInsightFiltersNetworkDestinationIpv4ToTerraform(struct?: SecurityhubInsightFiltersNetworkDestinationIpv4 | cdktf.IResolvable): any;
export interface SecurityhubInsightFiltersNetworkDestinationIpv6 {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#cidr SecurityhubInsight#cidr}
    */
    readonly cidr: string;
}
export declare function securityhubInsightFiltersNetworkDestinationIpv6ToTerraform(struct?: SecurityhubInsightFiltersNetworkDestinationIpv6 | cdktf.IResolvable): any;
export interface SecurityhubInsightFiltersNetworkDestinationPort {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#eq SecurityhubInsight#eq}
    */
    readonly eq?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#gte SecurityhubInsight#gte}
    */
    readonly gte?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#lte SecurityhubInsight#lte}
    */
    readonly lte?: string;
}
export declare function securityhubInsightFiltersNetworkDestinationPortToTerraform(struct?: SecurityhubInsightFiltersNetworkDestinationPort | cdktf.IResolvable): any;
export interface SecurityhubInsightFiltersNetworkDirection {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#comparison SecurityhubInsight#comparison}
    */
    readonly comparison: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#value SecurityhubInsight#value}
    */
    readonly value: string;
}
export declare function securityhubInsightFiltersNetworkDirectionToTerraform(struct?: SecurityhubInsightFiltersNetworkDirection | cdktf.IResolvable): any;
export interface SecurityhubInsightFiltersNetworkProtocol {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#comparison SecurityhubInsight#comparison}
    */
    readonly comparison: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#value SecurityhubInsight#value}
    */
    readonly value: string;
}
export declare function securityhubInsightFiltersNetworkProtocolToTerraform(struct?: SecurityhubInsightFiltersNetworkProtocol | cdktf.IResolvable): any;
export interface SecurityhubInsightFiltersNetworkSourceDomain {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#comparison SecurityhubInsight#comparison}
    */
    readonly comparison: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#value SecurityhubInsight#value}
    */
    readonly value: string;
}
export declare function securityhubInsightFiltersNetworkSourceDomainToTerraform(struct?: SecurityhubInsightFiltersNetworkSourceDomain | cdktf.IResolvable): any;
export interface SecurityhubInsightFiltersNetworkSourceIpv4 {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#cidr SecurityhubInsight#cidr}
    */
    readonly cidr: string;
}
export declare function securityhubInsightFiltersNetworkSourceIpv4ToTerraform(struct?: SecurityhubInsightFiltersNetworkSourceIpv4 | cdktf.IResolvable): any;
export interface SecurityhubInsightFiltersNetworkSourceIpv6 {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#cidr SecurityhubInsight#cidr}
    */
    readonly cidr: string;
}
export declare function securityhubInsightFiltersNetworkSourceIpv6ToTerraform(struct?: SecurityhubInsightFiltersNetworkSourceIpv6 | cdktf.IResolvable): any;
export interface SecurityhubInsightFiltersNetworkSourceMac {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#comparison SecurityhubInsight#comparison}
    */
    readonly comparison: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#value SecurityhubInsight#value}
    */
    readonly value: string;
}
export declare function securityhubInsightFiltersNetworkSourceMacToTerraform(struct?: SecurityhubInsightFiltersNetworkSourceMac | cdktf.IResolvable): any;
export interface SecurityhubInsightFiltersNetworkSourcePort {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#eq SecurityhubInsight#eq}
    */
    readonly eq?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#gte SecurityhubInsight#gte}
    */
    readonly gte?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#lte SecurityhubInsight#lte}
    */
    readonly lte?: string;
}
export declare function securityhubInsightFiltersNetworkSourcePortToTerraform(struct?: SecurityhubInsightFiltersNetworkSourcePort | cdktf.IResolvable): any;
export interface SecurityhubInsightFiltersNoteText {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#comparison SecurityhubInsight#comparison}
    */
    readonly comparison: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#value SecurityhubInsight#value}
    */
    readonly value: string;
}
export declare function securityhubInsightFiltersNoteTextToTerraform(struct?: SecurityhubInsightFiltersNoteText | cdktf.IResolvable): any;
export interface SecurityhubInsightFiltersNoteUpdatedAtDateRange {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#unit SecurityhubInsight#unit}
    */
    readonly unit: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#value SecurityhubInsight#value}
    */
    readonly value: number;
}
export declare function securityhubInsightFiltersNoteUpdatedAtDateRangeToTerraform(struct?: SecurityhubInsightFiltersNoteUpdatedAtDateRangeOutputReference | SecurityhubInsightFiltersNoteUpdatedAtDateRange): any;
export declare class SecurityhubInsightFiltersNoteUpdatedAtDateRangeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SecurityhubInsightFiltersNoteUpdatedAtDateRange | undefined;
    set internalValue(value: SecurityhubInsightFiltersNoteUpdatedAtDateRange | undefined);
    private _unit?;
    get unit(): string;
    set unit(value: string);
    get unitInput(): string | undefined;
    private _value?;
    get value(): number;
    set value(value: number);
    get valueInput(): number | undefined;
}
export interface SecurityhubInsightFiltersNoteUpdatedAt {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#end SecurityhubInsight#end}
    */
    readonly end?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#start SecurityhubInsight#start}
    */
    readonly start?: string;
    /**
    * date_range block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#date_range SecurityhubInsight#date_range}
    */
    readonly dateRange?: SecurityhubInsightFiltersNoteUpdatedAtDateRange;
}
export declare function securityhubInsightFiltersNoteUpdatedAtToTerraform(struct?: SecurityhubInsightFiltersNoteUpdatedAt | cdktf.IResolvable): any;
export interface SecurityhubInsightFiltersNoteUpdatedBy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#comparison SecurityhubInsight#comparison}
    */
    readonly comparison: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#value SecurityhubInsight#value}
    */
    readonly value: string;
}
export declare function securityhubInsightFiltersNoteUpdatedByToTerraform(struct?: SecurityhubInsightFiltersNoteUpdatedBy | cdktf.IResolvable): any;
export interface SecurityhubInsightFiltersProcessLaunchedAtDateRange {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#unit SecurityhubInsight#unit}
    */
    readonly unit: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#value SecurityhubInsight#value}
    */
    readonly value: number;
}
export declare function securityhubInsightFiltersProcessLaunchedAtDateRangeToTerraform(struct?: SecurityhubInsightFiltersProcessLaunchedAtDateRangeOutputReference | SecurityhubInsightFiltersProcessLaunchedAtDateRange): any;
export declare class SecurityhubInsightFiltersProcessLaunchedAtDateRangeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SecurityhubInsightFiltersProcessLaunchedAtDateRange | undefined;
    set internalValue(value: SecurityhubInsightFiltersProcessLaunchedAtDateRange | undefined);
    private _unit?;
    get unit(): string;
    set unit(value: string);
    get unitInput(): string | undefined;
    private _value?;
    get value(): number;
    set value(value: number);
    get valueInput(): number | undefined;
}
export interface SecurityhubInsightFiltersProcessLaunchedAt {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#end SecurityhubInsight#end}
    */
    readonly end?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#start SecurityhubInsight#start}
    */
    readonly start?: string;
    /**
    * date_range block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#date_range SecurityhubInsight#date_range}
    */
    readonly dateRange?: SecurityhubInsightFiltersProcessLaunchedAtDateRange;
}
export declare function securityhubInsightFiltersProcessLaunchedAtToTerraform(struct?: SecurityhubInsightFiltersProcessLaunchedAt | cdktf.IResolvable): any;
export interface SecurityhubInsightFiltersProcessName {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#comparison SecurityhubInsight#comparison}
    */
    readonly comparison: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#value SecurityhubInsight#value}
    */
    readonly value: string;
}
export declare function securityhubInsightFiltersProcessNameToTerraform(struct?: SecurityhubInsightFiltersProcessName | cdktf.IResolvable): any;
export interface SecurityhubInsightFiltersProcessParentPid {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#eq SecurityhubInsight#eq}
    */
    readonly eq?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#gte SecurityhubInsight#gte}
    */
    readonly gte?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#lte SecurityhubInsight#lte}
    */
    readonly lte?: string;
}
export declare function securityhubInsightFiltersProcessParentPidToTerraform(struct?: SecurityhubInsightFiltersProcessParentPid | cdktf.IResolvable): any;
export interface SecurityhubInsightFiltersProcessPath {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#comparison SecurityhubInsight#comparison}
    */
    readonly comparison: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#value SecurityhubInsight#value}
    */
    readonly value: string;
}
export declare function securityhubInsightFiltersProcessPathToTerraform(struct?: SecurityhubInsightFiltersProcessPath | cdktf.IResolvable): any;
export interface SecurityhubInsightFiltersProcessPid {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#eq SecurityhubInsight#eq}
    */
    readonly eq?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#gte SecurityhubInsight#gte}
    */
    readonly gte?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#lte SecurityhubInsight#lte}
    */
    readonly lte?: string;
}
export declare function securityhubInsightFiltersProcessPidToTerraform(struct?: SecurityhubInsightFiltersProcessPid | cdktf.IResolvable): any;
export interface SecurityhubInsightFiltersProcessTerminatedAtDateRange {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#unit SecurityhubInsight#unit}
    */
    readonly unit: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#value SecurityhubInsight#value}
    */
    readonly value: number;
}
export declare function securityhubInsightFiltersProcessTerminatedAtDateRangeToTerraform(struct?: SecurityhubInsightFiltersProcessTerminatedAtDateRangeOutputReference | SecurityhubInsightFiltersProcessTerminatedAtDateRange): any;
export declare class SecurityhubInsightFiltersProcessTerminatedAtDateRangeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SecurityhubInsightFiltersProcessTerminatedAtDateRange | undefined;
    set internalValue(value: SecurityhubInsightFiltersProcessTerminatedAtDateRange | undefined);
    private _unit?;
    get unit(): string;
    set unit(value: string);
    get unitInput(): string | undefined;
    private _value?;
    get value(): number;
    set value(value: number);
    get valueInput(): number | undefined;
}
export interface SecurityhubInsightFiltersProcessTerminatedAt {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#end SecurityhubInsight#end}
    */
    readonly end?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#start SecurityhubInsight#start}
    */
    readonly start?: string;
    /**
    * date_range block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#date_range SecurityhubInsight#date_range}
    */
    readonly dateRange?: SecurityhubInsightFiltersProcessTerminatedAtDateRange;
}
export declare function securityhubInsightFiltersProcessTerminatedAtToTerraform(struct?: SecurityhubInsightFiltersProcessTerminatedAt | cdktf.IResolvable): any;
export interface SecurityhubInsightFiltersProductArn {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#comparison SecurityhubInsight#comparison}
    */
    readonly comparison: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#value SecurityhubInsight#value}
    */
    readonly value: string;
}
export declare function securityhubInsightFiltersProductArnToTerraform(struct?: SecurityhubInsightFiltersProductArn | cdktf.IResolvable): any;
export interface SecurityhubInsightFiltersProductFields {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#comparison SecurityhubInsight#comparison}
    */
    readonly comparison: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#key SecurityhubInsight#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#value SecurityhubInsight#value}
    */
    readonly value: string;
}
export declare function securityhubInsightFiltersProductFieldsToTerraform(struct?: SecurityhubInsightFiltersProductFields | cdktf.IResolvable): any;
export interface SecurityhubInsightFiltersProductName {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#comparison SecurityhubInsight#comparison}
    */
    readonly comparison: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#value SecurityhubInsight#value}
    */
    readonly value: string;
}
export declare function securityhubInsightFiltersProductNameToTerraform(struct?: SecurityhubInsightFiltersProductName | cdktf.IResolvable): any;
export interface SecurityhubInsightFiltersRecommendationText {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#comparison SecurityhubInsight#comparison}
    */
    readonly comparison: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#value SecurityhubInsight#value}
    */
    readonly value: string;
}
export declare function securityhubInsightFiltersRecommendationTextToTerraform(struct?: SecurityhubInsightFiltersRecommendationText | cdktf.IResolvable): any;
export interface SecurityhubInsightFiltersRecordState {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#comparison SecurityhubInsight#comparison}
    */
    readonly comparison: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#value SecurityhubInsight#value}
    */
    readonly value: string;
}
export declare function securityhubInsightFiltersRecordStateToTerraform(struct?: SecurityhubInsightFiltersRecordState | cdktf.IResolvable): any;
export interface SecurityhubInsightFiltersRelatedFindingsId {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#comparison SecurityhubInsight#comparison}
    */
    readonly comparison: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#value SecurityhubInsight#value}
    */
    readonly value: string;
}
export declare function securityhubInsightFiltersRelatedFindingsIdToTerraform(struct?: SecurityhubInsightFiltersRelatedFindingsId | cdktf.IResolvable): any;
export interface SecurityhubInsightFiltersRelatedFindingsProductArn {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#comparison SecurityhubInsight#comparison}
    */
    readonly comparison: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#value SecurityhubInsight#value}
    */
    readonly value: string;
}
export declare function securityhubInsightFiltersRelatedFindingsProductArnToTerraform(struct?: SecurityhubInsightFiltersRelatedFindingsProductArn | cdktf.IResolvable): any;
export interface SecurityhubInsightFiltersResourceAwsEc2InstanceIamInstanceProfileArn {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#comparison SecurityhubInsight#comparison}
    */
    readonly comparison: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#value SecurityhubInsight#value}
    */
    readonly value: string;
}
export declare function securityhubInsightFiltersResourceAwsEc2InstanceIamInstanceProfileArnToTerraform(struct?: SecurityhubInsightFiltersResourceAwsEc2InstanceIamInstanceProfileArn | cdktf.IResolvable): any;
export interface SecurityhubInsightFiltersResourceAwsEc2InstanceImageId {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#comparison SecurityhubInsight#comparison}
    */
    readonly comparison: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#value SecurityhubInsight#value}
    */
    readonly value: string;
}
export declare function securityhubInsightFiltersResourceAwsEc2InstanceImageIdToTerraform(struct?: SecurityhubInsightFiltersResourceAwsEc2InstanceImageId | cdktf.IResolvable): any;
export interface SecurityhubInsightFiltersResourceAwsEc2InstanceIpv4Addresses {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#cidr SecurityhubInsight#cidr}
    */
    readonly cidr: string;
}
export declare function securityhubInsightFiltersResourceAwsEc2InstanceIpv4AddressesToTerraform(struct?: SecurityhubInsightFiltersResourceAwsEc2InstanceIpv4Addresses | cdktf.IResolvable): any;
export interface SecurityhubInsightFiltersResourceAwsEc2InstanceIpv6Addresses {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#cidr SecurityhubInsight#cidr}
    */
    readonly cidr: string;
}
export declare function securityhubInsightFiltersResourceAwsEc2InstanceIpv6AddressesToTerraform(struct?: SecurityhubInsightFiltersResourceAwsEc2InstanceIpv6Addresses | cdktf.IResolvable): any;
export interface SecurityhubInsightFiltersResourceAwsEc2InstanceKeyName {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#comparison SecurityhubInsight#comparison}
    */
    readonly comparison: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#value SecurityhubInsight#value}
    */
    readonly value: string;
}
export declare function securityhubInsightFiltersResourceAwsEc2InstanceKeyNameToTerraform(struct?: SecurityhubInsightFiltersResourceAwsEc2InstanceKeyName | cdktf.IResolvable): any;
export interface SecurityhubInsightFiltersResourceAwsEc2InstanceLaunchedAtDateRange {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#unit SecurityhubInsight#unit}
    */
    readonly unit: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#value SecurityhubInsight#value}
    */
    readonly value: number;
}
export declare function securityhubInsightFiltersResourceAwsEc2InstanceLaunchedAtDateRangeToTerraform(struct?: SecurityhubInsightFiltersResourceAwsEc2InstanceLaunchedAtDateRangeOutputReference | SecurityhubInsightFiltersResourceAwsEc2InstanceLaunchedAtDateRange): any;
export declare class SecurityhubInsightFiltersResourceAwsEc2InstanceLaunchedAtDateRangeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SecurityhubInsightFiltersResourceAwsEc2InstanceLaunchedAtDateRange | undefined;
    set internalValue(value: SecurityhubInsightFiltersResourceAwsEc2InstanceLaunchedAtDateRange | undefined);
    private _unit?;
    get unit(): string;
    set unit(value: string);
    get unitInput(): string | undefined;
    private _value?;
    get value(): number;
    set value(value: number);
    get valueInput(): number | undefined;
}
export interface SecurityhubInsightFiltersResourceAwsEc2InstanceLaunchedAt {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#end SecurityhubInsight#end}
    */
    readonly end?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#start SecurityhubInsight#start}
    */
    readonly start?: string;
    /**
    * date_range block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#date_range SecurityhubInsight#date_range}
    */
    readonly dateRange?: SecurityhubInsightFiltersResourceAwsEc2InstanceLaunchedAtDateRange;
}
export declare function securityhubInsightFiltersResourceAwsEc2InstanceLaunchedAtToTerraform(struct?: SecurityhubInsightFiltersResourceAwsEc2InstanceLaunchedAt | cdktf.IResolvable): any;
export interface SecurityhubInsightFiltersResourceAwsEc2InstanceSubnetId {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#comparison SecurityhubInsight#comparison}
    */
    readonly comparison: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#value SecurityhubInsight#value}
    */
    readonly value: string;
}
export declare function securityhubInsightFiltersResourceAwsEc2InstanceSubnetIdToTerraform(struct?: SecurityhubInsightFiltersResourceAwsEc2InstanceSubnetId | cdktf.IResolvable): any;
export interface SecurityhubInsightFiltersResourceAwsEc2InstanceType {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#comparison SecurityhubInsight#comparison}
    */
    readonly comparison: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#value SecurityhubInsight#value}
    */
    readonly value: string;
}
export declare function securityhubInsightFiltersResourceAwsEc2InstanceTypeToTerraform(struct?: SecurityhubInsightFiltersResourceAwsEc2InstanceType | cdktf.IResolvable): any;
export interface SecurityhubInsightFiltersResourceAwsEc2InstanceVpcId {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#comparison SecurityhubInsight#comparison}
    */
    readonly comparison: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#value SecurityhubInsight#value}
    */
    readonly value: string;
}
export declare function securityhubInsightFiltersResourceAwsEc2InstanceVpcIdToTerraform(struct?: SecurityhubInsightFiltersResourceAwsEc2InstanceVpcId | cdktf.IResolvable): any;
export interface SecurityhubInsightFiltersResourceAwsIamAccessKeyCreatedAtDateRange {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#unit SecurityhubInsight#unit}
    */
    readonly unit: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#value SecurityhubInsight#value}
    */
    readonly value: number;
}
export declare function securityhubInsightFiltersResourceAwsIamAccessKeyCreatedAtDateRangeToTerraform(struct?: SecurityhubInsightFiltersResourceAwsIamAccessKeyCreatedAtDateRangeOutputReference | SecurityhubInsightFiltersResourceAwsIamAccessKeyCreatedAtDateRange): any;
export declare class SecurityhubInsightFiltersResourceAwsIamAccessKeyCreatedAtDateRangeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SecurityhubInsightFiltersResourceAwsIamAccessKeyCreatedAtDateRange | undefined;
    set internalValue(value: SecurityhubInsightFiltersResourceAwsIamAccessKeyCreatedAtDateRange | undefined);
    private _unit?;
    get unit(): string;
    set unit(value: string);
    get unitInput(): string | undefined;
    private _value?;
    get value(): number;
    set value(value: number);
    get valueInput(): number | undefined;
}
export interface SecurityhubInsightFiltersResourceAwsIamAccessKeyCreatedAt {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#end SecurityhubInsight#end}
    */
    readonly end?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#start SecurityhubInsight#start}
    */
    readonly start?: string;
    /**
    * date_range block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#date_range SecurityhubInsight#date_range}
    */
    readonly dateRange?: SecurityhubInsightFiltersResourceAwsIamAccessKeyCreatedAtDateRange;
}
export declare function securityhubInsightFiltersResourceAwsIamAccessKeyCreatedAtToTerraform(struct?: SecurityhubInsightFiltersResourceAwsIamAccessKeyCreatedAt | cdktf.IResolvable): any;
export interface SecurityhubInsightFiltersResourceAwsIamAccessKeyStatus {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#comparison SecurityhubInsight#comparison}
    */
    readonly comparison: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#value SecurityhubInsight#value}
    */
    readonly value: string;
}
export declare function securityhubInsightFiltersResourceAwsIamAccessKeyStatusToTerraform(struct?: SecurityhubInsightFiltersResourceAwsIamAccessKeyStatus | cdktf.IResolvable): any;
export interface SecurityhubInsightFiltersResourceAwsIamAccessKeyUserName {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#comparison SecurityhubInsight#comparison}
    */
    readonly comparison: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#value SecurityhubInsight#value}
    */
    readonly value: string;
}
export declare function securityhubInsightFiltersResourceAwsIamAccessKeyUserNameToTerraform(struct?: SecurityhubInsightFiltersResourceAwsIamAccessKeyUserName | cdktf.IResolvable): any;
export interface SecurityhubInsightFiltersResourceAwsS3BucketOwnerId {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#comparison SecurityhubInsight#comparison}
    */
    readonly comparison: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#value SecurityhubInsight#value}
    */
    readonly value: string;
}
export declare function securityhubInsightFiltersResourceAwsS3BucketOwnerIdToTerraform(struct?: SecurityhubInsightFiltersResourceAwsS3BucketOwnerId | cdktf.IResolvable): any;
export interface SecurityhubInsightFiltersResourceAwsS3BucketOwnerName {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#comparison SecurityhubInsight#comparison}
    */
    readonly comparison: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#value SecurityhubInsight#value}
    */
    readonly value: string;
}
export declare function securityhubInsightFiltersResourceAwsS3BucketOwnerNameToTerraform(struct?: SecurityhubInsightFiltersResourceAwsS3BucketOwnerName | cdktf.IResolvable): any;
export interface SecurityhubInsightFiltersResourceContainerImageId {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#comparison SecurityhubInsight#comparison}
    */
    readonly comparison: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#value SecurityhubInsight#value}
    */
    readonly value: string;
}
export declare function securityhubInsightFiltersResourceContainerImageIdToTerraform(struct?: SecurityhubInsightFiltersResourceContainerImageId | cdktf.IResolvable): any;
export interface SecurityhubInsightFiltersResourceContainerImageName {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#comparison SecurityhubInsight#comparison}
    */
    readonly comparison: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#value SecurityhubInsight#value}
    */
    readonly value: string;
}
export declare function securityhubInsightFiltersResourceContainerImageNameToTerraform(struct?: SecurityhubInsightFiltersResourceContainerImageName | cdktf.IResolvable): any;
export interface SecurityhubInsightFiltersResourceContainerLaunchedAtDateRange {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#unit SecurityhubInsight#unit}
    */
    readonly unit: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#value SecurityhubInsight#value}
    */
    readonly value: number;
}
export declare function securityhubInsightFiltersResourceContainerLaunchedAtDateRangeToTerraform(struct?: SecurityhubInsightFiltersResourceContainerLaunchedAtDateRangeOutputReference | SecurityhubInsightFiltersResourceContainerLaunchedAtDateRange): any;
export declare class SecurityhubInsightFiltersResourceContainerLaunchedAtDateRangeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SecurityhubInsightFiltersResourceContainerLaunchedAtDateRange | undefined;
    set internalValue(value: SecurityhubInsightFiltersResourceContainerLaunchedAtDateRange | undefined);
    private _unit?;
    get unit(): string;
    set unit(value: string);
    get unitInput(): string | undefined;
    private _value?;
    get value(): number;
    set value(value: number);
    get valueInput(): number | undefined;
}
export interface SecurityhubInsightFiltersResourceContainerLaunchedAt {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#end SecurityhubInsight#end}
    */
    readonly end?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#start SecurityhubInsight#start}
    */
    readonly start?: string;
    /**
    * date_range block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#date_range SecurityhubInsight#date_range}
    */
    readonly dateRange?: SecurityhubInsightFiltersResourceContainerLaunchedAtDateRange;
}
export declare function securityhubInsightFiltersResourceContainerLaunchedAtToTerraform(struct?: SecurityhubInsightFiltersResourceContainerLaunchedAt | cdktf.IResolvable): any;
export interface SecurityhubInsightFiltersResourceContainerName {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#comparison SecurityhubInsight#comparison}
    */
    readonly comparison: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#value SecurityhubInsight#value}
    */
    readonly value: string;
}
export declare function securityhubInsightFiltersResourceContainerNameToTerraform(struct?: SecurityhubInsightFiltersResourceContainerName | cdktf.IResolvable): any;
export interface SecurityhubInsightFiltersResourceDetailsOther {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#comparison SecurityhubInsight#comparison}
    */
    readonly comparison: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#key SecurityhubInsight#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#value SecurityhubInsight#value}
    */
    readonly value: string;
}
export declare function securityhubInsightFiltersResourceDetailsOtherToTerraform(struct?: SecurityhubInsightFiltersResourceDetailsOther | cdktf.IResolvable): any;
export interface SecurityhubInsightFiltersResourceId {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#comparison SecurityhubInsight#comparison}
    */
    readonly comparison: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#value SecurityhubInsight#value}
    */
    readonly value: string;
}
export declare function securityhubInsightFiltersResourceIdToTerraform(struct?: SecurityhubInsightFiltersResourceId | cdktf.IResolvable): any;
export interface SecurityhubInsightFiltersResourcePartition {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#comparison SecurityhubInsight#comparison}
    */
    readonly comparison: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#value SecurityhubInsight#value}
    */
    readonly value: string;
}
export declare function securityhubInsightFiltersResourcePartitionToTerraform(struct?: SecurityhubInsightFiltersResourcePartition | cdktf.IResolvable): any;
export interface SecurityhubInsightFiltersResourceRegion {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#comparison SecurityhubInsight#comparison}
    */
    readonly comparison: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#value SecurityhubInsight#value}
    */
    readonly value: string;
}
export declare function securityhubInsightFiltersResourceRegionToTerraform(struct?: SecurityhubInsightFiltersResourceRegion | cdktf.IResolvable): any;
export interface SecurityhubInsightFiltersResourceTags {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#comparison SecurityhubInsight#comparison}
    */
    readonly comparison: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#key SecurityhubInsight#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#value SecurityhubInsight#value}
    */
    readonly value: string;
}
export declare function securityhubInsightFiltersResourceTagsToTerraform(struct?: SecurityhubInsightFiltersResourceTags | cdktf.IResolvable): any;
export interface SecurityhubInsightFiltersResourceType {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#comparison SecurityhubInsight#comparison}
    */
    readonly comparison: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#value SecurityhubInsight#value}
    */
    readonly value: string;
}
export declare function securityhubInsightFiltersResourceTypeToTerraform(struct?: SecurityhubInsightFiltersResourceType | cdktf.IResolvable): any;
export interface SecurityhubInsightFiltersSeverityLabel {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#comparison SecurityhubInsight#comparison}
    */
    readonly comparison: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#value SecurityhubInsight#value}
    */
    readonly value: string;
}
export declare function securityhubInsightFiltersSeverityLabelToTerraform(struct?: SecurityhubInsightFiltersSeverityLabel | cdktf.IResolvable): any;
export interface SecurityhubInsightFiltersSourceUrl {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#comparison SecurityhubInsight#comparison}
    */
    readonly comparison: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#value SecurityhubInsight#value}
    */
    readonly value: string;
}
export declare function securityhubInsightFiltersSourceUrlToTerraform(struct?: SecurityhubInsightFiltersSourceUrl | cdktf.IResolvable): any;
export interface SecurityhubInsightFiltersThreatIntelIndicatorCategory {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#comparison SecurityhubInsight#comparison}
    */
    readonly comparison: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#value SecurityhubInsight#value}
    */
    readonly value: string;
}
export declare function securityhubInsightFiltersThreatIntelIndicatorCategoryToTerraform(struct?: SecurityhubInsightFiltersThreatIntelIndicatorCategory | cdktf.IResolvable): any;
export interface SecurityhubInsightFiltersThreatIntelIndicatorLastObservedAtDateRange {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#unit SecurityhubInsight#unit}
    */
    readonly unit: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#value SecurityhubInsight#value}
    */
    readonly value: number;
}
export declare function securityhubInsightFiltersThreatIntelIndicatorLastObservedAtDateRangeToTerraform(struct?: SecurityhubInsightFiltersThreatIntelIndicatorLastObservedAtDateRangeOutputReference | SecurityhubInsightFiltersThreatIntelIndicatorLastObservedAtDateRange): any;
export declare class SecurityhubInsightFiltersThreatIntelIndicatorLastObservedAtDateRangeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SecurityhubInsightFiltersThreatIntelIndicatorLastObservedAtDateRange | undefined;
    set internalValue(value: SecurityhubInsightFiltersThreatIntelIndicatorLastObservedAtDateRange | undefined);
    private _unit?;
    get unit(): string;
    set unit(value: string);
    get unitInput(): string | undefined;
    private _value?;
    get value(): number;
    set value(value: number);
    get valueInput(): number | undefined;
}
export interface SecurityhubInsightFiltersThreatIntelIndicatorLastObservedAt {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#end SecurityhubInsight#end}
    */
    readonly end?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#start SecurityhubInsight#start}
    */
    readonly start?: string;
    /**
    * date_range block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#date_range SecurityhubInsight#date_range}
    */
    readonly dateRange?: SecurityhubInsightFiltersThreatIntelIndicatorLastObservedAtDateRange;
}
export declare function securityhubInsightFiltersThreatIntelIndicatorLastObservedAtToTerraform(struct?: SecurityhubInsightFiltersThreatIntelIndicatorLastObservedAt | cdktf.IResolvable): any;
export interface SecurityhubInsightFiltersThreatIntelIndicatorSource {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#comparison SecurityhubInsight#comparison}
    */
    readonly comparison: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#value SecurityhubInsight#value}
    */
    readonly value: string;
}
export declare function securityhubInsightFiltersThreatIntelIndicatorSourceToTerraform(struct?: SecurityhubInsightFiltersThreatIntelIndicatorSource | cdktf.IResolvable): any;
export interface SecurityhubInsightFiltersThreatIntelIndicatorSourceUrl {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#comparison SecurityhubInsight#comparison}
    */
    readonly comparison: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#value SecurityhubInsight#value}
    */
    readonly value: string;
}
export declare function securityhubInsightFiltersThreatIntelIndicatorSourceUrlToTerraform(struct?: SecurityhubInsightFiltersThreatIntelIndicatorSourceUrl | cdktf.IResolvable): any;
export interface SecurityhubInsightFiltersThreatIntelIndicatorType {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#comparison SecurityhubInsight#comparison}
    */
    readonly comparison: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#value SecurityhubInsight#value}
    */
    readonly value: string;
}
export declare function securityhubInsightFiltersThreatIntelIndicatorTypeToTerraform(struct?: SecurityhubInsightFiltersThreatIntelIndicatorType | cdktf.IResolvable): any;
export interface SecurityhubInsightFiltersThreatIntelIndicatorValue {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#comparison SecurityhubInsight#comparison}
    */
    readonly comparison: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#value SecurityhubInsight#value}
    */
    readonly value: string;
}
export declare function securityhubInsightFiltersThreatIntelIndicatorValueToTerraform(struct?: SecurityhubInsightFiltersThreatIntelIndicatorValue | cdktf.IResolvable): any;
export interface SecurityhubInsightFiltersTitle {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#comparison SecurityhubInsight#comparison}
    */
    readonly comparison: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#value SecurityhubInsight#value}
    */
    readonly value: string;
}
export declare function securityhubInsightFiltersTitleToTerraform(struct?: SecurityhubInsightFiltersTitle | cdktf.IResolvable): any;
export interface SecurityhubInsightFiltersType {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#comparison SecurityhubInsight#comparison}
    */
    readonly comparison: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#value SecurityhubInsight#value}
    */
    readonly value: string;
}
export declare function securityhubInsightFiltersTypeToTerraform(struct?: SecurityhubInsightFiltersType | cdktf.IResolvable): any;
export interface SecurityhubInsightFiltersUpdatedAtDateRange {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#unit SecurityhubInsight#unit}
    */
    readonly unit: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#value SecurityhubInsight#value}
    */
    readonly value: number;
}
export declare function securityhubInsightFiltersUpdatedAtDateRangeToTerraform(struct?: SecurityhubInsightFiltersUpdatedAtDateRangeOutputReference | SecurityhubInsightFiltersUpdatedAtDateRange): any;
export declare class SecurityhubInsightFiltersUpdatedAtDateRangeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SecurityhubInsightFiltersUpdatedAtDateRange | undefined;
    set internalValue(value: SecurityhubInsightFiltersUpdatedAtDateRange | undefined);
    private _unit?;
    get unit(): string;
    set unit(value: string);
    get unitInput(): string | undefined;
    private _value?;
    get value(): number;
    set value(value: number);
    get valueInput(): number | undefined;
}
export interface SecurityhubInsightFiltersUpdatedAt {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#end SecurityhubInsight#end}
    */
    readonly end?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#start SecurityhubInsight#start}
    */
    readonly start?: string;
    /**
    * date_range block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#date_range SecurityhubInsight#date_range}
    */
    readonly dateRange?: SecurityhubInsightFiltersUpdatedAtDateRange;
}
export declare function securityhubInsightFiltersUpdatedAtToTerraform(struct?: SecurityhubInsightFiltersUpdatedAt | cdktf.IResolvable): any;
export interface SecurityhubInsightFiltersUserDefinedValues {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#comparison SecurityhubInsight#comparison}
    */
    readonly comparison: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#key SecurityhubInsight#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#value SecurityhubInsight#value}
    */
    readonly value: string;
}
export declare function securityhubInsightFiltersUserDefinedValuesToTerraform(struct?: SecurityhubInsightFiltersUserDefinedValues | cdktf.IResolvable): any;
export interface SecurityhubInsightFiltersVerificationState {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#comparison SecurityhubInsight#comparison}
    */
    readonly comparison: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#value SecurityhubInsight#value}
    */
    readonly value: string;
}
export declare function securityhubInsightFiltersVerificationStateToTerraform(struct?: SecurityhubInsightFiltersVerificationState | cdktf.IResolvable): any;
export interface SecurityhubInsightFiltersWorkflowStatus {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#comparison SecurityhubInsight#comparison}
    */
    readonly comparison: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#value SecurityhubInsight#value}
    */
    readonly value: string;
}
export declare function securityhubInsightFiltersWorkflowStatusToTerraform(struct?: SecurityhubInsightFiltersWorkflowStatus | cdktf.IResolvable): any;
export interface SecurityhubInsightFilters {
    /**
    * aws_account_id block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#aws_account_id SecurityhubInsight#aws_account_id}
    */
    readonly awsAccountId?: SecurityhubInsightFiltersAwsAccountId[] | cdktf.IResolvable;
    /**
    * company_name block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#company_name SecurityhubInsight#company_name}
    */
    readonly companyName?: SecurityhubInsightFiltersCompanyName[] | cdktf.IResolvable;
    /**
    * compliance_status block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#compliance_status SecurityhubInsight#compliance_status}
    */
    readonly complianceStatus?: SecurityhubInsightFiltersComplianceStatus[] | cdktf.IResolvable;
    /**
    * confidence block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#confidence SecurityhubInsight#confidence}
    */
    readonly confidence?: SecurityhubInsightFiltersConfidence[] | cdktf.IResolvable;
    /**
    * created_at block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#created_at SecurityhubInsight#created_at}
    */
    readonly createdAt?: SecurityhubInsightFiltersCreatedAt[] | cdktf.IResolvable;
    /**
    * criticality block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#criticality SecurityhubInsight#criticality}
    */
    readonly criticality?: SecurityhubInsightFiltersCriticality[] | cdktf.IResolvable;
    /**
    * description block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#description SecurityhubInsight#description}
    */
    readonly description?: SecurityhubInsightFiltersDescription[] | cdktf.IResolvable;
    /**
    * finding_provider_fields_confidence block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#finding_provider_fields_confidence SecurityhubInsight#finding_provider_fields_confidence}
    */
    readonly findingProviderFieldsConfidence?: SecurityhubInsightFiltersFindingProviderFieldsConfidence[] | cdktf.IResolvable;
    /**
    * finding_provider_fields_criticality block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#finding_provider_fields_criticality SecurityhubInsight#finding_provider_fields_criticality}
    */
    readonly findingProviderFieldsCriticality?: SecurityhubInsightFiltersFindingProviderFieldsCriticality[] | cdktf.IResolvable;
    /**
    * finding_provider_fields_related_findings_id block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#finding_provider_fields_related_findings_id SecurityhubInsight#finding_provider_fields_related_findings_id}
    */
    readonly findingProviderFieldsRelatedFindingsId?: SecurityhubInsightFiltersFindingProviderFieldsRelatedFindingsId[] | cdktf.IResolvable;
    /**
    * finding_provider_fields_related_findings_product_arn block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#finding_provider_fields_related_findings_product_arn SecurityhubInsight#finding_provider_fields_related_findings_product_arn}
    */
    readonly findingProviderFieldsRelatedFindingsProductArn?: SecurityhubInsightFiltersFindingProviderFieldsRelatedFindingsProductArn[] | cdktf.IResolvable;
    /**
    * finding_provider_fields_severity_label block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#finding_provider_fields_severity_label SecurityhubInsight#finding_provider_fields_severity_label}
    */
    readonly findingProviderFieldsSeverityLabel?: SecurityhubInsightFiltersFindingProviderFieldsSeverityLabel[] | cdktf.IResolvable;
    /**
    * finding_provider_fields_severity_original block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#finding_provider_fields_severity_original SecurityhubInsight#finding_provider_fields_severity_original}
    */
    readonly findingProviderFieldsSeverityOriginal?: SecurityhubInsightFiltersFindingProviderFieldsSeverityOriginal[] | cdktf.IResolvable;
    /**
    * finding_provider_fields_types block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#finding_provider_fields_types SecurityhubInsight#finding_provider_fields_types}
    */
    readonly findingProviderFieldsTypes?: SecurityhubInsightFiltersFindingProviderFieldsTypes[] | cdktf.IResolvable;
    /**
    * first_observed_at block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#first_observed_at SecurityhubInsight#first_observed_at}
    */
    readonly firstObservedAt?: SecurityhubInsightFiltersFirstObservedAt[] | cdktf.IResolvable;
    /**
    * generator_id block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#generator_id SecurityhubInsight#generator_id}
    */
    readonly generatorId?: SecurityhubInsightFiltersGeneratorId[] | cdktf.IResolvable;
    /**
    * id block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#id SecurityhubInsight#id}
    */
    readonly id?: SecurityhubInsightFiltersId[] | cdktf.IResolvable;
    /**
    * keyword block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#keyword SecurityhubInsight#keyword}
    */
    readonly keyword?: SecurityhubInsightFiltersKeyword[] | cdktf.IResolvable;
    /**
    * last_observed_at block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#last_observed_at SecurityhubInsight#last_observed_at}
    */
    readonly lastObservedAt?: SecurityhubInsightFiltersLastObservedAt[] | cdktf.IResolvable;
    /**
    * malware_name block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#malware_name SecurityhubInsight#malware_name}
    */
    readonly malwareName?: SecurityhubInsightFiltersMalwareName[] | cdktf.IResolvable;
    /**
    * malware_path block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#malware_path SecurityhubInsight#malware_path}
    */
    readonly malwarePath?: SecurityhubInsightFiltersMalwarePath[] | cdktf.IResolvable;
    /**
    * malware_state block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#malware_state SecurityhubInsight#malware_state}
    */
    readonly malwareState?: SecurityhubInsightFiltersMalwareState[] | cdktf.IResolvable;
    /**
    * malware_type block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#malware_type SecurityhubInsight#malware_type}
    */
    readonly malwareType?: SecurityhubInsightFiltersMalwareType[] | cdktf.IResolvable;
    /**
    * network_destination_domain block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#network_destination_domain SecurityhubInsight#network_destination_domain}
    */
    readonly networkDestinationDomain?: SecurityhubInsightFiltersNetworkDestinationDomain[] | cdktf.IResolvable;
    /**
    * network_destination_ipv4 block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#network_destination_ipv4 SecurityhubInsight#network_destination_ipv4}
    */
    readonly networkDestinationIpv4?: SecurityhubInsightFiltersNetworkDestinationIpv4[] | cdktf.IResolvable;
    /**
    * network_destination_ipv6 block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#network_destination_ipv6 SecurityhubInsight#network_destination_ipv6}
    */
    readonly networkDestinationIpv6?: SecurityhubInsightFiltersNetworkDestinationIpv6[] | cdktf.IResolvable;
    /**
    * network_destination_port block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#network_destination_port SecurityhubInsight#network_destination_port}
    */
    readonly networkDestinationPort?: SecurityhubInsightFiltersNetworkDestinationPort[] | cdktf.IResolvable;
    /**
    * network_direction block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#network_direction SecurityhubInsight#network_direction}
    */
    readonly networkDirection?: SecurityhubInsightFiltersNetworkDirection[] | cdktf.IResolvable;
    /**
    * network_protocol block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#network_protocol SecurityhubInsight#network_protocol}
    */
    readonly networkProtocol?: SecurityhubInsightFiltersNetworkProtocol[] | cdktf.IResolvable;
    /**
    * network_source_domain block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#network_source_domain SecurityhubInsight#network_source_domain}
    */
    readonly networkSourceDomain?: SecurityhubInsightFiltersNetworkSourceDomain[] | cdktf.IResolvable;
    /**
    * network_source_ipv4 block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#network_source_ipv4 SecurityhubInsight#network_source_ipv4}
    */
    readonly networkSourceIpv4?: SecurityhubInsightFiltersNetworkSourceIpv4[] | cdktf.IResolvable;
    /**
    * network_source_ipv6 block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#network_source_ipv6 SecurityhubInsight#network_source_ipv6}
    */
    readonly networkSourceIpv6?: SecurityhubInsightFiltersNetworkSourceIpv6[] | cdktf.IResolvable;
    /**
    * network_source_mac block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#network_source_mac SecurityhubInsight#network_source_mac}
    */
    readonly networkSourceMac?: SecurityhubInsightFiltersNetworkSourceMac[] | cdktf.IResolvable;
    /**
    * network_source_port block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#network_source_port SecurityhubInsight#network_source_port}
    */
    readonly networkSourcePort?: SecurityhubInsightFiltersNetworkSourcePort[] | cdktf.IResolvable;
    /**
    * note_text block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#note_text SecurityhubInsight#note_text}
    */
    readonly noteText?: SecurityhubInsightFiltersNoteText[] | cdktf.IResolvable;
    /**
    * note_updated_at block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#note_updated_at SecurityhubInsight#note_updated_at}
    */
    readonly noteUpdatedAt?: SecurityhubInsightFiltersNoteUpdatedAt[] | cdktf.IResolvable;
    /**
    * note_updated_by block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#note_updated_by SecurityhubInsight#note_updated_by}
    */
    readonly noteUpdatedBy?: SecurityhubInsightFiltersNoteUpdatedBy[] | cdktf.IResolvable;
    /**
    * process_launched_at block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#process_launched_at SecurityhubInsight#process_launched_at}
    */
    readonly processLaunchedAt?: SecurityhubInsightFiltersProcessLaunchedAt[] | cdktf.IResolvable;
    /**
    * process_name block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#process_name SecurityhubInsight#process_name}
    */
    readonly processName?: SecurityhubInsightFiltersProcessName[] | cdktf.IResolvable;
    /**
    * process_parent_pid block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#process_parent_pid SecurityhubInsight#process_parent_pid}
    */
    readonly processParentPid?: SecurityhubInsightFiltersProcessParentPid[] | cdktf.IResolvable;
    /**
    * process_path block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#process_path SecurityhubInsight#process_path}
    */
    readonly processPath?: SecurityhubInsightFiltersProcessPath[] | cdktf.IResolvable;
    /**
    * process_pid block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#process_pid SecurityhubInsight#process_pid}
    */
    readonly processPid?: SecurityhubInsightFiltersProcessPid[] | cdktf.IResolvable;
    /**
    * process_terminated_at block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#process_terminated_at SecurityhubInsight#process_terminated_at}
    */
    readonly processTerminatedAt?: SecurityhubInsightFiltersProcessTerminatedAt[] | cdktf.IResolvable;
    /**
    * product_arn block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#product_arn SecurityhubInsight#product_arn}
    */
    readonly productArn?: SecurityhubInsightFiltersProductArn[] | cdktf.IResolvable;
    /**
    * product_fields block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#product_fields SecurityhubInsight#product_fields}
    */
    readonly productFields?: SecurityhubInsightFiltersProductFields[] | cdktf.IResolvable;
    /**
    * product_name block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#product_name SecurityhubInsight#product_name}
    */
    readonly productName?: SecurityhubInsightFiltersProductName[] | cdktf.IResolvable;
    /**
    * recommendation_text block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#recommendation_text SecurityhubInsight#recommendation_text}
    */
    readonly recommendationText?: SecurityhubInsightFiltersRecommendationText[] | cdktf.IResolvable;
    /**
    * record_state block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#record_state SecurityhubInsight#record_state}
    */
    readonly recordState?: SecurityhubInsightFiltersRecordState[] | cdktf.IResolvable;
    /**
    * related_findings_id block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#related_findings_id SecurityhubInsight#related_findings_id}
    */
    readonly relatedFindingsId?: SecurityhubInsightFiltersRelatedFindingsId[] | cdktf.IResolvable;
    /**
    * related_findings_product_arn block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#related_findings_product_arn SecurityhubInsight#related_findings_product_arn}
    */
    readonly relatedFindingsProductArn?: SecurityhubInsightFiltersRelatedFindingsProductArn[] | cdktf.IResolvable;
    /**
    * resource_aws_ec2_instance_iam_instance_profile_arn block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#resource_aws_ec2_instance_iam_instance_profile_arn SecurityhubInsight#resource_aws_ec2_instance_iam_instance_profile_arn}
    */
    readonly resourceAwsEc2InstanceIamInstanceProfileArn?: SecurityhubInsightFiltersResourceAwsEc2InstanceIamInstanceProfileArn[] | cdktf.IResolvable;
    /**
    * resource_aws_ec2_instance_image_id block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#resource_aws_ec2_instance_image_id SecurityhubInsight#resource_aws_ec2_instance_image_id}
    */
    readonly resourceAwsEc2InstanceImageId?: SecurityhubInsightFiltersResourceAwsEc2InstanceImageId[] | cdktf.IResolvable;
    /**
    * resource_aws_ec2_instance_ipv4_addresses block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#resource_aws_ec2_instance_ipv4_addresses SecurityhubInsight#resource_aws_ec2_instance_ipv4_addresses}
    */
    readonly resourceAwsEc2InstanceIpv4Addresses?: SecurityhubInsightFiltersResourceAwsEc2InstanceIpv4Addresses[] | cdktf.IResolvable;
    /**
    * resource_aws_ec2_instance_ipv6_addresses block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#resource_aws_ec2_instance_ipv6_addresses SecurityhubInsight#resource_aws_ec2_instance_ipv6_addresses}
    */
    readonly resourceAwsEc2InstanceIpv6Addresses?: SecurityhubInsightFiltersResourceAwsEc2InstanceIpv6Addresses[] | cdktf.IResolvable;
    /**
    * resource_aws_ec2_instance_key_name block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#resource_aws_ec2_instance_key_name SecurityhubInsight#resource_aws_ec2_instance_key_name}
    */
    readonly resourceAwsEc2InstanceKeyName?: SecurityhubInsightFiltersResourceAwsEc2InstanceKeyName[] | cdktf.IResolvable;
    /**
    * resource_aws_ec2_instance_launched_at block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#resource_aws_ec2_instance_launched_at SecurityhubInsight#resource_aws_ec2_instance_launched_at}
    */
    readonly resourceAwsEc2InstanceLaunchedAt?: SecurityhubInsightFiltersResourceAwsEc2InstanceLaunchedAt[] | cdktf.IResolvable;
    /**
    * resource_aws_ec2_instance_subnet_id block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#resource_aws_ec2_instance_subnet_id SecurityhubInsight#resource_aws_ec2_instance_subnet_id}
    */
    readonly resourceAwsEc2InstanceSubnetId?: SecurityhubInsightFiltersResourceAwsEc2InstanceSubnetId[] | cdktf.IResolvable;
    /**
    * resource_aws_ec2_instance_type block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#resource_aws_ec2_instance_type SecurityhubInsight#resource_aws_ec2_instance_type}
    */
    readonly resourceAwsEc2InstanceType?: SecurityhubInsightFiltersResourceAwsEc2InstanceType[] | cdktf.IResolvable;
    /**
    * resource_aws_ec2_instance_vpc_id block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#resource_aws_ec2_instance_vpc_id SecurityhubInsight#resource_aws_ec2_instance_vpc_id}
    */
    readonly resourceAwsEc2InstanceVpcId?: SecurityhubInsightFiltersResourceAwsEc2InstanceVpcId[] | cdktf.IResolvable;
    /**
    * resource_aws_iam_access_key_created_at block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#resource_aws_iam_access_key_created_at SecurityhubInsight#resource_aws_iam_access_key_created_at}
    */
    readonly resourceAwsIamAccessKeyCreatedAt?: SecurityhubInsightFiltersResourceAwsIamAccessKeyCreatedAt[] | cdktf.IResolvable;
    /**
    * resource_aws_iam_access_key_status block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#resource_aws_iam_access_key_status SecurityhubInsight#resource_aws_iam_access_key_status}
    */
    readonly resourceAwsIamAccessKeyStatus?: SecurityhubInsightFiltersResourceAwsIamAccessKeyStatus[] | cdktf.IResolvable;
    /**
    * resource_aws_iam_access_key_user_name block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#resource_aws_iam_access_key_user_name SecurityhubInsight#resource_aws_iam_access_key_user_name}
    */
    readonly resourceAwsIamAccessKeyUserName?: SecurityhubInsightFiltersResourceAwsIamAccessKeyUserName[] | cdktf.IResolvable;
    /**
    * resource_aws_s3_bucket_owner_id block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#resource_aws_s3_bucket_owner_id SecurityhubInsight#resource_aws_s3_bucket_owner_id}
    */
    readonly resourceAwsS3BucketOwnerId?: SecurityhubInsightFiltersResourceAwsS3BucketOwnerId[] | cdktf.IResolvable;
    /**
    * resource_aws_s3_bucket_owner_name block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#resource_aws_s3_bucket_owner_name SecurityhubInsight#resource_aws_s3_bucket_owner_name}
    */
    readonly resourceAwsS3BucketOwnerName?: SecurityhubInsightFiltersResourceAwsS3BucketOwnerName[] | cdktf.IResolvable;
    /**
    * resource_container_image_id block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#resource_container_image_id SecurityhubInsight#resource_container_image_id}
    */
    readonly resourceContainerImageId?: SecurityhubInsightFiltersResourceContainerImageId[] | cdktf.IResolvable;
    /**
    * resource_container_image_name block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#resource_container_image_name SecurityhubInsight#resource_container_image_name}
    */
    readonly resourceContainerImageName?: SecurityhubInsightFiltersResourceContainerImageName[] | cdktf.IResolvable;
    /**
    * resource_container_launched_at block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#resource_container_launched_at SecurityhubInsight#resource_container_launched_at}
    */
    readonly resourceContainerLaunchedAt?: SecurityhubInsightFiltersResourceContainerLaunchedAt[] | cdktf.IResolvable;
    /**
    * resource_container_name block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#resource_container_name SecurityhubInsight#resource_container_name}
    */
    readonly resourceContainerName?: SecurityhubInsightFiltersResourceContainerName[] | cdktf.IResolvable;
    /**
    * resource_details_other block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#resource_details_other SecurityhubInsight#resource_details_other}
    */
    readonly resourceDetailsOther?: SecurityhubInsightFiltersResourceDetailsOther[] | cdktf.IResolvable;
    /**
    * resource_id block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#resource_id SecurityhubInsight#resource_id}
    */
    readonly resourceId?: SecurityhubInsightFiltersResourceId[] | cdktf.IResolvable;
    /**
    * resource_partition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#resource_partition SecurityhubInsight#resource_partition}
    */
    readonly resourcePartition?: SecurityhubInsightFiltersResourcePartition[] | cdktf.IResolvable;
    /**
    * resource_region block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#resource_region SecurityhubInsight#resource_region}
    */
    readonly resourceRegion?: SecurityhubInsightFiltersResourceRegion[] | cdktf.IResolvable;
    /**
    * resource_tags block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#resource_tags SecurityhubInsight#resource_tags}
    */
    readonly resourceTags?: SecurityhubInsightFiltersResourceTags[] | cdktf.IResolvable;
    /**
    * resource_type block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#resource_type SecurityhubInsight#resource_type}
    */
    readonly resourceType?: SecurityhubInsightFiltersResourceType[] | cdktf.IResolvable;
    /**
    * severity_label block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#severity_label SecurityhubInsight#severity_label}
    */
    readonly severityLabel?: SecurityhubInsightFiltersSeverityLabel[] | cdktf.IResolvable;
    /**
    * source_url block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#source_url SecurityhubInsight#source_url}
    */
    readonly sourceUrl?: SecurityhubInsightFiltersSourceUrl[] | cdktf.IResolvable;
    /**
    * threat_intel_indicator_category block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#threat_intel_indicator_category SecurityhubInsight#threat_intel_indicator_category}
    */
    readonly threatIntelIndicatorCategory?: SecurityhubInsightFiltersThreatIntelIndicatorCategory[] | cdktf.IResolvable;
    /**
    * threat_intel_indicator_last_observed_at block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#threat_intel_indicator_last_observed_at SecurityhubInsight#threat_intel_indicator_last_observed_at}
    */
    readonly threatIntelIndicatorLastObservedAt?: SecurityhubInsightFiltersThreatIntelIndicatorLastObservedAt[] | cdktf.IResolvable;
    /**
    * threat_intel_indicator_source block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#threat_intel_indicator_source SecurityhubInsight#threat_intel_indicator_source}
    */
    readonly threatIntelIndicatorSource?: SecurityhubInsightFiltersThreatIntelIndicatorSource[] | cdktf.IResolvable;
    /**
    * threat_intel_indicator_source_url block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#threat_intel_indicator_source_url SecurityhubInsight#threat_intel_indicator_source_url}
    */
    readonly threatIntelIndicatorSourceUrl?: SecurityhubInsightFiltersThreatIntelIndicatorSourceUrl[] | cdktf.IResolvable;
    /**
    * threat_intel_indicator_type block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#threat_intel_indicator_type SecurityhubInsight#threat_intel_indicator_type}
    */
    readonly threatIntelIndicatorType?: SecurityhubInsightFiltersThreatIntelIndicatorType[] | cdktf.IResolvable;
    /**
    * threat_intel_indicator_value block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#threat_intel_indicator_value SecurityhubInsight#threat_intel_indicator_value}
    */
    readonly threatIntelIndicatorValue?: SecurityhubInsightFiltersThreatIntelIndicatorValue[] | cdktf.IResolvable;
    /**
    * title block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#title SecurityhubInsight#title}
    */
    readonly title?: SecurityhubInsightFiltersTitle[] | cdktf.IResolvable;
    /**
    * type block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#type SecurityhubInsight#type}
    */
    readonly type?: SecurityhubInsightFiltersType[] | cdktf.IResolvable;
    /**
    * updated_at block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#updated_at SecurityhubInsight#updated_at}
    */
    readonly updatedAt?: SecurityhubInsightFiltersUpdatedAt[] | cdktf.IResolvable;
    /**
    * user_defined_values block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#user_defined_values SecurityhubInsight#user_defined_values}
    */
    readonly userDefinedValues?: SecurityhubInsightFiltersUserDefinedValues[] | cdktf.IResolvable;
    /**
    * verification_state block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#verification_state SecurityhubInsight#verification_state}
    */
    readonly verificationState?: SecurityhubInsightFiltersVerificationState[] | cdktf.IResolvable;
    /**
    * workflow_status block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight#workflow_status SecurityhubInsight#workflow_status}
    */
    readonly workflowStatus?: SecurityhubInsightFiltersWorkflowStatus[] | cdktf.IResolvable;
}
export declare function securityhubInsightFiltersToTerraform(struct?: SecurityhubInsightFiltersOutputReference | SecurityhubInsightFilters): any;
export declare class SecurityhubInsightFiltersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SecurityhubInsightFilters | undefined;
    set internalValue(value: SecurityhubInsightFilters | undefined);
    private _awsAccountId?;
    get awsAccountId(): SecurityhubInsightFiltersAwsAccountId[] | cdktf.IResolvable;
    set awsAccountId(value: SecurityhubInsightFiltersAwsAccountId[] | cdktf.IResolvable);
    resetAwsAccountId(): void;
    get awsAccountIdInput(): cdktf.IResolvable | SecurityhubInsightFiltersAwsAccountId[] | undefined;
    private _companyName?;
    get companyName(): SecurityhubInsightFiltersCompanyName[] | cdktf.IResolvable;
    set companyName(value: SecurityhubInsightFiltersCompanyName[] | cdktf.IResolvable);
    resetCompanyName(): void;
    get companyNameInput(): cdktf.IResolvable | SecurityhubInsightFiltersCompanyName[] | undefined;
    private _complianceStatus?;
    get complianceStatus(): SecurityhubInsightFiltersComplianceStatus[] | cdktf.IResolvable;
    set complianceStatus(value: SecurityhubInsightFiltersComplianceStatus[] | cdktf.IResolvable);
    resetComplianceStatus(): void;
    get complianceStatusInput(): cdktf.IResolvable | SecurityhubInsightFiltersComplianceStatus[] | undefined;
    private _confidence?;
    get confidence(): SecurityhubInsightFiltersConfidence[] | cdktf.IResolvable;
    set confidence(value: SecurityhubInsightFiltersConfidence[] | cdktf.IResolvable);
    resetConfidence(): void;
    get confidenceInput(): cdktf.IResolvable | SecurityhubInsightFiltersConfidence[] | undefined;
    private _createdAt?;
    get createdAt(): SecurityhubInsightFiltersCreatedAt[] | cdktf.IResolvable;
    set createdAt(value: SecurityhubInsightFiltersCreatedAt[] | cdktf.IResolvable);
    resetCreatedAt(): void;
    get createdAtInput(): cdktf.IResolvable | SecurityhubInsightFiltersCreatedAt[] | undefined;
    private _criticality?;
    get criticality(): SecurityhubInsightFiltersCriticality[] | cdktf.IResolvable;
    set criticality(value: SecurityhubInsightFiltersCriticality[] | cdktf.IResolvable);
    resetCriticality(): void;
    get criticalityInput(): cdktf.IResolvable | SecurityhubInsightFiltersCriticality[] | undefined;
    private _description?;
    get description(): SecurityhubInsightFiltersDescription[] | cdktf.IResolvable;
    set description(value: SecurityhubInsightFiltersDescription[] | cdktf.IResolvable);
    resetDescription(): void;
    get descriptionInput(): cdktf.IResolvable | SecurityhubInsightFiltersDescription[] | undefined;
    private _findingProviderFieldsConfidence?;
    get findingProviderFieldsConfidence(): SecurityhubInsightFiltersFindingProviderFieldsConfidence[] | cdktf.IResolvable;
    set findingProviderFieldsConfidence(value: SecurityhubInsightFiltersFindingProviderFieldsConfidence[] | cdktf.IResolvable);
    resetFindingProviderFieldsConfidence(): void;
    get findingProviderFieldsConfidenceInput(): cdktf.IResolvable | SecurityhubInsightFiltersFindingProviderFieldsConfidence[] | undefined;
    private _findingProviderFieldsCriticality?;
    get findingProviderFieldsCriticality(): SecurityhubInsightFiltersFindingProviderFieldsCriticality[] | cdktf.IResolvable;
    set findingProviderFieldsCriticality(value: SecurityhubInsightFiltersFindingProviderFieldsCriticality[] | cdktf.IResolvable);
    resetFindingProviderFieldsCriticality(): void;
    get findingProviderFieldsCriticalityInput(): cdktf.IResolvable | SecurityhubInsightFiltersFindingProviderFieldsCriticality[] | undefined;
    private _findingProviderFieldsRelatedFindingsId?;
    get findingProviderFieldsRelatedFindingsId(): SecurityhubInsightFiltersFindingProviderFieldsRelatedFindingsId[] | cdktf.IResolvable;
    set findingProviderFieldsRelatedFindingsId(value: SecurityhubInsightFiltersFindingProviderFieldsRelatedFindingsId[] | cdktf.IResolvable);
    resetFindingProviderFieldsRelatedFindingsId(): void;
    get findingProviderFieldsRelatedFindingsIdInput(): cdktf.IResolvable | SecurityhubInsightFiltersFindingProviderFieldsRelatedFindingsId[] | undefined;
    private _findingProviderFieldsRelatedFindingsProductArn?;
    get findingProviderFieldsRelatedFindingsProductArn(): SecurityhubInsightFiltersFindingProviderFieldsRelatedFindingsProductArn[] | cdktf.IResolvable;
    set findingProviderFieldsRelatedFindingsProductArn(value: SecurityhubInsightFiltersFindingProviderFieldsRelatedFindingsProductArn[] | cdktf.IResolvable);
    resetFindingProviderFieldsRelatedFindingsProductArn(): void;
    get findingProviderFieldsRelatedFindingsProductArnInput(): cdktf.IResolvable | SecurityhubInsightFiltersFindingProviderFieldsRelatedFindingsProductArn[] | undefined;
    private _findingProviderFieldsSeverityLabel?;
    get findingProviderFieldsSeverityLabel(): SecurityhubInsightFiltersFindingProviderFieldsSeverityLabel[] | cdktf.IResolvable;
    set findingProviderFieldsSeverityLabel(value: SecurityhubInsightFiltersFindingProviderFieldsSeverityLabel[] | cdktf.IResolvable);
    resetFindingProviderFieldsSeverityLabel(): void;
    get findingProviderFieldsSeverityLabelInput(): cdktf.IResolvable | SecurityhubInsightFiltersFindingProviderFieldsSeverityLabel[] | undefined;
    private _findingProviderFieldsSeverityOriginal?;
    get findingProviderFieldsSeverityOriginal(): SecurityhubInsightFiltersFindingProviderFieldsSeverityOriginal[] | cdktf.IResolvable;
    set findingProviderFieldsSeverityOriginal(value: SecurityhubInsightFiltersFindingProviderFieldsSeverityOriginal[] | cdktf.IResolvable);
    resetFindingProviderFieldsSeverityOriginal(): void;
    get findingProviderFieldsSeverityOriginalInput(): cdktf.IResolvable | SecurityhubInsightFiltersFindingProviderFieldsSeverityOriginal[] | undefined;
    private _findingProviderFieldsTypes?;
    get findingProviderFieldsTypes(): SecurityhubInsightFiltersFindingProviderFieldsTypes[] | cdktf.IResolvable;
    set findingProviderFieldsTypes(value: SecurityhubInsightFiltersFindingProviderFieldsTypes[] | cdktf.IResolvable);
    resetFindingProviderFieldsTypes(): void;
    get findingProviderFieldsTypesInput(): cdktf.IResolvable | SecurityhubInsightFiltersFindingProviderFieldsTypes[] | undefined;
    private _firstObservedAt?;
    get firstObservedAt(): SecurityhubInsightFiltersFirstObservedAt[] | cdktf.IResolvable;
    set firstObservedAt(value: SecurityhubInsightFiltersFirstObservedAt[] | cdktf.IResolvable);
    resetFirstObservedAt(): void;
    get firstObservedAtInput(): cdktf.IResolvable | SecurityhubInsightFiltersFirstObservedAt[] | undefined;
    private _generatorId?;
    get generatorId(): SecurityhubInsightFiltersGeneratorId[] | cdktf.IResolvable;
    set generatorId(value: SecurityhubInsightFiltersGeneratorId[] | cdktf.IResolvable);
    resetGeneratorId(): void;
    get generatorIdInput(): cdktf.IResolvable | SecurityhubInsightFiltersGeneratorId[] | undefined;
    private _id?;
    get id(): SecurityhubInsightFiltersId[] | cdktf.IResolvable;
    set id(value: SecurityhubInsightFiltersId[] | cdktf.IResolvable);
    resetId(): void;
    get idInput(): cdktf.IResolvable | SecurityhubInsightFiltersId[] | undefined;
    private _keyword?;
    get keyword(): SecurityhubInsightFiltersKeyword[] | cdktf.IResolvable;
    set keyword(value: SecurityhubInsightFiltersKeyword[] | cdktf.IResolvable);
    resetKeyword(): void;
    get keywordInput(): cdktf.IResolvable | SecurityhubInsightFiltersKeyword[] | undefined;
    private _lastObservedAt?;
    get lastObservedAt(): SecurityhubInsightFiltersLastObservedAt[] | cdktf.IResolvable;
    set lastObservedAt(value: SecurityhubInsightFiltersLastObservedAt[] | cdktf.IResolvable);
    resetLastObservedAt(): void;
    get lastObservedAtInput(): cdktf.IResolvable | SecurityhubInsightFiltersLastObservedAt[] | undefined;
    private _malwareName?;
    get malwareName(): SecurityhubInsightFiltersMalwareName[] | cdktf.IResolvable;
    set malwareName(value: SecurityhubInsightFiltersMalwareName[] | cdktf.IResolvable);
    resetMalwareName(): void;
    get malwareNameInput(): cdktf.IResolvable | SecurityhubInsightFiltersMalwareName[] | undefined;
    private _malwarePath?;
    get malwarePath(): SecurityhubInsightFiltersMalwarePath[] | cdktf.IResolvable;
    set malwarePath(value: SecurityhubInsightFiltersMalwarePath[] | cdktf.IResolvable);
    resetMalwarePath(): void;
    get malwarePathInput(): cdktf.IResolvable | SecurityhubInsightFiltersMalwarePath[] | undefined;
    private _malwareState?;
    get malwareState(): SecurityhubInsightFiltersMalwareState[] | cdktf.IResolvable;
    set malwareState(value: SecurityhubInsightFiltersMalwareState[] | cdktf.IResolvable);
    resetMalwareState(): void;
    get malwareStateInput(): cdktf.IResolvable | SecurityhubInsightFiltersMalwareState[] | undefined;
    private _malwareType?;
    get malwareType(): SecurityhubInsightFiltersMalwareType[] | cdktf.IResolvable;
    set malwareType(value: SecurityhubInsightFiltersMalwareType[] | cdktf.IResolvable);
    resetMalwareType(): void;
    get malwareTypeInput(): cdktf.IResolvable | SecurityhubInsightFiltersMalwareType[] | undefined;
    private _networkDestinationDomain?;
    get networkDestinationDomain(): SecurityhubInsightFiltersNetworkDestinationDomain[] | cdktf.IResolvable;
    set networkDestinationDomain(value: SecurityhubInsightFiltersNetworkDestinationDomain[] | cdktf.IResolvable);
    resetNetworkDestinationDomain(): void;
    get networkDestinationDomainInput(): cdktf.IResolvable | SecurityhubInsightFiltersNetworkDestinationDomain[] | undefined;
    private _networkDestinationIpv4?;
    get networkDestinationIpv4(): SecurityhubInsightFiltersNetworkDestinationIpv4[] | cdktf.IResolvable;
    set networkDestinationIpv4(value: SecurityhubInsightFiltersNetworkDestinationIpv4[] | cdktf.IResolvable);
    resetNetworkDestinationIpv4(): void;
    get networkDestinationIpv4Input(): cdktf.IResolvable | SecurityhubInsightFiltersNetworkDestinationIpv4[] | undefined;
    private _networkDestinationIpv6?;
    get networkDestinationIpv6(): SecurityhubInsightFiltersNetworkDestinationIpv6[] | cdktf.IResolvable;
    set networkDestinationIpv6(value: SecurityhubInsightFiltersNetworkDestinationIpv6[] | cdktf.IResolvable);
    resetNetworkDestinationIpv6(): void;
    get networkDestinationIpv6Input(): cdktf.IResolvable | SecurityhubInsightFiltersNetworkDestinationIpv6[] | undefined;
    private _networkDestinationPort?;
    get networkDestinationPort(): SecurityhubInsightFiltersNetworkDestinationPort[] | cdktf.IResolvable;
    set networkDestinationPort(value: SecurityhubInsightFiltersNetworkDestinationPort[] | cdktf.IResolvable);
    resetNetworkDestinationPort(): void;
    get networkDestinationPortInput(): cdktf.IResolvable | SecurityhubInsightFiltersNetworkDestinationPort[] | undefined;
    private _networkDirection?;
    get networkDirection(): SecurityhubInsightFiltersNetworkDirection[] | cdktf.IResolvable;
    set networkDirection(value: SecurityhubInsightFiltersNetworkDirection[] | cdktf.IResolvable);
    resetNetworkDirection(): void;
    get networkDirectionInput(): cdktf.IResolvable | SecurityhubInsightFiltersNetworkDirection[] | undefined;
    private _networkProtocol?;
    get networkProtocol(): SecurityhubInsightFiltersNetworkProtocol[] | cdktf.IResolvable;
    set networkProtocol(value: SecurityhubInsightFiltersNetworkProtocol[] | cdktf.IResolvable);
    resetNetworkProtocol(): void;
    get networkProtocolInput(): cdktf.IResolvable | SecurityhubInsightFiltersNetworkProtocol[] | undefined;
    private _networkSourceDomain?;
    get networkSourceDomain(): SecurityhubInsightFiltersNetworkSourceDomain[] | cdktf.IResolvable;
    set networkSourceDomain(value: SecurityhubInsightFiltersNetworkSourceDomain[] | cdktf.IResolvable);
    resetNetworkSourceDomain(): void;
    get networkSourceDomainInput(): cdktf.IResolvable | SecurityhubInsightFiltersNetworkSourceDomain[] | undefined;
    private _networkSourceIpv4?;
    get networkSourceIpv4(): SecurityhubInsightFiltersNetworkSourceIpv4[] | cdktf.IResolvable;
    set networkSourceIpv4(value: SecurityhubInsightFiltersNetworkSourceIpv4[] | cdktf.IResolvable);
    resetNetworkSourceIpv4(): void;
    get networkSourceIpv4Input(): cdktf.IResolvable | SecurityhubInsightFiltersNetworkSourceIpv4[] | undefined;
    private _networkSourceIpv6?;
    get networkSourceIpv6(): SecurityhubInsightFiltersNetworkSourceIpv6[] | cdktf.IResolvable;
    set networkSourceIpv6(value: SecurityhubInsightFiltersNetworkSourceIpv6[] | cdktf.IResolvable);
    resetNetworkSourceIpv6(): void;
    get networkSourceIpv6Input(): cdktf.IResolvable | SecurityhubInsightFiltersNetworkSourceIpv6[] | undefined;
    private _networkSourceMac?;
    get networkSourceMac(): SecurityhubInsightFiltersNetworkSourceMac[] | cdktf.IResolvable;
    set networkSourceMac(value: SecurityhubInsightFiltersNetworkSourceMac[] | cdktf.IResolvable);
    resetNetworkSourceMac(): void;
    get networkSourceMacInput(): cdktf.IResolvable | SecurityhubInsightFiltersNetworkSourceMac[] | undefined;
    private _networkSourcePort?;
    get networkSourcePort(): SecurityhubInsightFiltersNetworkSourcePort[] | cdktf.IResolvable;
    set networkSourcePort(value: SecurityhubInsightFiltersNetworkSourcePort[] | cdktf.IResolvable);
    resetNetworkSourcePort(): void;
    get networkSourcePortInput(): cdktf.IResolvable | SecurityhubInsightFiltersNetworkSourcePort[] | undefined;
    private _noteText?;
    get noteText(): SecurityhubInsightFiltersNoteText[] | cdktf.IResolvable;
    set noteText(value: SecurityhubInsightFiltersNoteText[] | cdktf.IResolvable);
    resetNoteText(): void;
    get noteTextInput(): cdktf.IResolvable | SecurityhubInsightFiltersNoteText[] | undefined;
    private _noteUpdatedAt?;
    get noteUpdatedAt(): SecurityhubInsightFiltersNoteUpdatedAt[] | cdktf.IResolvable;
    set noteUpdatedAt(value: SecurityhubInsightFiltersNoteUpdatedAt[] | cdktf.IResolvable);
    resetNoteUpdatedAt(): void;
    get noteUpdatedAtInput(): cdktf.IResolvable | SecurityhubInsightFiltersNoteUpdatedAt[] | undefined;
    private _noteUpdatedBy?;
    get noteUpdatedBy(): SecurityhubInsightFiltersNoteUpdatedBy[] | cdktf.IResolvable;
    set noteUpdatedBy(value: SecurityhubInsightFiltersNoteUpdatedBy[] | cdktf.IResolvable);
    resetNoteUpdatedBy(): void;
    get noteUpdatedByInput(): cdktf.IResolvable | SecurityhubInsightFiltersNoteUpdatedBy[] | undefined;
    private _processLaunchedAt?;
    get processLaunchedAt(): SecurityhubInsightFiltersProcessLaunchedAt[] | cdktf.IResolvable;
    set processLaunchedAt(value: SecurityhubInsightFiltersProcessLaunchedAt[] | cdktf.IResolvable);
    resetProcessLaunchedAt(): void;
    get processLaunchedAtInput(): cdktf.IResolvable | SecurityhubInsightFiltersProcessLaunchedAt[] | undefined;
    private _processName?;
    get processName(): SecurityhubInsightFiltersProcessName[] | cdktf.IResolvable;
    set processName(value: SecurityhubInsightFiltersProcessName[] | cdktf.IResolvable);
    resetProcessName(): void;
    get processNameInput(): cdktf.IResolvable | SecurityhubInsightFiltersProcessName[] | undefined;
    private _processParentPid?;
    get processParentPid(): SecurityhubInsightFiltersProcessParentPid[] | cdktf.IResolvable;
    set processParentPid(value: SecurityhubInsightFiltersProcessParentPid[] | cdktf.IResolvable);
    resetProcessParentPid(): void;
    get processParentPidInput(): cdktf.IResolvable | SecurityhubInsightFiltersProcessParentPid[] | undefined;
    private _processPath?;
    get processPath(): SecurityhubInsightFiltersProcessPath[] | cdktf.IResolvable;
    set processPath(value: SecurityhubInsightFiltersProcessPath[] | cdktf.IResolvable);
    resetProcessPath(): void;
    get processPathInput(): cdktf.IResolvable | SecurityhubInsightFiltersProcessPath[] | undefined;
    private _processPid?;
    get processPid(): SecurityhubInsightFiltersProcessPid[] | cdktf.IResolvable;
    set processPid(value: SecurityhubInsightFiltersProcessPid[] | cdktf.IResolvable);
    resetProcessPid(): void;
    get processPidInput(): cdktf.IResolvable | SecurityhubInsightFiltersProcessPid[] | undefined;
    private _processTerminatedAt?;
    get processTerminatedAt(): SecurityhubInsightFiltersProcessTerminatedAt[] | cdktf.IResolvable;
    set processTerminatedAt(value: SecurityhubInsightFiltersProcessTerminatedAt[] | cdktf.IResolvable);
    resetProcessTerminatedAt(): void;
    get processTerminatedAtInput(): cdktf.IResolvable | SecurityhubInsightFiltersProcessTerminatedAt[] | undefined;
    private _productArn?;
    get productArn(): SecurityhubInsightFiltersProductArn[] | cdktf.IResolvable;
    set productArn(value: SecurityhubInsightFiltersProductArn[] | cdktf.IResolvable);
    resetProductArn(): void;
    get productArnInput(): cdktf.IResolvable | SecurityhubInsightFiltersProductArn[] | undefined;
    private _productFields?;
    get productFields(): SecurityhubInsightFiltersProductFields[] | cdktf.IResolvable;
    set productFields(value: SecurityhubInsightFiltersProductFields[] | cdktf.IResolvable);
    resetProductFields(): void;
    get productFieldsInput(): cdktf.IResolvable | SecurityhubInsightFiltersProductFields[] | undefined;
    private _productName?;
    get productName(): SecurityhubInsightFiltersProductName[] | cdktf.IResolvable;
    set productName(value: SecurityhubInsightFiltersProductName[] | cdktf.IResolvable);
    resetProductName(): void;
    get productNameInput(): cdktf.IResolvable | SecurityhubInsightFiltersProductName[] | undefined;
    private _recommendationText?;
    get recommendationText(): SecurityhubInsightFiltersRecommendationText[] | cdktf.IResolvable;
    set recommendationText(value: SecurityhubInsightFiltersRecommendationText[] | cdktf.IResolvable);
    resetRecommendationText(): void;
    get recommendationTextInput(): cdktf.IResolvable | SecurityhubInsightFiltersRecommendationText[] | undefined;
    private _recordState?;
    get recordState(): SecurityhubInsightFiltersRecordState[] | cdktf.IResolvable;
    set recordState(value: SecurityhubInsightFiltersRecordState[] | cdktf.IResolvable);
    resetRecordState(): void;
    get recordStateInput(): cdktf.IResolvable | SecurityhubInsightFiltersRecordState[] | undefined;
    private _relatedFindingsId?;
    get relatedFindingsId(): SecurityhubInsightFiltersRelatedFindingsId[] | cdktf.IResolvable;
    set relatedFindingsId(value: SecurityhubInsightFiltersRelatedFindingsId[] | cdktf.IResolvable);
    resetRelatedFindingsId(): void;
    get relatedFindingsIdInput(): cdktf.IResolvable | SecurityhubInsightFiltersRelatedFindingsId[] | undefined;
    private _relatedFindingsProductArn?;
    get relatedFindingsProductArn(): SecurityhubInsightFiltersRelatedFindingsProductArn[] | cdktf.IResolvable;
    set relatedFindingsProductArn(value: SecurityhubInsightFiltersRelatedFindingsProductArn[] | cdktf.IResolvable);
    resetRelatedFindingsProductArn(): void;
    get relatedFindingsProductArnInput(): cdktf.IResolvable | SecurityhubInsightFiltersRelatedFindingsProductArn[] | undefined;
    private _resourceAwsEc2InstanceIamInstanceProfileArn?;
    get resourceAwsEc2InstanceIamInstanceProfileArn(): SecurityhubInsightFiltersResourceAwsEc2InstanceIamInstanceProfileArn[] | cdktf.IResolvable;
    set resourceAwsEc2InstanceIamInstanceProfileArn(value: SecurityhubInsightFiltersResourceAwsEc2InstanceIamInstanceProfileArn[] | cdktf.IResolvable);
    resetResourceAwsEc2InstanceIamInstanceProfileArn(): void;
    get resourceAwsEc2InstanceIamInstanceProfileArnInput(): cdktf.IResolvable | SecurityhubInsightFiltersResourceAwsEc2InstanceIamInstanceProfileArn[] | undefined;
    private _resourceAwsEc2InstanceImageId?;
    get resourceAwsEc2InstanceImageId(): SecurityhubInsightFiltersResourceAwsEc2InstanceImageId[] | cdktf.IResolvable;
    set resourceAwsEc2InstanceImageId(value: SecurityhubInsightFiltersResourceAwsEc2InstanceImageId[] | cdktf.IResolvable);
    resetResourceAwsEc2InstanceImageId(): void;
    get resourceAwsEc2InstanceImageIdInput(): cdktf.IResolvable | SecurityhubInsightFiltersResourceAwsEc2InstanceImageId[] | undefined;
    private _resourceAwsEc2InstanceIpv4Addresses?;
    get resourceAwsEc2InstanceIpv4Addresses(): SecurityhubInsightFiltersResourceAwsEc2InstanceIpv4Addresses[] | cdktf.IResolvable;
    set resourceAwsEc2InstanceIpv4Addresses(value: SecurityhubInsightFiltersResourceAwsEc2InstanceIpv4Addresses[] | cdktf.IResolvable);
    resetResourceAwsEc2InstanceIpv4Addresses(): void;
    get resourceAwsEc2InstanceIpv4AddressesInput(): cdktf.IResolvable | SecurityhubInsightFiltersResourceAwsEc2InstanceIpv4Addresses[] | undefined;
    private _resourceAwsEc2InstanceIpv6Addresses?;
    get resourceAwsEc2InstanceIpv6Addresses(): SecurityhubInsightFiltersResourceAwsEc2InstanceIpv6Addresses[] | cdktf.IResolvable;
    set resourceAwsEc2InstanceIpv6Addresses(value: SecurityhubInsightFiltersResourceAwsEc2InstanceIpv6Addresses[] | cdktf.IResolvable);
    resetResourceAwsEc2InstanceIpv6Addresses(): void;
    get resourceAwsEc2InstanceIpv6AddressesInput(): cdktf.IResolvable | SecurityhubInsightFiltersResourceAwsEc2InstanceIpv6Addresses[] | undefined;
    private _resourceAwsEc2InstanceKeyName?;
    get resourceAwsEc2InstanceKeyName(): SecurityhubInsightFiltersResourceAwsEc2InstanceKeyName[] | cdktf.IResolvable;
    set resourceAwsEc2InstanceKeyName(value: SecurityhubInsightFiltersResourceAwsEc2InstanceKeyName[] | cdktf.IResolvable);
    resetResourceAwsEc2InstanceKeyName(): void;
    get resourceAwsEc2InstanceKeyNameInput(): cdktf.IResolvable | SecurityhubInsightFiltersResourceAwsEc2InstanceKeyName[] | undefined;
    private _resourceAwsEc2InstanceLaunchedAt?;
    get resourceAwsEc2InstanceLaunchedAt(): SecurityhubInsightFiltersResourceAwsEc2InstanceLaunchedAt[] | cdktf.IResolvable;
    set resourceAwsEc2InstanceLaunchedAt(value: SecurityhubInsightFiltersResourceAwsEc2InstanceLaunchedAt[] | cdktf.IResolvable);
    resetResourceAwsEc2InstanceLaunchedAt(): void;
    get resourceAwsEc2InstanceLaunchedAtInput(): cdktf.IResolvable | SecurityhubInsightFiltersResourceAwsEc2InstanceLaunchedAt[] | undefined;
    private _resourceAwsEc2InstanceSubnetId?;
    get resourceAwsEc2InstanceSubnetId(): SecurityhubInsightFiltersResourceAwsEc2InstanceSubnetId[] | cdktf.IResolvable;
    set resourceAwsEc2InstanceSubnetId(value: SecurityhubInsightFiltersResourceAwsEc2InstanceSubnetId[] | cdktf.IResolvable);
    resetResourceAwsEc2InstanceSubnetId(): void;
    get resourceAwsEc2InstanceSubnetIdInput(): cdktf.IResolvable | SecurityhubInsightFiltersResourceAwsEc2InstanceSubnetId[] | undefined;
    private _resourceAwsEc2InstanceType?;
    get resourceAwsEc2InstanceType(): SecurityhubInsightFiltersResourceAwsEc2InstanceType[] | cdktf.IResolvable;
    set resourceAwsEc2InstanceType(value: SecurityhubInsightFiltersResourceAwsEc2InstanceType[] | cdktf.IResolvable);
    resetResourceAwsEc2InstanceType(): void;
    get resourceAwsEc2InstanceTypeInput(): cdktf.IResolvable | SecurityhubInsightFiltersResourceAwsEc2InstanceType[] | undefined;
    private _resourceAwsEc2InstanceVpcId?;
    get resourceAwsEc2InstanceVpcId(): SecurityhubInsightFiltersResourceAwsEc2InstanceVpcId[] | cdktf.IResolvable;
    set resourceAwsEc2InstanceVpcId(value: SecurityhubInsightFiltersResourceAwsEc2InstanceVpcId[] | cdktf.IResolvable);
    resetResourceAwsEc2InstanceVpcId(): void;
    get resourceAwsEc2InstanceVpcIdInput(): cdktf.IResolvable | SecurityhubInsightFiltersResourceAwsEc2InstanceVpcId[] | undefined;
    private _resourceAwsIamAccessKeyCreatedAt?;
    get resourceAwsIamAccessKeyCreatedAt(): SecurityhubInsightFiltersResourceAwsIamAccessKeyCreatedAt[] | cdktf.IResolvable;
    set resourceAwsIamAccessKeyCreatedAt(value: SecurityhubInsightFiltersResourceAwsIamAccessKeyCreatedAt[] | cdktf.IResolvable);
    resetResourceAwsIamAccessKeyCreatedAt(): void;
    get resourceAwsIamAccessKeyCreatedAtInput(): cdktf.IResolvable | SecurityhubInsightFiltersResourceAwsIamAccessKeyCreatedAt[] | undefined;
    private _resourceAwsIamAccessKeyStatus?;
    get resourceAwsIamAccessKeyStatus(): SecurityhubInsightFiltersResourceAwsIamAccessKeyStatus[] | cdktf.IResolvable;
    set resourceAwsIamAccessKeyStatus(value: SecurityhubInsightFiltersResourceAwsIamAccessKeyStatus[] | cdktf.IResolvable);
    resetResourceAwsIamAccessKeyStatus(): void;
    get resourceAwsIamAccessKeyStatusInput(): cdktf.IResolvable | SecurityhubInsightFiltersResourceAwsIamAccessKeyStatus[] | undefined;
    private _resourceAwsIamAccessKeyUserName?;
    get resourceAwsIamAccessKeyUserName(): SecurityhubInsightFiltersResourceAwsIamAccessKeyUserName[] | cdktf.IResolvable;
    set resourceAwsIamAccessKeyUserName(value: SecurityhubInsightFiltersResourceAwsIamAccessKeyUserName[] | cdktf.IResolvable);
    resetResourceAwsIamAccessKeyUserName(): void;
    get resourceAwsIamAccessKeyUserNameInput(): cdktf.IResolvable | SecurityhubInsightFiltersResourceAwsIamAccessKeyUserName[] | undefined;
    private _resourceAwsS3BucketOwnerId?;
    get resourceAwsS3BucketOwnerId(): SecurityhubInsightFiltersResourceAwsS3BucketOwnerId[] | cdktf.IResolvable;
    set resourceAwsS3BucketOwnerId(value: SecurityhubInsightFiltersResourceAwsS3BucketOwnerId[] | cdktf.IResolvable);
    resetResourceAwsS3BucketOwnerId(): void;
    get resourceAwsS3BucketOwnerIdInput(): cdktf.IResolvable | SecurityhubInsightFiltersResourceAwsS3BucketOwnerId[] | undefined;
    private _resourceAwsS3BucketOwnerName?;
    get resourceAwsS3BucketOwnerName(): SecurityhubInsightFiltersResourceAwsS3BucketOwnerName[] | cdktf.IResolvable;
    set resourceAwsS3BucketOwnerName(value: SecurityhubInsightFiltersResourceAwsS3BucketOwnerName[] | cdktf.IResolvable);
    resetResourceAwsS3BucketOwnerName(): void;
    get resourceAwsS3BucketOwnerNameInput(): cdktf.IResolvable | SecurityhubInsightFiltersResourceAwsS3BucketOwnerName[] | undefined;
    private _resourceContainerImageId?;
    get resourceContainerImageId(): SecurityhubInsightFiltersResourceContainerImageId[] | cdktf.IResolvable;
    set resourceContainerImageId(value: SecurityhubInsightFiltersResourceContainerImageId[] | cdktf.IResolvable);
    resetResourceContainerImageId(): void;
    get resourceContainerImageIdInput(): cdktf.IResolvable | SecurityhubInsightFiltersResourceContainerImageId[] | undefined;
    private _resourceContainerImageName?;
    get resourceContainerImageName(): SecurityhubInsightFiltersResourceContainerImageName[] | cdktf.IResolvable;
    set resourceContainerImageName(value: SecurityhubInsightFiltersResourceContainerImageName[] | cdktf.IResolvable);
    resetResourceContainerImageName(): void;
    get resourceContainerImageNameInput(): cdktf.IResolvable | SecurityhubInsightFiltersResourceContainerImageName[] | undefined;
    private _resourceContainerLaunchedAt?;
    get resourceContainerLaunchedAt(): SecurityhubInsightFiltersResourceContainerLaunchedAt[] | cdktf.IResolvable;
    set resourceContainerLaunchedAt(value: SecurityhubInsightFiltersResourceContainerLaunchedAt[] | cdktf.IResolvable);
    resetResourceContainerLaunchedAt(): void;
    get resourceContainerLaunchedAtInput(): cdktf.IResolvable | SecurityhubInsightFiltersResourceContainerLaunchedAt[] | undefined;
    private _resourceContainerName?;
    get resourceContainerName(): SecurityhubInsightFiltersResourceContainerName[] | cdktf.IResolvable;
    set resourceContainerName(value: SecurityhubInsightFiltersResourceContainerName[] | cdktf.IResolvable);
    resetResourceContainerName(): void;
    get resourceContainerNameInput(): cdktf.IResolvable | SecurityhubInsightFiltersResourceContainerName[] | undefined;
    private _resourceDetailsOther?;
    get resourceDetailsOther(): SecurityhubInsightFiltersResourceDetailsOther[] | cdktf.IResolvable;
    set resourceDetailsOther(value: SecurityhubInsightFiltersResourceDetailsOther[] | cdktf.IResolvable);
    resetResourceDetailsOther(): void;
    get resourceDetailsOtherInput(): cdktf.IResolvable | SecurityhubInsightFiltersResourceDetailsOther[] | undefined;
    private _resourceId?;
    get resourceId(): SecurityhubInsightFiltersResourceId[] | cdktf.IResolvable;
    set resourceId(value: SecurityhubInsightFiltersResourceId[] | cdktf.IResolvable);
    resetResourceId(): void;
    get resourceIdInput(): cdktf.IResolvable | SecurityhubInsightFiltersResourceId[] | undefined;
    private _resourcePartition?;
    get resourcePartition(): SecurityhubInsightFiltersResourcePartition[] | cdktf.IResolvable;
    set resourcePartition(value: SecurityhubInsightFiltersResourcePartition[] | cdktf.IResolvable);
    resetResourcePartition(): void;
    get resourcePartitionInput(): cdktf.IResolvable | SecurityhubInsightFiltersResourcePartition[] | undefined;
    private _resourceRegion?;
    get resourceRegion(): SecurityhubInsightFiltersResourceRegion[] | cdktf.IResolvable;
    set resourceRegion(value: SecurityhubInsightFiltersResourceRegion[] | cdktf.IResolvable);
    resetResourceRegion(): void;
    get resourceRegionInput(): cdktf.IResolvable | SecurityhubInsightFiltersResourceRegion[] | undefined;
    private _resourceTags?;
    get resourceTags(): SecurityhubInsightFiltersResourceTags[] | cdktf.IResolvable;
    set resourceTags(value: SecurityhubInsightFiltersResourceTags[] | cdktf.IResolvable);
    resetResourceTags(): void;
    get resourceTagsInput(): cdktf.IResolvable | SecurityhubInsightFiltersResourceTags[] | undefined;
    private _resourceType?;
    get resourceType(): SecurityhubInsightFiltersResourceType[] | cdktf.IResolvable;
    set resourceType(value: SecurityhubInsightFiltersResourceType[] | cdktf.IResolvable);
    resetResourceType(): void;
    get resourceTypeInput(): cdktf.IResolvable | SecurityhubInsightFiltersResourceType[] | undefined;
    private _severityLabel?;
    get severityLabel(): SecurityhubInsightFiltersSeverityLabel[] | cdktf.IResolvable;
    set severityLabel(value: SecurityhubInsightFiltersSeverityLabel[] | cdktf.IResolvable);
    resetSeverityLabel(): void;
    get severityLabelInput(): cdktf.IResolvable | SecurityhubInsightFiltersSeverityLabel[] | undefined;
    private _sourceUrl?;
    get sourceUrl(): SecurityhubInsightFiltersSourceUrl[] | cdktf.IResolvable;
    set sourceUrl(value: SecurityhubInsightFiltersSourceUrl[] | cdktf.IResolvable);
    resetSourceUrl(): void;
    get sourceUrlInput(): cdktf.IResolvable | SecurityhubInsightFiltersSourceUrl[] | undefined;
    private _threatIntelIndicatorCategory?;
    get threatIntelIndicatorCategory(): SecurityhubInsightFiltersThreatIntelIndicatorCategory[] | cdktf.IResolvable;
    set threatIntelIndicatorCategory(value: SecurityhubInsightFiltersThreatIntelIndicatorCategory[] | cdktf.IResolvable);
    resetThreatIntelIndicatorCategory(): void;
    get threatIntelIndicatorCategoryInput(): cdktf.IResolvable | SecurityhubInsightFiltersThreatIntelIndicatorCategory[] | undefined;
    private _threatIntelIndicatorLastObservedAt?;
    get threatIntelIndicatorLastObservedAt(): SecurityhubInsightFiltersThreatIntelIndicatorLastObservedAt[] | cdktf.IResolvable;
    set threatIntelIndicatorLastObservedAt(value: SecurityhubInsightFiltersThreatIntelIndicatorLastObservedAt[] | cdktf.IResolvable);
    resetThreatIntelIndicatorLastObservedAt(): void;
    get threatIntelIndicatorLastObservedAtInput(): cdktf.IResolvable | SecurityhubInsightFiltersThreatIntelIndicatorLastObservedAt[] | undefined;
    private _threatIntelIndicatorSource?;
    get threatIntelIndicatorSource(): SecurityhubInsightFiltersThreatIntelIndicatorSource[] | cdktf.IResolvable;
    set threatIntelIndicatorSource(value: SecurityhubInsightFiltersThreatIntelIndicatorSource[] | cdktf.IResolvable);
    resetThreatIntelIndicatorSource(): void;
    get threatIntelIndicatorSourceInput(): cdktf.IResolvable | SecurityhubInsightFiltersThreatIntelIndicatorSource[] | undefined;
    private _threatIntelIndicatorSourceUrl?;
    get threatIntelIndicatorSourceUrl(): SecurityhubInsightFiltersThreatIntelIndicatorSourceUrl[] | cdktf.IResolvable;
    set threatIntelIndicatorSourceUrl(value: SecurityhubInsightFiltersThreatIntelIndicatorSourceUrl[] | cdktf.IResolvable);
    resetThreatIntelIndicatorSourceUrl(): void;
    get threatIntelIndicatorSourceUrlInput(): cdktf.IResolvable | SecurityhubInsightFiltersThreatIntelIndicatorSourceUrl[] | undefined;
    private _threatIntelIndicatorType?;
    get threatIntelIndicatorType(): SecurityhubInsightFiltersThreatIntelIndicatorType[] | cdktf.IResolvable;
    set threatIntelIndicatorType(value: SecurityhubInsightFiltersThreatIntelIndicatorType[] | cdktf.IResolvable);
    resetThreatIntelIndicatorType(): void;
    get threatIntelIndicatorTypeInput(): cdktf.IResolvable | SecurityhubInsightFiltersThreatIntelIndicatorType[] | undefined;
    private _threatIntelIndicatorValue?;
    get threatIntelIndicatorValue(): SecurityhubInsightFiltersThreatIntelIndicatorValue[] | cdktf.IResolvable;
    set threatIntelIndicatorValue(value: SecurityhubInsightFiltersThreatIntelIndicatorValue[] | cdktf.IResolvable);
    resetThreatIntelIndicatorValue(): void;
    get threatIntelIndicatorValueInput(): cdktf.IResolvable | SecurityhubInsightFiltersThreatIntelIndicatorValue[] | undefined;
    private _title?;
    get title(): SecurityhubInsightFiltersTitle[] | cdktf.IResolvable;
    set title(value: SecurityhubInsightFiltersTitle[] | cdktf.IResolvable);
    resetTitle(): void;
    get titleInput(): cdktf.IResolvable | SecurityhubInsightFiltersTitle[] | undefined;
    private _type?;
    get type(): SecurityhubInsightFiltersType[] | cdktf.IResolvable;
    set type(value: SecurityhubInsightFiltersType[] | cdktf.IResolvable);
    resetType(): void;
    get typeInput(): cdktf.IResolvable | SecurityhubInsightFiltersType[] | undefined;
    private _updatedAt?;
    get updatedAt(): SecurityhubInsightFiltersUpdatedAt[] | cdktf.IResolvable;
    set updatedAt(value: SecurityhubInsightFiltersUpdatedAt[] | cdktf.IResolvable);
    resetUpdatedAt(): void;
    get updatedAtInput(): cdktf.IResolvable | SecurityhubInsightFiltersUpdatedAt[] | undefined;
    private _userDefinedValues?;
    get userDefinedValues(): SecurityhubInsightFiltersUserDefinedValues[] | cdktf.IResolvable;
    set userDefinedValues(value: SecurityhubInsightFiltersUserDefinedValues[] | cdktf.IResolvable);
    resetUserDefinedValues(): void;
    get userDefinedValuesInput(): cdktf.IResolvable | SecurityhubInsightFiltersUserDefinedValues[] | undefined;
    private _verificationState?;
    get verificationState(): SecurityhubInsightFiltersVerificationState[] | cdktf.IResolvable;
    set verificationState(value: SecurityhubInsightFiltersVerificationState[] | cdktf.IResolvable);
    resetVerificationState(): void;
    get verificationStateInput(): cdktf.IResolvable | SecurityhubInsightFiltersVerificationState[] | undefined;
    private _workflowStatus?;
    get workflowStatus(): SecurityhubInsightFiltersWorkflowStatus[] | cdktf.IResolvable;
    set workflowStatus(value: SecurityhubInsightFiltersWorkflowStatus[] | cdktf.IResolvable);
    resetWorkflowStatus(): void;
    get workflowStatusInput(): cdktf.IResolvable | SecurityhubInsightFiltersWorkflowStatus[] | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight aws_securityhub_insight}
*/
export declare class SecurityhubInsight extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_securityhub_insight";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/securityhub_insight aws_securityhub_insight} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SecurityhubInsightConfig
    */
    constructor(scope: Construct, id: string, config: SecurityhubInsightConfig);
    get arn(): string;
    private _groupByAttribute?;
    get groupByAttribute(): string;
    set groupByAttribute(value: string);
    get groupByAttributeInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _filters;
    get filters(): SecurityhubInsightFiltersOutputReference;
    putFilters(value: SecurityhubInsightFilters): void;
    get filtersInput(): SecurityhubInsightFilters | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=securityhub-insight.d.ts.map