import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Service Catalog
*/
export interface ServicecatalogOrganizationsAccessConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/servicecatalog_organizations_access#enabled ServicecatalogOrganizationsAccess#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/servicecatalog_organizations_access#timeouts ServicecatalogOrganizationsAccess#timeouts}
    */
    readonly timeouts?: ServicecatalogOrganizationsAccessTimeouts;
}
export interface ServicecatalogOrganizationsAccessTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/servicecatalog_organizations_access#read ServicecatalogOrganizationsAccess#read}
    */
    readonly read?: string;
}
export declare function servicecatalogOrganizationsAccessTimeoutsToTerraform(struct?: ServicecatalogOrganizationsAccessTimeoutsOutputReference | ServicecatalogOrganizationsAccessTimeouts | cdktf.IResolvable): any;
export declare class ServicecatalogOrganizationsAccessTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ServicecatalogOrganizationsAccessTimeouts | undefined;
    set internalValue(value: ServicecatalogOrganizationsAccessTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/servicecatalog_organizations_access aws_servicecatalog_organizations_access}
*/
export declare class ServicecatalogOrganizationsAccess extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_servicecatalog_organizations_access";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/servicecatalog_organizations_access aws_servicecatalog_organizations_access} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ServicecatalogOrganizationsAccessConfig
    */
    constructor(scope: Construct, id: string, config: ServicecatalogOrganizationsAccessConfig);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _timeouts;
    get timeouts(): ServicecatalogOrganizationsAccessTimeoutsOutputReference;
    putTimeouts(value: ServicecatalogOrganizationsAccessTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ServicecatalogOrganizationsAccessTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=servicecatalog-organizations-access.d.ts.map