import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Service Catalog
*/
export interface ServicecatalogTagOptionResourceAssociationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/servicecatalog_tag_option_resource_association#resource_id ServicecatalogTagOptionResourceAssociation#resource_id}
    */
    readonly resourceId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/servicecatalog_tag_option_resource_association#tag_option_id ServicecatalogTagOptionResourceAssociation#tag_option_id}
    */
    readonly tagOptionId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/servicecatalog_tag_option_resource_association#timeouts ServicecatalogTagOptionResourceAssociation#timeouts}
    */
    readonly timeouts?: ServicecatalogTagOptionResourceAssociationTimeouts;
}
export interface ServicecatalogTagOptionResourceAssociationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/servicecatalog_tag_option_resource_association#create ServicecatalogTagOptionResourceAssociation#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/servicecatalog_tag_option_resource_association#delete ServicecatalogTagOptionResourceAssociation#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/servicecatalog_tag_option_resource_association#read ServicecatalogTagOptionResourceAssociation#read}
    */
    readonly read?: string;
}
export declare function servicecatalogTagOptionResourceAssociationTimeoutsToTerraform(struct?: ServicecatalogTagOptionResourceAssociationTimeoutsOutputReference | ServicecatalogTagOptionResourceAssociationTimeouts | cdktf.IResolvable): any;
export declare class ServicecatalogTagOptionResourceAssociationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ServicecatalogTagOptionResourceAssociationTimeouts | undefined;
    set internalValue(value: ServicecatalogTagOptionResourceAssociationTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/servicecatalog_tag_option_resource_association aws_servicecatalog_tag_option_resource_association}
*/
export declare class ServicecatalogTagOptionResourceAssociation extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_servicecatalog_tag_option_resource_association";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/servicecatalog_tag_option_resource_association aws_servicecatalog_tag_option_resource_association} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ServicecatalogTagOptionResourceAssociationConfig
    */
    constructor(scope: Construct, id: string, config: ServicecatalogTagOptionResourceAssociationConfig);
    get id(): string;
    get resourceArn(): string;
    get resourceCreatedTime(): string;
    get resourceDescription(): string;
    private _resourceId?;
    get resourceId(): string;
    set resourceId(value: string);
    get resourceIdInput(): string | undefined;
    get resourceName(): string;
    private _tagOptionId?;
    get tagOptionId(): string;
    set tagOptionId(value: string);
    get tagOptionIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): ServicecatalogTagOptionResourceAssociationTimeoutsOutputReference;
    putTimeouts(value: ServicecatalogTagOptionResourceAssociationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ServicecatalogTagOptionResourceAssociationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=servicecatalog-tag-option-resource-association.d.ts.map