import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Service Quotas
*/
export interface ServicequotasServiceQuotaConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/servicequotas_service_quota#quota_code ServicequotasServiceQuota#quota_code}
    */
    readonly quotaCode: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/servicequotas_service_quota#service_code ServicequotasServiceQuota#service_code}
    */
    readonly serviceCode: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/servicequotas_service_quota#value ServicequotasServiceQuota#value}
    */
    readonly value: number;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/servicequotas_service_quota aws_servicequotas_service_quota}
*/
export declare class ServicequotasServiceQuota extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_servicequotas_service_quota";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/servicequotas_service_quota aws_servicequotas_service_quota} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ServicequotasServiceQuotaConfig
    */
    constructor(scope: Construct, id: string, config: ServicequotasServiceQuotaConfig);
    get adjustable(): cdktf.IResolvable;
    get arn(): string;
    get defaultValue(): number;
    get id(): string;
    private _quotaCode?;
    get quotaCode(): string;
    set quotaCode(value: string);
    get quotaCodeInput(): string | undefined;
    get quotaName(): string;
    get requestId(): string;
    get requestStatus(): string;
    private _serviceCode?;
    get serviceCode(): string;
    set serviceCode(value: string);
    get serviceCodeInput(): string | undefined;
    get serviceName(): string;
    private _value?;
    get value(): number;
    set value(value: number);
    get valueInput(): number | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=servicequotas-service-quota.d.ts.map