import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Simple Email Service
*/
export interface DataAwsSesEmailIdentityConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ses_email_identity#email DataAwsSesEmailIdentity#email}
    */
    readonly email: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/d/ses_email_identity aws_ses_email_identity}
*/
export declare class DataAwsSesEmailIdentity extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "aws_ses_email_identity";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/d/ses_email_identity aws_ses_email_identity} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAwsSesEmailIdentityConfig
    */
    constructor(scope: Construct, id: string, config: DataAwsSesEmailIdentityConfig);
    get arn(): string;
    private _email?;
    get email(): string;
    set email(value: string);
    get emailInput(): string | undefined;
    get id(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-aws-ses-email-identity.d.ts.map