import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Simple Email Service
*/
export interface SesDomainDkimConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ses_domain_dkim#domain SesDomainDkim#domain}
    */
    readonly domain: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/ses_domain_dkim aws_ses_domain_dkim}
*/
export declare class SesDomainDkim extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_ses_domain_dkim";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/ses_domain_dkim aws_ses_domain_dkim} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SesDomainDkimConfig
    */
    constructor(scope: Construct, id: string, config: SesDomainDkimConfig);
    get dkimTokens(): string[];
    private _domain?;
    get domain(): string;
    set domain(value: string);
    get domainInput(): string | undefined;
    get id(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=ses-domain-dkim.d.ts.map