import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Simple Email Service
*/
export interface SesReceiptRuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ses_receipt_rule#after SesReceiptRule#after}
    */
    readonly after?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ses_receipt_rule#enabled SesReceiptRule#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ses_receipt_rule#name SesReceiptRule#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ses_receipt_rule#recipients SesReceiptRule#recipients}
    */
    readonly recipients?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ses_receipt_rule#rule_set_name SesReceiptRule#rule_set_name}
    */
    readonly ruleSetName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ses_receipt_rule#scan_enabled SesReceiptRule#scan_enabled}
    */
    readonly scanEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ses_receipt_rule#tls_policy SesReceiptRule#tls_policy}
    */
    readonly tlsPolicy?: string;
    /**
    * add_header_action block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ses_receipt_rule#add_header_action SesReceiptRule#add_header_action}
    */
    readonly addHeaderAction?: SesReceiptRuleAddHeaderAction[] | cdktf.IResolvable;
    /**
    * bounce_action block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ses_receipt_rule#bounce_action SesReceiptRule#bounce_action}
    */
    readonly bounceAction?: SesReceiptRuleBounceAction[] | cdktf.IResolvable;
    /**
    * lambda_action block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ses_receipt_rule#lambda_action SesReceiptRule#lambda_action}
    */
    readonly lambdaAction?: SesReceiptRuleLambdaAction[] | cdktf.IResolvable;
    /**
    * s3_action block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ses_receipt_rule#s3_action SesReceiptRule#s3_action}
    */
    readonly s3Action?: SesReceiptRuleS3Action[] | cdktf.IResolvable;
    /**
    * sns_action block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ses_receipt_rule#sns_action SesReceiptRule#sns_action}
    */
    readonly snsAction?: SesReceiptRuleSnsAction[] | cdktf.IResolvable;
    /**
    * stop_action block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ses_receipt_rule#stop_action SesReceiptRule#stop_action}
    */
    readonly stopAction?: SesReceiptRuleStopAction[] | cdktf.IResolvable;
    /**
    * workmail_action block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ses_receipt_rule#workmail_action SesReceiptRule#workmail_action}
    */
    readonly workmailAction?: SesReceiptRuleWorkmailAction[] | cdktf.IResolvable;
}
export interface SesReceiptRuleAddHeaderAction {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ses_receipt_rule#header_name SesReceiptRule#header_name}
    */
    readonly headerName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ses_receipt_rule#header_value SesReceiptRule#header_value}
    */
    readonly headerValue: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ses_receipt_rule#position SesReceiptRule#position}
    */
    readonly position: number;
}
export declare function sesReceiptRuleAddHeaderActionToTerraform(struct?: SesReceiptRuleAddHeaderAction | cdktf.IResolvable): any;
export interface SesReceiptRuleBounceAction {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ses_receipt_rule#message SesReceiptRule#message}
    */
    readonly message: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ses_receipt_rule#position SesReceiptRule#position}
    */
    readonly position: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ses_receipt_rule#sender SesReceiptRule#sender}
    */
    readonly sender: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ses_receipt_rule#smtp_reply_code SesReceiptRule#smtp_reply_code}
    */
    readonly smtpReplyCode: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ses_receipt_rule#status_code SesReceiptRule#status_code}
    */
    readonly statusCode?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ses_receipt_rule#topic_arn SesReceiptRule#topic_arn}
    */
    readonly topicArn?: string;
}
export declare function sesReceiptRuleBounceActionToTerraform(struct?: SesReceiptRuleBounceAction | cdktf.IResolvable): any;
export interface SesReceiptRuleLambdaAction {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ses_receipt_rule#function_arn SesReceiptRule#function_arn}
    */
    readonly functionArn: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ses_receipt_rule#invocation_type SesReceiptRule#invocation_type}
    */
    readonly invocationType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ses_receipt_rule#position SesReceiptRule#position}
    */
    readonly position: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ses_receipt_rule#topic_arn SesReceiptRule#topic_arn}
    */
    readonly topicArn?: string;
}
export declare function sesReceiptRuleLambdaActionToTerraform(struct?: SesReceiptRuleLambdaAction | cdktf.IResolvable): any;
export interface SesReceiptRuleS3Action {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ses_receipt_rule#bucket_name SesReceiptRule#bucket_name}
    */
    readonly bucketName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ses_receipt_rule#kms_key_arn SesReceiptRule#kms_key_arn}
    */
    readonly kmsKeyArn?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ses_receipt_rule#object_key_prefix SesReceiptRule#object_key_prefix}
    */
    readonly objectKeyPrefix?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ses_receipt_rule#position SesReceiptRule#position}
    */
    readonly position: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ses_receipt_rule#topic_arn SesReceiptRule#topic_arn}
    */
    readonly topicArn?: string;
}
export declare function sesReceiptRuleS3ActionToTerraform(struct?: SesReceiptRuleS3Action | cdktf.IResolvable): any;
export interface SesReceiptRuleSnsAction {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ses_receipt_rule#encoding SesReceiptRule#encoding}
    */
    readonly encoding?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ses_receipt_rule#position SesReceiptRule#position}
    */
    readonly position: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ses_receipt_rule#topic_arn SesReceiptRule#topic_arn}
    */
    readonly topicArn: string;
}
export declare function sesReceiptRuleSnsActionToTerraform(struct?: SesReceiptRuleSnsAction | cdktf.IResolvable): any;
export interface SesReceiptRuleStopAction {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ses_receipt_rule#position SesReceiptRule#position}
    */
    readonly position: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ses_receipt_rule#scope SesReceiptRule#scope}
    */
    readonly scope: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ses_receipt_rule#topic_arn SesReceiptRule#topic_arn}
    */
    readonly topicArn?: string;
}
export declare function sesReceiptRuleStopActionToTerraform(struct?: SesReceiptRuleStopAction | cdktf.IResolvable): any;
export interface SesReceiptRuleWorkmailAction {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ses_receipt_rule#organization_arn SesReceiptRule#organization_arn}
    */
    readonly organizationArn: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ses_receipt_rule#position SesReceiptRule#position}
    */
    readonly position: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ses_receipt_rule#topic_arn SesReceiptRule#topic_arn}
    */
    readonly topicArn?: string;
}
export declare function sesReceiptRuleWorkmailActionToTerraform(struct?: SesReceiptRuleWorkmailAction | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/ses_receipt_rule aws_ses_receipt_rule}
*/
export declare class SesReceiptRule extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_ses_receipt_rule";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/ses_receipt_rule aws_ses_receipt_rule} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SesReceiptRuleConfig
    */
    constructor(scope: Construct, id: string, config: SesReceiptRuleConfig);
    private _after?;
    get after(): string;
    set after(value: string);
    resetAfter(): void;
    get afterInput(): string | undefined;
    get arn(): string;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _recipients?;
    get recipients(): string[];
    set recipients(value: string[]);
    resetRecipients(): void;
    get recipientsInput(): string[] | undefined;
    private _ruleSetName?;
    get ruleSetName(): string;
    set ruleSetName(value: string);
    get ruleSetNameInput(): string | undefined;
    private _scanEnabled?;
    get scanEnabled(): boolean | cdktf.IResolvable;
    set scanEnabled(value: boolean | cdktf.IResolvable);
    resetScanEnabled(): void;
    get scanEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _tlsPolicy?;
    get tlsPolicy(): string;
    set tlsPolicy(value: string);
    resetTlsPolicy(): void;
    get tlsPolicyInput(): string | undefined;
    private _addHeaderAction?;
    get addHeaderAction(): SesReceiptRuleAddHeaderAction[] | cdktf.IResolvable;
    set addHeaderAction(value: SesReceiptRuleAddHeaderAction[] | cdktf.IResolvable);
    resetAddHeaderAction(): void;
    get addHeaderActionInput(): cdktf.IResolvable | SesReceiptRuleAddHeaderAction[] | undefined;
    private _bounceAction?;
    get bounceAction(): SesReceiptRuleBounceAction[] | cdktf.IResolvable;
    set bounceAction(value: SesReceiptRuleBounceAction[] | cdktf.IResolvable);
    resetBounceAction(): void;
    get bounceActionInput(): cdktf.IResolvable | SesReceiptRuleBounceAction[] | undefined;
    private _lambdaAction?;
    get lambdaAction(): SesReceiptRuleLambdaAction[] | cdktf.IResolvable;
    set lambdaAction(value: SesReceiptRuleLambdaAction[] | cdktf.IResolvable);
    resetLambdaAction(): void;
    get lambdaActionInput(): cdktf.IResolvable | SesReceiptRuleLambdaAction[] | undefined;
    private _s3Action?;
    get s3Action(): SesReceiptRuleS3Action[] | cdktf.IResolvable;
    set s3Action(value: SesReceiptRuleS3Action[] | cdktf.IResolvable);
    resetS3Action(): void;
    get s3ActionInput(): cdktf.IResolvable | SesReceiptRuleS3Action[] | undefined;
    private _snsAction?;
    get snsAction(): SesReceiptRuleSnsAction[] | cdktf.IResolvable;
    set snsAction(value: SesReceiptRuleSnsAction[] | cdktf.IResolvable);
    resetSnsAction(): void;
    get snsActionInput(): cdktf.IResolvable | SesReceiptRuleSnsAction[] | undefined;
    private _stopAction?;
    get stopAction(): SesReceiptRuleStopAction[] | cdktf.IResolvable;
    set stopAction(value: SesReceiptRuleStopAction[] | cdktf.IResolvable);
    resetStopAction(): void;
    get stopActionInput(): cdktf.IResolvable | SesReceiptRuleStopAction[] | undefined;
    private _workmailAction?;
    get workmailAction(): SesReceiptRuleWorkmailAction[] | cdktf.IResolvable;
    set workmailAction(value: SesReceiptRuleWorkmailAction[] | cdktf.IResolvable);
    resetWorkmailAction(): void;
    get workmailActionInput(): cdktf.IResolvable | SesReceiptRuleWorkmailAction[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=ses-receipt-rule.d.ts.map