import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Shield Protection
*/
export interface ShieldProtectionHealthCheckAssociationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/shield_protection_health_check_association#health_check_arn ShieldProtectionHealthCheckAssociation#health_check_arn}
    */
    readonly healthCheckArn: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/shield_protection_health_check_association#shield_protection_id ShieldProtectionHealthCheckAssociation#shield_protection_id}
    */
    readonly shieldProtectionId: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/shield_protection_health_check_association aws_shield_protection_health_check_association}
*/
export declare class ShieldProtectionHealthCheckAssociation extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_shield_protection_health_check_association";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/shield_protection_health_check_association aws_shield_protection_health_check_association} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ShieldProtectionHealthCheckAssociationConfig
    */
    constructor(scope: Construct, id: string, config: ShieldProtectionHealthCheckAssociationConfig);
    private _healthCheckArn?;
    get healthCheckArn(): string;
    set healthCheckArn(value: string);
    get healthCheckArnInput(): string | undefined;
    get id(): string;
    private _shieldProtectionId?;
    get shieldProtectionId(): string;
    set shieldProtectionId(value: string);
    get shieldProtectionIdInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=shield-protection-health-check-association.d.ts.map