import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Signer
*/
export interface DataAwsSignerSigningJobConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/signer_signing_job#job_id DataAwsSignerSigningJob#job_id}
    */
    readonly jobId: string;
}
export interface DataAwsSignerSigningJobRevocationRecord {
}
export declare function dataAwsSignerSigningJobRevocationRecordToTerraform(struct?: DataAwsSignerSigningJobRevocationRecord): any;
export declare class DataAwsSignerSigningJobRevocationRecordOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAwsSignerSigningJobRevocationRecord | undefined;
    set internalValue(value: DataAwsSignerSigningJobRevocationRecord | undefined);
    get reason(): string;
    get revokedAt(): string;
    get revokedBy(): string;
}
export declare class DataAwsSignerSigningJobRevocationRecordList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAwsSignerSigningJobRevocationRecordOutputReference;
}
export interface DataAwsSignerSigningJobSignedObjectS3 {
}
export declare function dataAwsSignerSigningJobSignedObjectS3ToTerraform(struct?: DataAwsSignerSigningJobSignedObjectS3): any;
export declare class DataAwsSignerSigningJobSignedObjectS3OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAwsSignerSigningJobSignedObjectS3 | undefined;
    set internalValue(value: DataAwsSignerSigningJobSignedObjectS3 | undefined);
    get bucket(): string;
    get key(): string;
}
export declare class DataAwsSignerSigningJobSignedObjectS3List extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAwsSignerSigningJobSignedObjectS3OutputReference;
}
export interface DataAwsSignerSigningJobSignedObject {
}
export declare function dataAwsSignerSigningJobSignedObjectToTerraform(struct?: DataAwsSignerSigningJobSignedObject): any;
export declare class DataAwsSignerSigningJobSignedObjectOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAwsSignerSigningJobSignedObject | undefined;
    set internalValue(value: DataAwsSignerSigningJobSignedObject | undefined);
    private _s3;
    get s3(): DataAwsSignerSigningJobSignedObjectS3List;
}
export declare class DataAwsSignerSigningJobSignedObjectList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAwsSignerSigningJobSignedObjectOutputReference;
}
export interface DataAwsSignerSigningJobSourceS3 {
}
export declare function dataAwsSignerSigningJobSourceS3ToTerraform(struct?: DataAwsSignerSigningJobSourceS3): any;
export declare class DataAwsSignerSigningJobSourceS3OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAwsSignerSigningJobSourceS3 | undefined;
    set internalValue(value: DataAwsSignerSigningJobSourceS3 | undefined);
    get bucket(): string;
    get key(): string;
    get version(): string;
}
export declare class DataAwsSignerSigningJobSourceS3List extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAwsSignerSigningJobSourceS3OutputReference;
}
export interface DataAwsSignerSigningJobSource {
}
export declare function dataAwsSignerSigningJobSourceToTerraform(struct?: DataAwsSignerSigningJobSource): any;
export declare class DataAwsSignerSigningJobSourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAwsSignerSigningJobSource | undefined;
    set internalValue(value: DataAwsSignerSigningJobSource | undefined);
    private _s3;
    get s3(): DataAwsSignerSigningJobSourceS3List;
}
export declare class DataAwsSignerSigningJobSourceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAwsSignerSigningJobSourceOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/d/signer_signing_job aws_signer_signing_job}
*/
export declare class DataAwsSignerSigningJob extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "aws_signer_signing_job";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/d/signer_signing_job aws_signer_signing_job} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAwsSignerSigningJobConfig
    */
    constructor(scope: Construct, id: string, config: DataAwsSignerSigningJobConfig);
    get completedAt(): string;
    get createdAt(): string;
    get id(): string;
    private _jobId?;
    get jobId(): string;
    set jobId(value: string);
    get jobIdInput(): string | undefined;
    get jobInvoker(): string;
    get jobOwner(): string;
    get platformDisplayName(): string;
    get platformId(): string;
    get profileName(): string;
    get profileVersion(): string;
    get requestedBy(): string;
    private _revocationRecord;
    get revocationRecord(): DataAwsSignerSigningJobRevocationRecordList;
    get signatureExpiresAt(): string;
    private _signedObject;
    get signedObject(): DataAwsSignerSigningJobSignedObjectList;
    private _source;
    get source(): DataAwsSignerSigningJobSourceList;
    get status(): string;
    get statusReason(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-aws-signer-signing-job.d.ts.map