import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Signer
*/
export interface DataAwsSignerSigningProfileConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/signer_signing_profile#name DataAwsSignerSigningProfile#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/signer_signing_profile#tags DataAwsSignerSigningProfile#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
}
export interface DataAwsSignerSigningProfileRevocationRecord {
}
export declare function dataAwsSignerSigningProfileRevocationRecordToTerraform(struct?: DataAwsSignerSigningProfileRevocationRecord): any;
export declare class DataAwsSignerSigningProfileRevocationRecordOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAwsSignerSigningProfileRevocationRecord | undefined;
    set internalValue(value: DataAwsSignerSigningProfileRevocationRecord | undefined);
    get revocationEffectiveFrom(): string;
    get revokedAt(): string;
    get revokedBy(): string;
}
export declare class DataAwsSignerSigningProfileRevocationRecordList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAwsSignerSigningProfileRevocationRecordOutputReference;
}
export interface DataAwsSignerSigningProfileSignatureValidityPeriod {
}
export declare function dataAwsSignerSigningProfileSignatureValidityPeriodToTerraform(struct?: DataAwsSignerSigningProfileSignatureValidityPeriod): any;
export declare class DataAwsSignerSigningProfileSignatureValidityPeriodOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAwsSignerSigningProfileSignatureValidityPeriod | undefined;
    set internalValue(value: DataAwsSignerSigningProfileSignatureValidityPeriod | undefined);
    get type(): string;
    get value(): number;
}
export declare class DataAwsSignerSigningProfileSignatureValidityPeriodList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAwsSignerSigningProfileSignatureValidityPeriodOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/d/signer_signing_profile aws_signer_signing_profile}
*/
export declare class DataAwsSignerSigningProfile extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "aws_signer_signing_profile";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/d/signer_signing_profile aws_signer_signing_profile} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAwsSignerSigningProfileConfig
    */
    constructor(scope: Construct, id: string, config: DataAwsSignerSigningProfileConfig);
    get arn(): string;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get platformDisplayName(): string;
    get platformId(): string;
    private _revocationRecord;
    get revocationRecord(): DataAwsSignerSigningProfileRevocationRecordList;
    private _signatureValidityPeriod;
    get signatureValidityPeriod(): DataAwsSignerSigningProfileSignatureValidityPeriodList;
    get status(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    get version(): string;
    get versionArn(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-aws-signer-signing-profile.d.ts.map