import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Signer
*/
export interface SignerSigningProfilePermissionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/signer_signing_profile_permission#action SignerSigningProfilePermission#action}
    */
    readonly action: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/signer_signing_profile_permission#principal SignerSigningProfilePermission#principal}
    */
    readonly principal: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/signer_signing_profile_permission#profile_name SignerSigningProfilePermission#profile_name}
    */
    readonly profileName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/signer_signing_profile_permission#profile_version SignerSigningProfilePermission#profile_version}
    */
    readonly profileVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/signer_signing_profile_permission#statement_id SignerSigningProfilePermission#statement_id}
    */
    readonly statementId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/signer_signing_profile_permission#statement_id_prefix SignerSigningProfilePermission#statement_id_prefix}
    */
    readonly statementIdPrefix?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/signer_signing_profile_permission aws_signer_signing_profile_permission}
*/
export declare class SignerSigningProfilePermission extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_signer_signing_profile_permission";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/signer_signing_profile_permission aws_signer_signing_profile_permission} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SignerSigningProfilePermissionConfig
    */
    constructor(scope: Construct, id: string, config: SignerSigningProfilePermissionConfig);
    private _action?;
    get action(): string;
    set action(value: string);
    get actionInput(): string | undefined;
    get id(): string;
    private _principal?;
    get principal(): string;
    set principal(value: string);
    get principalInput(): string | undefined;
    private _profileName?;
    get profileName(): string;
    set profileName(value: string);
    get profileNameInput(): string | undefined;
    private _profileVersion?;
    get profileVersion(): string;
    set profileVersion(value: string);
    resetProfileVersion(): void;
    get profileVersionInput(): string | undefined;
    private _statementId?;
    get statementId(): string;
    set statementId(value: string);
    resetStatementId(): void;
    get statementIdInput(): string | undefined;
    private _statementIdPrefix?;
    get statementIdPrefix(): string;
    set statementIdPrefix(value: string);
    resetStatementIdPrefix(): void;
    get statementIdPrefixInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=signer-signing-profile-permission.d.ts.map