"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SnsPlatformApplication = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/sns_platform_application aws_sns_platform_application}
*/
class SnsPlatformApplication extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/sns_platform_application aws_sns_platform_application} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SnsPlatformApplicationConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'aws_sns_platform_application',
            terraformGeneratorMetadata: {
                providerName: 'aws',
                providerVersion: '4.15.1',
                providerVersionConstraint: '~> 4.0'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._eventDeliveryFailureTopicArn = config.eventDeliveryFailureTopicArn;
        this._eventEndpointCreatedTopicArn = config.eventEndpointCreatedTopicArn;
        this._eventEndpointDeletedTopicArn = config.eventEndpointDeletedTopicArn;
        this._eventEndpointUpdatedTopicArn = config.eventEndpointUpdatedTopicArn;
        this._failureFeedbackRoleArn = config.failureFeedbackRoleArn;
        this._name = config.name;
        this._platform = config.platform;
        this._platformCredential = config.platformCredential;
        this._platformPrincipal = config.platformPrincipal;
        this._successFeedbackRoleArn = config.successFeedbackRoleArn;
        this._successFeedbackSampleRate = config.successFeedbackSampleRate;
    }
    // ==========
    // ATTRIBUTES
    // ==========
    // arn - computed: true, optional: false, required: false
    get arn() {
        return this.getStringAttribute('arn');
    }
    get eventDeliveryFailureTopicArn() {
        return this.getStringAttribute('event_delivery_failure_topic_arn');
    }
    set eventDeliveryFailureTopicArn(value) {
        this._eventDeliveryFailureTopicArn = value;
    }
    resetEventDeliveryFailureTopicArn() {
        this._eventDeliveryFailureTopicArn = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get eventDeliveryFailureTopicArnInput() {
        return this._eventDeliveryFailureTopicArn;
    }
    get eventEndpointCreatedTopicArn() {
        return this.getStringAttribute('event_endpoint_created_topic_arn');
    }
    set eventEndpointCreatedTopicArn(value) {
        this._eventEndpointCreatedTopicArn = value;
    }
    resetEventEndpointCreatedTopicArn() {
        this._eventEndpointCreatedTopicArn = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get eventEndpointCreatedTopicArnInput() {
        return this._eventEndpointCreatedTopicArn;
    }
    get eventEndpointDeletedTopicArn() {
        return this.getStringAttribute('event_endpoint_deleted_topic_arn');
    }
    set eventEndpointDeletedTopicArn(value) {
        this._eventEndpointDeletedTopicArn = value;
    }
    resetEventEndpointDeletedTopicArn() {
        this._eventEndpointDeletedTopicArn = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get eventEndpointDeletedTopicArnInput() {
        return this._eventEndpointDeletedTopicArn;
    }
    get eventEndpointUpdatedTopicArn() {
        return this.getStringAttribute('event_endpoint_updated_topic_arn');
    }
    set eventEndpointUpdatedTopicArn(value) {
        this._eventEndpointUpdatedTopicArn = value;
    }
    resetEventEndpointUpdatedTopicArn() {
        this._eventEndpointUpdatedTopicArn = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get eventEndpointUpdatedTopicArnInput() {
        return this._eventEndpointUpdatedTopicArn;
    }
    get failureFeedbackRoleArn() {
        return this.getStringAttribute('failure_feedback_role_arn');
    }
    set failureFeedbackRoleArn(value) {
        this._failureFeedbackRoleArn = value;
    }
    resetFailureFeedbackRoleArn() {
        this._failureFeedbackRoleArn = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get failureFeedbackRoleArnInput() {
        return this._failureFeedbackRoleArn;
    }
    // id - computed: true, optional: true, required: false
    get id() {
        return this.getStringAttribute('id');
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get platform() {
        return this.getStringAttribute('platform');
    }
    set platform(value) {
        this._platform = value;
    }
    // Temporarily expose input value. Use with caution.
    get platformInput() {
        return this._platform;
    }
    get platformCredential() {
        return this.getStringAttribute('platform_credential');
    }
    set platformCredential(value) {
        this._platformCredential = value;
    }
    // Temporarily expose input value. Use with caution.
    get platformCredentialInput() {
        return this._platformCredential;
    }
    get platformPrincipal() {
        return this.getStringAttribute('platform_principal');
    }
    set platformPrincipal(value) {
        this._platformPrincipal = value;
    }
    resetPlatformPrincipal() {
        this._platformPrincipal = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get platformPrincipalInput() {
        return this._platformPrincipal;
    }
    get successFeedbackRoleArn() {
        return this.getStringAttribute('success_feedback_role_arn');
    }
    set successFeedbackRoleArn(value) {
        this._successFeedbackRoleArn = value;
    }
    resetSuccessFeedbackRoleArn() {
        this._successFeedbackRoleArn = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get successFeedbackRoleArnInput() {
        return this._successFeedbackRoleArn;
    }
    get successFeedbackSampleRate() {
        return this.getStringAttribute('success_feedback_sample_rate');
    }
    set successFeedbackSampleRate(value) {
        this._successFeedbackSampleRate = value;
    }
    resetSuccessFeedbackSampleRate() {
        this._successFeedbackSampleRate = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get successFeedbackSampleRateInput() {
        return this._successFeedbackSampleRate;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            event_delivery_failure_topic_arn: cdktf.stringToTerraform(this._eventDeliveryFailureTopicArn),
            event_endpoint_created_topic_arn: cdktf.stringToTerraform(this._eventEndpointCreatedTopicArn),
            event_endpoint_deleted_topic_arn: cdktf.stringToTerraform(this._eventEndpointDeletedTopicArn),
            event_endpoint_updated_topic_arn: cdktf.stringToTerraform(this._eventEndpointUpdatedTopicArn),
            failure_feedback_role_arn: cdktf.stringToTerraform(this._failureFeedbackRoleArn),
            name: cdktf.stringToTerraform(this._name),
            platform: cdktf.stringToTerraform(this._platform),
            platform_credential: cdktf.stringToTerraform(this._platformCredential),
            platform_principal: cdktf.stringToTerraform(this._platformPrincipal),
            success_feedback_role_arn: cdktf.stringToTerraform(this._successFeedbackRoleArn),
            success_feedback_sample_rate: cdktf.stringToTerraform(this._successFeedbackSampleRate),
        };
    }
}
exports.SnsPlatformApplication = SnsPlatformApplication;
_a = JSII_RTTI_SYMBOL_1;
SnsPlatformApplication[_a] = { fqn: "@cdktf/provider-aws.sns.SnsPlatformApplication", version: "7.0.64" };
// =================
// STATIC PROPERTIES
// =================
SnsPlatformApplication.tfResourceType = "aws_sns_platform_application";
//# sourceMappingURL=data:application/json;base64,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