"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SnsSmsPreferences = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/sns_sms_preferences aws_sns_sms_preferences}
*/
class SnsSmsPreferences extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/sns_sms_preferences aws_sns_sms_preferences} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SnsSmsPreferencesConfig = {}
    */
    constructor(scope, id, config = {}) {
        super(scope, id, {
            terraformResourceType: 'aws_sns_sms_preferences',
            terraformGeneratorMetadata: {
                providerName: 'aws',
                providerVersion: '4.15.1',
                providerVersionConstraint: '~> 4.0'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._defaultSenderId = config.defaultSenderId;
        this._defaultSmsType = config.defaultSmsType;
        this._deliveryStatusIamRoleArn = config.deliveryStatusIamRoleArn;
        this._deliveryStatusSuccessSamplingRate = config.deliveryStatusSuccessSamplingRate;
        this._monthlySpendLimit = config.monthlySpendLimit;
        this._usageReportS3Bucket = config.usageReportS3Bucket;
    }
    get defaultSenderId() {
        return this.getStringAttribute('default_sender_id');
    }
    set defaultSenderId(value) {
        this._defaultSenderId = value;
    }
    resetDefaultSenderId() {
        this._defaultSenderId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get defaultSenderIdInput() {
        return this._defaultSenderId;
    }
    get defaultSmsType() {
        return this.getStringAttribute('default_sms_type');
    }
    set defaultSmsType(value) {
        this._defaultSmsType = value;
    }
    resetDefaultSmsType() {
        this._defaultSmsType = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get defaultSmsTypeInput() {
        return this._defaultSmsType;
    }
    get deliveryStatusIamRoleArn() {
        return this.getStringAttribute('delivery_status_iam_role_arn');
    }
    set deliveryStatusIamRoleArn(value) {
        this._deliveryStatusIamRoleArn = value;
    }
    resetDeliveryStatusIamRoleArn() {
        this._deliveryStatusIamRoleArn = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deliveryStatusIamRoleArnInput() {
        return this._deliveryStatusIamRoleArn;
    }
    get deliveryStatusSuccessSamplingRate() {
        return this.getStringAttribute('delivery_status_success_sampling_rate');
    }
    set deliveryStatusSuccessSamplingRate(value) {
        this._deliveryStatusSuccessSamplingRate = value;
    }
    resetDeliveryStatusSuccessSamplingRate() {
        this._deliveryStatusSuccessSamplingRate = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deliveryStatusSuccessSamplingRateInput() {
        return this._deliveryStatusSuccessSamplingRate;
    }
    // id - computed: true, optional: true, required: false
    get id() {
        return this.getStringAttribute('id');
    }
    get monthlySpendLimit() {
        return this.getNumberAttribute('monthly_spend_limit');
    }
    set monthlySpendLimit(value) {
        this._monthlySpendLimit = value;
    }
    resetMonthlySpendLimit() {
        this._monthlySpendLimit = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get monthlySpendLimitInput() {
        return this._monthlySpendLimit;
    }
    get usageReportS3Bucket() {
        return this.getStringAttribute('usage_report_s3_bucket');
    }
    set usageReportS3Bucket(value) {
        this._usageReportS3Bucket = value;
    }
    resetUsageReportS3Bucket() {
        this._usageReportS3Bucket = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get usageReportS3BucketInput() {
        return this._usageReportS3Bucket;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            default_sender_id: cdktf.stringToTerraform(this._defaultSenderId),
            default_sms_type: cdktf.stringToTerraform(this._defaultSmsType),
            delivery_status_iam_role_arn: cdktf.stringToTerraform(this._deliveryStatusIamRoleArn),
            delivery_status_success_sampling_rate: cdktf.stringToTerraform(this._deliveryStatusSuccessSamplingRate),
            monthly_spend_limit: cdktf.numberToTerraform(this._monthlySpendLimit),
            usage_report_s3_bucket: cdktf.stringToTerraform(this._usageReportS3Bucket),
        };
    }
}
exports.SnsSmsPreferences = SnsSmsPreferences;
_a = JSII_RTTI_SYMBOL_1;
SnsSmsPreferences[_a] = { fqn: "@cdktf/provider-aws.sns.SnsSmsPreferences", version: "7.0.64" };
// =================
// STATIC PROPERTIES
// =================
SnsSmsPreferences.tfResourceType = "aws_sns_sms_preferences";
//# sourceMappingURL=data:application/json;base64,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