import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Systems Manager
*/
export interface DataAwsSsmInstancesConfig extends cdktf.TerraformMetaArguments {
    /**
    * filter block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ssm_instances#filter DataAwsSsmInstances#filter}
    */
    readonly filter?: DataAwsSsmInstancesFilter[] | cdktf.IResolvable;
}
export interface DataAwsSsmInstancesFilter {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ssm_instances#name DataAwsSsmInstances#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ssm_instances#values DataAwsSsmInstances#values}
    */
    readonly values: string[];
}
export declare function dataAwsSsmInstancesFilterToTerraform(struct?: DataAwsSsmInstancesFilter | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/d/ssm_instances aws_ssm_instances}
*/
export declare class DataAwsSsmInstances extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "aws_ssm_instances";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/d/ssm_instances aws_ssm_instances} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAwsSsmInstancesConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataAwsSsmInstancesConfig);
    get id(): string;
    get ids(): string[];
    private _filter?;
    get filter(): DataAwsSsmInstancesFilter[] | cdktf.IResolvable;
    set filter(value: DataAwsSsmInstancesFilter[] | cdktf.IResolvable);
    resetFilter(): void;
    get filterInput(): cdktf.IResolvable | DataAwsSsmInstancesFilter[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-aws-ssm-instances.d.ts.map