import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Systems Manager
*/
export interface DataAwsSsmMaintenanceWindowsConfig extends cdktf.TerraformMetaArguments {
    /**
    * filter block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ssm_maintenance_windows#filter DataAwsSsmMaintenanceWindows#filter}
    */
    readonly filter?: DataAwsSsmMaintenanceWindowsFilter[] | cdktf.IResolvable;
}
export interface DataAwsSsmMaintenanceWindowsFilter {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ssm_maintenance_windows#name DataAwsSsmMaintenanceWindows#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ssm_maintenance_windows#values DataAwsSsmMaintenanceWindows#values}
    */
    readonly values: string[];
}
export declare function dataAwsSsmMaintenanceWindowsFilterToTerraform(struct?: DataAwsSsmMaintenanceWindowsFilter | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/d/ssm_maintenance_windows aws_ssm_maintenance_windows}
*/
export declare class DataAwsSsmMaintenanceWindows extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "aws_ssm_maintenance_windows";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/d/ssm_maintenance_windows aws_ssm_maintenance_windows} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAwsSsmMaintenanceWindowsConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataAwsSsmMaintenanceWindowsConfig);
    get id(): string;
    get ids(): string[];
    private _filter?;
    get filter(): DataAwsSsmMaintenanceWindowsFilter[] | cdktf.IResolvable;
    set filter(value: DataAwsSsmMaintenanceWindowsFilter[] | cdktf.IResolvable);
    resetFilter(): void;
    get filterInput(): cdktf.IResolvable | DataAwsSsmMaintenanceWindowsFilter[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-aws-ssm-maintenance-windows.d.ts.map