import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Systems Manager
*/
export interface DataAwsSsmParametersByPathConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ssm_parameters_by_path#path DataAwsSsmParametersByPath#path}
    */
    readonly path: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ssm_parameters_by_path#recursive DataAwsSsmParametersByPath#recursive}
    */
    readonly recursive?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/ssm_parameters_by_path#with_decryption DataAwsSsmParametersByPath#with_decryption}
    */
    readonly withDecryption?: boolean | cdktf.IResolvable;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/d/ssm_parameters_by_path aws_ssm_parameters_by_path}
*/
export declare class DataAwsSsmParametersByPath extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "aws_ssm_parameters_by_path";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/d/ssm_parameters_by_path aws_ssm_parameters_by_path} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAwsSsmParametersByPathConfig
    */
    constructor(scope: Construct, id: string, config: DataAwsSsmParametersByPathConfig);
    get arns(): string[];
    get id(): string;
    get names(): string[];
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    private _recursive?;
    get recursive(): boolean | cdktf.IResolvable;
    set recursive(value: boolean | cdktf.IResolvable);
    resetRecursive(): void;
    get recursiveInput(): boolean | cdktf.IResolvable | undefined;
    get types(): string[];
    get values(): string[];
    private _withDecryption?;
    get withDecryption(): boolean | cdktf.IResolvable;
    set withDecryption(value: boolean | cdktf.IResolvable);
    resetWithDecryption(): void;
    get withDecryptionInput(): boolean | cdktf.IResolvable | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-aws-ssm-parameters-by-path.d.ts.map