import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS Systems Manager
*/
export interface SsmPatchBaselineConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ssm_patch_baseline#approved_patches SsmPatchBaseline#approved_patches}
    */
    readonly approvedPatches?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ssm_patch_baseline#approved_patches_compliance_level SsmPatchBaseline#approved_patches_compliance_level}
    */
    readonly approvedPatchesComplianceLevel?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ssm_patch_baseline#approved_patches_enable_non_security SsmPatchBaseline#approved_patches_enable_non_security}
    */
    readonly approvedPatchesEnableNonSecurity?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ssm_patch_baseline#description SsmPatchBaseline#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ssm_patch_baseline#name SsmPatchBaseline#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ssm_patch_baseline#operating_system SsmPatchBaseline#operating_system}
    */
    readonly operatingSystem?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ssm_patch_baseline#rejected_patches SsmPatchBaseline#rejected_patches}
    */
    readonly rejectedPatches?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ssm_patch_baseline#rejected_patches_action SsmPatchBaseline#rejected_patches_action}
    */
    readonly rejectedPatchesAction?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ssm_patch_baseline#tags SsmPatchBaseline#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ssm_patch_baseline#tags_all SsmPatchBaseline#tags_all}
    */
    readonly tagsAll?: {
        [key: string]: string;
    };
    /**
    * approval_rule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ssm_patch_baseline#approval_rule SsmPatchBaseline#approval_rule}
    */
    readonly approvalRule?: SsmPatchBaselineApprovalRule[] | cdktf.IResolvable;
    /**
    * global_filter block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ssm_patch_baseline#global_filter SsmPatchBaseline#global_filter}
    */
    readonly globalFilter?: SsmPatchBaselineGlobalFilter[] | cdktf.IResolvable;
    /**
    * source block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ssm_patch_baseline#source SsmPatchBaseline#source}
    */
    readonly source?: SsmPatchBaselineSource[] | cdktf.IResolvable;
}
export interface SsmPatchBaselineApprovalRulePatchFilter {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ssm_patch_baseline#key SsmPatchBaseline#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ssm_patch_baseline#values SsmPatchBaseline#values}
    */
    readonly values: string[];
}
export declare function ssmPatchBaselineApprovalRulePatchFilterToTerraform(struct?: SsmPatchBaselineApprovalRulePatchFilter | cdktf.IResolvable): any;
export interface SsmPatchBaselineApprovalRule {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ssm_patch_baseline#approve_after_days SsmPatchBaseline#approve_after_days}
    */
    readonly approveAfterDays?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ssm_patch_baseline#approve_until_date SsmPatchBaseline#approve_until_date}
    */
    readonly approveUntilDate?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ssm_patch_baseline#compliance_level SsmPatchBaseline#compliance_level}
    */
    readonly complianceLevel?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ssm_patch_baseline#enable_non_security SsmPatchBaseline#enable_non_security}
    */
    readonly enableNonSecurity?: boolean | cdktf.IResolvable;
    /**
    * patch_filter block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ssm_patch_baseline#patch_filter SsmPatchBaseline#patch_filter}
    */
    readonly patchFilter: SsmPatchBaselineApprovalRulePatchFilter[] | cdktf.IResolvable;
}
export declare function ssmPatchBaselineApprovalRuleToTerraform(struct?: SsmPatchBaselineApprovalRule | cdktf.IResolvable): any;
export interface SsmPatchBaselineGlobalFilter {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ssm_patch_baseline#key SsmPatchBaseline#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ssm_patch_baseline#values SsmPatchBaseline#values}
    */
    readonly values: string[];
}
export declare function ssmPatchBaselineGlobalFilterToTerraform(struct?: SsmPatchBaselineGlobalFilter | cdktf.IResolvable): any;
export interface SsmPatchBaselineSource {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ssm_patch_baseline#configuration SsmPatchBaseline#configuration}
    */
    readonly configuration: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ssm_patch_baseline#name SsmPatchBaseline#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/ssm_patch_baseline#products SsmPatchBaseline#products}
    */
    readonly products: string[];
}
export declare function ssmPatchBaselineSourceToTerraform(struct?: SsmPatchBaselineSource | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/ssm_patch_baseline aws_ssm_patch_baseline}
*/
export declare class SsmPatchBaseline extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_ssm_patch_baseline";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/ssm_patch_baseline aws_ssm_patch_baseline} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SsmPatchBaselineConfig
    */
    constructor(scope: Construct, id: string, config: SsmPatchBaselineConfig);
    private _approvedPatches?;
    get approvedPatches(): string[];
    set approvedPatches(value: string[]);
    resetApprovedPatches(): void;
    get approvedPatchesInput(): string[] | undefined;
    private _approvedPatchesComplianceLevel?;
    get approvedPatchesComplianceLevel(): string;
    set approvedPatchesComplianceLevel(value: string);
    resetApprovedPatchesComplianceLevel(): void;
    get approvedPatchesComplianceLevelInput(): string | undefined;
    private _approvedPatchesEnableNonSecurity?;
    get approvedPatchesEnableNonSecurity(): boolean | cdktf.IResolvable;
    set approvedPatchesEnableNonSecurity(value: boolean | cdktf.IResolvable);
    resetApprovedPatchesEnableNonSecurity(): void;
    get approvedPatchesEnableNonSecurityInput(): boolean | cdktf.IResolvable | undefined;
    get arn(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _operatingSystem?;
    get operatingSystem(): string;
    set operatingSystem(value: string);
    resetOperatingSystem(): void;
    get operatingSystemInput(): string | undefined;
    private _rejectedPatches?;
    get rejectedPatches(): string[];
    set rejectedPatches(value: string[]);
    resetRejectedPatches(): void;
    get rejectedPatchesInput(): string[] | undefined;
    private _rejectedPatchesAction?;
    get rejectedPatchesAction(): string;
    set rejectedPatchesAction(value: string);
    resetRejectedPatchesAction(): void;
    get rejectedPatchesActionInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _tagsAll?;
    get tagsAll(): {
        [key: string]: string;
    };
    set tagsAll(value: {
        [key: string]: string;
    });
    resetTagsAll(): void;
    get tagsAllInput(): {
        [key: string]: string;
    } | undefined;
    private _approvalRule?;
    get approvalRule(): SsmPatchBaselineApprovalRule[] | cdktf.IResolvable;
    set approvalRule(value: SsmPatchBaselineApprovalRule[] | cdktf.IResolvable);
    resetApprovalRule(): void;
    get approvalRuleInput(): cdktf.IResolvable | SsmPatchBaselineApprovalRule[] | undefined;
    private _globalFilter?;
    get globalFilter(): SsmPatchBaselineGlobalFilter[] | cdktf.IResolvable;
    set globalFilter(value: SsmPatchBaselineGlobalFilter[] | cdktf.IResolvable);
    resetGlobalFilter(): void;
    get globalFilterInput(): cdktf.IResolvable | SsmPatchBaselineGlobalFilter[] | undefined;
    private _source?;
    get source(): SsmPatchBaselineSource[] | cdktf.IResolvable;
    set source(value: SsmPatchBaselineSource[] | cdktf.IResolvable);
    resetSource(): void;
    get sourceInput(): cdktf.IResolvable | SsmPatchBaselineSource[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=ssm-patch-baseline.d.ts.map