import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS VPC
*/
export interface DataAwsCustomerGatewayConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/customer_gateway#tags DataAwsCustomerGateway#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * filter block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/customer_gateway#filter DataAwsCustomerGateway#filter}
    */
    readonly filter?: DataAwsCustomerGatewayFilter[] | cdktf.IResolvable;
}
export interface DataAwsCustomerGatewayFilter {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/customer_gateway#name DataAwsCustomerGateway#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/customer_gateway#values DataAwsCustomerGateway#values}
    */
    readonly values: string[];
}
export declare function dataAwsCustomerGatewayFilterToTerraform(struct?: DataAwsCustomerGatewayFilter | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/d/customer_gateway aws_customer_gateway}
*/
export declare class DataAwsCustomerGateway extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "aws_customer_gateway";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/d/customer_gateway aws_customer_gateway} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAwsCustomerGatewayConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataAwsCustomerGatewayConfig);
    get arn(): string;
    get bgpAsn(): number;
    get certificateArn(): string;
    get deviceName(): string;
    get id(): string;
    get ipAddress(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    get type(): string;
    private _filter?;
    get filter(): DataAwsCustomerGatewayFilter[] | cdktf.IResolvable;
    set filter(value: DataAwsCustomerGatewayFilter[] | cdktf.IResolvable);
    resetFilter(): void;
    get filterInput(): cdktf.IResolvable | DataAwsCustomerGatewayFilter[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-aws-customer-gateway.d.ts.map