import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS VPC
*/
export interface DataAwsInternetGatewayConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/internet_gateway#internet_gateway_id DataAwsInternetGateway#internet_gateway_id}
    */
    readonly internetGatewayId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/internet_gateway#tags DataAwsInternetGateway#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * filter block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/internet_gateway#filter DataAwsInternetGateway#filter}
    */
    readonly filter?: DataAwsInternetGatewayFilter[] | cdktf.IResolvable;
}
export interface DataAwsInternetGatewayAttachments {
}
export declare function dataAwsInternetGatewayAttachmentsToTerraform(struct?: DataAwsInternetGatewayAttachments): any;
export declare class DataAwsInternetGatewayAttachmentsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAwsInternetGatewayAttachments | undefined;
    set internalValue(value: DataAwsInternetGatewayAttachments | undefined);
    get state(): string;
    get vpcId(): string;
}
export declare class DataAwsInternetGatewayAttachmentsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAwsInternetGatewayAttachmentsOutputReference;
}
export interface DataAwsInternetGatewayFilter {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/internet_gateway#name DataAwsInternetGateway#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/internet_gateway#values DataAwsInternetGateway#values}
    */
    readonly values: string[];
}
export declare function dataAwsInternetGatewayFilterToTerraform(struct?: DataAwsInternetGatewayFilter | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/d/internet_gateway aws_internet_gateway}
*/
export declare class DataAwsInternetGateway extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "aws_internet_gateway";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/d/internet_gateway aws_internet_gateway} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAwsInternetGatewayConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataAwsInternetGatewayConfig);
    get arn(): string;
    private _attachments;
    get attachments(): DataAwsInternetGatewayAttachmentsList;
    get id(): string;
    private _internetGatewayId?;
    get internetGatewayId(): string;
    set internetGatewayId(value: string);
    resetInternetGatewayId(): void;
    get internetGatewayIdInput(): string | undefined;
    get ownerId(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _filter?;
    get filter(): DataAwsInternetGatewayFilter[] | cdktf.IResolvable;
    set filter(value: DataAwsInternetGatewayFilter[] | cdktf.IResolvable);
    resetFilter(): void;
    get filterInput(): cdktf.IResolvable | DataAwsInternetGatewayFilter[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-aws-internet-gateway.d.ts.map