import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS VPC
*/
export interface DataAwsNetworkInterfaceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/network_interface#tags DataAwsNetworkInterface#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * filter block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/network_interface#filter DataAwsNetworkInterface#filter}
    */
    readonly filter?: DataAwsNetworkInterfaceFilter[] | cdktf.IResolvable;
}
export interface DataAwsNetworkInterfaceAssociation {
}
export declare function dataAwsNetworkInterfaceAssociationToTerraform(struct?: DataAwsNetworkInterfaceAssociation): any;
export declare class DataAwsNetworkInterfaceAssociationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAwsNetworkInterfaceAssociation | undefined;
    set internalValue(value: DataAwsNetworkInterfaceAssociation | undefined);
    get allocationId(): string;
    get associationId(): string;
    get carrierIp(): string;
    get customerOwnedIp(): string;
    get ipOwnerId(): string;
    get publicDnsName(): string;
    get publicIp(): string;
}
export declare class DataAwsNetworkInterfaceAssociationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAwsNetworkInterfaceAssociationOutputReference;
}
export interface DataAwsNetworkInterfaceAttachment {
}
export declare function dataAwsNetworkInterfaceAttachmentToTerraform(struct?: DataAwsNetworkInterfaceAttachment): any;
export declare class DataAwsNetworkInterfaceAttachmentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAwsNetworkInterfaceAttachment | undefined;
    set internalValue(value: DataAwsNetworkInterfaceAttachment | undefined);
    get attachmentId(): string;
    get deviceIndex(): number;
    get instanceId(): string;
    get instanceOwnerId(): string;
}
export declare class DataAwsNetworkInterfaceAttachmentList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAwsNetworkInterfaceAttachmentOutputReference;
}
export interface DataAwsNetworkInterfaceFilter {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/network_interface#name DataAwsNetworkInterface#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/network_interface#values DataAwsNetworkInterface#values}
    */
    readonly values: string[];
}
export declare function dataAwsNetworkInterfaceFilterToTerraform(struct?: DataAwsNetworkInterfaceFilter | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/d/network_interface aws_network_interface}
*/
export declare class DataAwsNetworkInterface extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "aws_network_interface";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/d/network_interface aws_network_interface} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAwsNetworkInterfaceConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataAwsNetworkInterfaceConfig);
    get arn(): string;
    private _association;
    get association(): DataAwsNetworkInterfaceAssociationList;
    private _attachment;
    get attachment(): DataAwsNetworkInterfaceAttachmentList;
    get availabilityZone(): string;
    get description(): string;
    get id(): string;
    get interfaceType(): string;
    get ipv6Addresses(): string[];
    get macAddress(): string;
    get outpostArn(): string;
    get ownerId(): string;
    get privateDnsName(): string;
    get privateIp(): string;
    get privateIps(): string[];
    get requesterId(): string;
    get securityGroups(): string[];
    get subnetId(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    get vpcId(): string;
    private _filter?;
    get filter(): DataAwsNetworkInterfaceFilter[] | cdktf.IResolvable;
    set filter(value: DataAwsNetworkInterfaceFilter[] | cdktf.IResolvable);
    resetFilter(): void;
    get filterInput(): cdktf.IResolvable | DataAwsNetworkInterfaceFilter[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-aws-network-interface.d.ts.map