import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS VPC
*/
export interface DataAwsNetworkmanagerConnectionsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/networkmanager_connections#device_id DataAwsNetworkmanagerConnections#device_id}
    */
    readonly deviceId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/networkmanager_connections#global_network_id DataAwsNetworkmanagerConnections#global_network_id}
    */
    readonly globalNetworkId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/networkmanager_connections#tags DataAwsNetworkmanagerConnections#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/d/networkmanager_connections aws_networkmanager_connections}
*/
export declare class DataAwsNetworkmanagerConnections extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "aws_networkmanager_connections";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/d/networkmanager_connections aws_networkmanager_connections} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAwsNetworkmanagerConnectionsConfig
    */
    constructor(scope: Construct, id: string, config: DataAwsNetworkmanagerConnectionsConfig);
    private _deviceId?;
    get deviceId(): string;
    set deviceId(value: string);
    resetDeviceId(): void;
    get deviceIdInput(): string | undefined;
    private _globalNetworkId?;
    get globalNetworkId(): string;
    set globalNetworkId(value: string);
    get globalNetworkIdInput(): string | undefined;
    get id(): string;
    get ids(): string[];
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-aws-networkmanager-connections.d.ts.map