import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS VPC
*/
export interface DataAwsNetworkmanagerDeviceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/networkmanager_device#device_id DataAwsNetworkmanagerDevice#device_id}
    */
    readonly deviceId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/networkmanager_device#global_network_id DataAwsNetworkmanagerDevice#global_network_id}
    */
    readonly globalNetworkId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/networkmanager_device#tags DataAwsNetworkmanagerDevice#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
}
export interface DataAwsNetworkmanagerDeviceAwsLocation {
}
export declare function dataAwsNetworkmanagerDeviceAwsLocationToTerraform(struct?: DataAwsNetworkmanagerDeviceAwsLocation): any;
export declare class DataAwsNetworkmanagerDeviceAwsLocationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAwsNetworkmanagerDeviceAwsLocation | undefined;
    set internalValue(value: DataAwsNetworkmanagerDeviceAwsLocation | undefined);
    get subnetArn(): string;
    get zone(): string;
}
export declare class DataAwsNetworkmanagerDeviceAwsLocationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAwsNetworkmanagerDeviceAwsLocationOutputReference;
}
export interface DataAwsNetworkmanagerDeviceLocation {
}
export declare function dataAwsNetworkmanagerDeviceLocationToTerraform(struct?: DataAwsNetworkmanagerDeviceLocation): any;
export declare class DataAwsNetworkmanagerDeviceLocationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAwsNetworkmanagerDeviceLocation | undefined;
    set internalValue(value: DataAwsNetworkmanagerDeviceLocation | undefined);
    get address(): string;
    get latitude(): string;
    get longitude(): string;
}
export declare class DataAwsNetworkmanagerDeviceLocationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAwsNetworkmanagerDeviceLocationOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/d/networkmanager_device aws_networkmanager_device}
*/
export declare class DataAwsNetworkmanagerDevice extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "aws_networkmanager_device";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/d/networkmanager_device aws_networkmanager_device} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAwsNetworkmanagerDeviceConfig
    */
    constructor(scope: Construct, id: string, config: DataAwsNetworkmanagerDeviceConfig);
    get arn(): string;
    private _awsLocation;
    get awsLocation(): DataAwsNetworkmanagerDeviceAwsLocationList;
    get description(): string;
    private _deviceId?;
    get deviceId(): string;
    set deviceId(value: string);
    get deviceIdInput(): string | undefined;
    private _globalNetworkId?;
    get globalNetworkId(): string;
    set globalNetworkId(value: string);
    get globalNetworkIdInput(): string | undefined;
    get id(): string;
    private _location;
    get location(): DataAwsNetworkmanagerDeviceLocationList;
    get model(): string;
    get serialNumber(): string;
    get siteId(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    get type(): string;
    get vendor(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-aws-networkmanager-device.d.ts.map