import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS VPC
*/
export interface DataAwsRouteTableConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/route_table#gateway_id DataAwsRouteTable#gateway_id}
    */
    readonly gatewayId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/route_table#route_table_id DataAwsRouteTable#route_table_id}
    */
    readonly routeTableId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/route_table#subnet_id DataAwsRouteTable#subnet_id}
    */
    readonly subnetId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/route_table#tags DataAwsRouteTable#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/route_table#vpc_id DataAwsRouteTable#vpc_id}
    */
    readonly vpcId?: string;
    /**
    * filter block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/route_table#filter DataAwsRouteTable#filter}
    */
    readonly filter?: DataAwsRouteTableFilter[] | cdktf.IResolvable;
}
export interface DataAwsRouteTableAssociations {
}
export declare function dataAwsRouteTableAssociationsToTerraform(struct?: DataAwsRouteTableAssociations): any;
export declare class DataAwsRouteTableAssociationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAwsRouteTableAssociations | undefined;
    set internalValue(value: DataAwsRouteTableAssociations | undefined);
    get gatewayId(): string;
    get main(): cdktf.IResolvable;
    get routeTableAssociationId(): string;
    get routeTableId(): string;
    get subnetId(): string;
}
export declare class DataAwsRouteTableAssociationsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAwsRouteTableAssociationsOutputReference;
}
export interface DataAwsRouteTableRoutes {
}
export declare function dataAwsRouteTableRoutesToTerraform(struct?: DataAwsRouteTableRoutes): any;
export declare class DataAwsRouteTableRoutesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAwsRouteTableRoutes | undefined;
    set internalValue(value: DataAwsRouteTableRoutes | undefined);
    get carrierGatewayId(): string;
    get cidrBlock(): string;
    get coreNetworkArn(): string;
    get destinationPrefixListId(): string;
    get egressOnlyGatewayId(): string;
    get gatewayId(): string;
    get instanceId(): string;
    get ipv6CidrBlock(): string;
    get localGatewayId(): string;
    get natGatewayId(): string;
    get networkInterfaceId(): string;
    get transitGatewayId(): string;
    get vpcEndpointId(): string;
    get vpcPeeringConnectionId(): string;
}
export declare class DataAwsRouteTableRoutesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAwsRouteTableRoutesOutputReference;
}
export interface DataAwsRouteTableFilter {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/route_table#name DataAwsRouteTable#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/route_table#values DataAwsRouteTable#values}
    */
    readonly values: string[];
}
export declare function dataAwsRouteTableFilterToTerraform(struct?: DataAwsRouteTableFilter | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/d/route_table aws_route_table}
*/
export declare class DataAwsRouteTable extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "aws_route_table";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/d/route_table aws_route_table} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAwsRouteTableConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataAwsRouteTableConfig);
    get arn(): string;
    private _associations;
    get associations(): DataAwsRouteTableAssociationsList;
    private _gatewayId?;
    get gatewayId(): string;
    set gatewayId(value: string);
    resetGatewayId(): void;
    get gatewayIdInput(): string | undefined;
    get id(): string;
    get ownerId(): string;
    private _routeTableId?;
    get routeTableId(): string;
    set routeTableId(value: string);
    resetRouteTableId(): void;
    get routeTableIdInput(): string | undefined;
    private _routes;
    get routes(): DataAwsRouteTableRoutesList;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    resetSubnetId(): void;
    get subnetIdInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _vpcId?;
    get vpcId(): string;
    set vpcId(value: string);
    resetVpcId(): void;
    get vpcIdInput(): string | undefined;
    private _filter?;
    get filter(): DataAwsRouteTableFilter[] | cdktf.IResolvable;
    set filter(value: DataAwsRouteTableFilter[] | cdktf.IResolvable);
    resetFilter(): void;
    get filterInput(): cdktf.IResolvable | DataAwsRouteTableFilter[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-aws-route-table.d.ts.map