import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS VPC
*/
export interface DataAwsVpcIpamPoolConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/vpc_ipam_pool#allocation_resource_tags DataAwsVpcIpamPool#allocation_resource_tags}
    */
    readonly allocationResourceTags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/vpc_ipam_pool#id DataAwsVpcIpamPool#id}
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/vpc_ipam_pool#ipam_pool_id DataAwsVpcIpamPool#ipam_pool_id}
    */
    readonly ipamPoolId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/vpc_ipam_pool#tags DataAwsVpcIpamPool#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * filter block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/vpc_ipam_pool#filter DataAwsVpcIpamPool#filter}
    */
    readonly filter?: DataAwsVpcIpamPoolFilter[] | cdktf.IResolvable;
}
export interface DataAwsVpcIpamPoolFilter {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/vpc_ipam_pool#name DataAwsVpcIpamPool#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/d/vpc_ipam_pool#values DataAwsVpcIpamPool#values}
    */
    readonly values: string[];
}
export declare function dataAwsVpcIpamPoolFilterToTerraform(struct?: DataAwsVpcIpamPoolFilter | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/d/vpc_ipam_pool aws_vpc_ipam_pool}
*/
export declare class DataAwsVpcIpamPool extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "aws_vpc_ipam_pool";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/d/vpc_ipam_pool aws_vpc_ipam_pool} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAwsVpcIpamPoolConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataAwsVpcIpamPoolConfig);
    get addressFamily(): string;
    get allocationDefaultNetmaskLength(): number;
    get allocationMaxNetmaskLength(): number;
    get allocationMinNetmaskLength(): number;
    private _allocationResourceTags?;
    get allocationResourceTags(): {
        [key: string]: string;
    };
    set allocationResourceTags(value: {
        [key: string]: string;
    });
    resetAllocationResourceTags(): void;
    get allocationResourceTagsInput(): {
        [key: string]: string;
    } | undefined;
    get arn(): string;
    get autoImport(): cdktf.IResolvable;
    get awsService(): string;
    get description(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ipamPoolId?;
    get ipamPoolId(): string;
    set ipamPoolId(value: string);
    resetIpamPoolId(): void;
    get ipamPoolIdInput(): string | undefined;
    get ipamScopeId(): string;
    get ipamScopeType(): string;
    get locale(): string;
    get poolDepth(): number;
    get publiclyAdvertisable(): cdktf.IResolvable;
    get sourceIpamPoolId(): string;
    get state(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _filter?;
    get filter(): DataAwsVpcIpamPoolFilter[] | cdktf.IResolvable;
    set filter(value: DataAwsVpcIpamPoolFilter[] | cdktf.IResolvable);
    resetFilter(): void;
    get filterInput(): cdktf.IResolvable | DataAwsVpcIpamPoolFilter[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-aws-vpc-ipam-pool.d.ts.map