"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DataAwsVpcIpamPreviewNextCidr = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/d/vpc_ipam_preview_next_cidr aws_vpc_ipam_preview_next_cidr}
*/
class DataAwsVpcIpamPreviewNextCidr extends cdktf.TerraformDataSource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/d/vpc_ipam_preview_next_cidr aws_vpc_ipam_preview_next_cidr} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAwsVpcIpamPreviewNextCidrConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'aws_vpc_ipam_preview_next_cidr',
            terraformGeneratorMetadata: {
                providerName: 'aws',
                providerVersion: '4.15.1',
                providerVersionConstraint: '~> 4.0'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._disallowedCidrs = config.disallowedCidrs;
        this._ipamPoolId = config.ipamPoolId;
        this._netmaskLength = config.netmaskLength;
    }
    // ==========
    // ATTRIBUTES
    // ==========
    // cidr - computed: true, optional: false, required: false
    get cidr() {
        return this.getStringAttribute('cidr');
    }
    get disallowedCidrs() {
        return cdktf.Fn.tolist(this.getListAttribute('disallowed_cidrs'));
    }
    set disallowedCidrs(value) {
        this._disallowedCidrs = value;
    }
    resetDisallowedCidrs() {
        this._disallowedCidrs = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get disallowedCidrsInput() {
        return this._disallowedCidrs;
    }
    // id - computed: true, optional: true, required: false
    get id() {
        return this.getStringAttribute('id');
    }
    get ipamPoolId() {
        return this.getStringAttribute('ipam_pool_id');
    }
    set ipamPoolId(value) {
        this._ipamPoolId = value;
    }
    // Temporarily expose input value. Use with caution.
    get ipamPoolIdInput() {
        return this._ipamPoolId;
    }
    get netmaskLength() {
        return this.getNumberAttribute('netmask_length');
    }
    set netmaskLength(value) {
        this._netmaskLength = value;
    }
    resetNetmaskLength() {
        this._netmaskLength = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get netmaskLengthInput() {
        return this._netmaskLength;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            disallowed_cidrs: cdktf.listMapper(cdktf.stringToTerraform)(this._disallowedCidrs),
            ipam_pool_id: cdktf.stringToTerraform(this._ipamPoolId),
            netmask_length: cdktf.numberToTerraform(this._netmaskLength),
        };
    }
}
exports.DataAwsVpcIpamPreviewNextCidr = DataAwsVpcIpamPreviewNextCidr;
_a = JSII_RTTI_SYMBOL_1;
DataAwsVpcIpamPreviewNextCidr[_a] = { fqn: "@cdktf/provider-aws.vpc.DataAwsVpcIpamPreviewNextCidr", version: "7.0.64" };
// =================
// STATIC PROPERTIES
// =================
DataAwsVpcIpamPreviewNextCidr.tfResourceType = "aws_vpc_ipam_preview_next_cidr";
//# sourceMappingURL=data:application/json;base64,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