import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS VPC
*/
export interface NetworkAclAssociationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/network_acl_association#network_acl_id NetworkAclAssociation#network_acl_id}
    */
    readonly networkAclId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/network_acl_association#subnet_id NetworkAclAssociation#subnet_id}
    */
    readonly subnetId: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/network_acl_association aws_network_acl_association}
*/
export declare class NetworkAclAssociation extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_network_acl_association";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/network_acl_association aws_network_acl_association} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NetworkAclAssociationConfig
    */
    constructor(scope: Construct, id: string, config: NetworkAclAssociationConfig);
    get id(): string;
    private _networkAclId?;
    get networkAclId(): string;
    set networkAclId(value: string);
    get networkAclIdInput(): string | undefined;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    get subnetIdInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=network-acl-association.d.ts.map