import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS VPC
*/
export interface NetworkmanagerCustomerGatewayAssociationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/networkmanager_customer_gateway_association#customer_gateway_arn NetworkmanagerCustomerGatewayAssociation#customer_gateway_arn}
    */
    readonly customerGatewayArn: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/networkmanager_customer_gateway_association#device_id NetworkmanagerCustomerGatewayAssociation#device_id}
    */
    readonly deviceId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/networkmanager_customer_gateway_association#global_network_id NetworkmanagerCustomerGatewayAssociation#global_network_id}
    */
    readonly globalNetworkId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/networkmanager_customer_gateway_association#link_id NetworkmanagerCustomerGatewayAssociation#link_id}
    */
    readonly linkId?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/networkmanager_customer_gateway_association#timeouts NetworkmanagerCustomerGatewayAssociation#timeouts}
    */
    readonly timeouts?: NetworkmanagerCustomerGatewayAssociationTimeouts;
}
export interface NetworkmanagerCustomerGatewayAssociationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/networkmanager_customer_gateway_association#create NetworkmanagerCustomerGatewayAssociation#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/networkmanager_customer_gateway_association#delete NetworkmanagerCustomerGatewayAssociation#delete}
    */
    readonly delete?: string;
}
export declare function networkmanagerCustomerGatewayAssociationTimeoutsToTerraform(struct?: NetworkmanagerCustomerGatewayAssociationTimeoutsOutputReference | NetworkmanagerCustomerGatewayAssociationTimeouts | cdktf.IResolvable): any;
export declare class NetworkmanagerCustomerGatewayAssociationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NetworkmanagerCustomerGatewayAssociationTimeouts | undefined;
    set internalValue(value: NetworkmanagerCustomerGatewayAssociationTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/networkmanager_customer_gateway_association aws_networkmanager_customer_gateway_association}
*/
export declare class NetworkmanagerCustomerGatewayAssociation extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_networkmanager_customer_gateway_association";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/networkmanager_customer_gateway_association aws_networkmanager_customer_gateway_association} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NetworkmanagerCustomerGatewayAssociationConfig
    */
    constructor(scope: Construct, id: string, config: NetworkmanagerCustomerGatewayAssociationConfig);
    private _customerGatewayArn?;
    get customerGatewayArn(): string;
    set customerGatewayArn(value: string);
    get customerGatewayArnInput(): string | undefined;
    private _deviceId?;
    get deviceId(): string;
    set deviceId(value: string);
    get deviceIdInput(): string | undefined;
    private _globalNetworkId?;
    get globalNetworkId(): string;
    set globalNetworkId(value: string);
    get globalNetworkIdInput(): string | undefined;
    get id(): string;
    private _linkId?;
    get linkId(): string;
    set linkId(value: string);
    resetLinkId(): void;
    get linkIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): NetworkmanagerCustomerGatewayAssociationTimeoutsOutputReference;
    putTimeouts(value: NetworkmanagerCustomerGatewayAssociationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): NetworkmanagerCustomerGatewayAssociationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=networkmanager-customer-gateway-association.d.ts.map