import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS VPC
*/
export interface NetworkmanagerTransitGatewayConnectPeerAssociationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/networkmanager_transit_gateway_connect_peer_association#device_id NetworkmanagerTransitGatewayConnectPeerAssociation#device_id}
    */
    readonly deviceId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/networkmanager_transit_gateway_connect_peer_association#global_network_id NetworkmanagerTransitGatewayConnectPeerAssociation#global_network_id}
    */
    readonly globalNetworkId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/networkmanager_transit_gateway_connect_peer_association#link_id NetworkmanagerTransitGatewayConnectPeerAssociation#link_id}
    */
    readonly linkId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/networkmanager_transit_gateway_connect_peer_association#transit_gateway_connect_peer_arn NetworkmanagerTransitGatewayConnectPeerAssociation#transit_gateway_connect_peer_arn}
    */
    readonly transitGatewayConnectPeerArn: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/networkmanager_transit_gateway_connect_peer_association#timeouts NetworkmanagerTransitGatewayConnectPeerAssociation#timeouts}
    */
    readonly timeouts?: NetworkmanagerTransitGatewayConnectPeerAssociationTimeouts;
}
export interface NetworkmanagerTransitGatewayConnectPeerAssociationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/networkmanager_transit_gateway_connect_peer_association#create NetworkmanagerTransitGatewayConnectPeerAssociation#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/networkmanager_transit_gateway_connect_peer_association#delete NetworkmanagerTransitGatewayConnectPeerAssociation#delete}
    */
    readonly delete?: string;
}
export declare function networkmanagerTransitGatewayConnectPeerAssociationTimeoutsToTerraform(struct?: NetworkmanagerTransitGatewayConnectPeerAssociationTimeoutsOutputReference | NetworkmanagerTransitGatewayConnectPeerAssociationTimeouts | cdktf.IResolvable): any;
export declare class NetworkmanagerTransitGatewayConnectPeerAssociationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NetworkmanagerTransitGatewayConnectPeerAssociationTimeouts | undefined;
    set internalValue(value: NetworkmanagerTransitGatewayConnectPeerAssociationTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/networkmanager_transit_gateway_connect_peer_association aws_networkmanager_transit_gateway_connect_peer_association}
*/
export declare class NetworkmanagerTransitGatewayConnectPeerAssociation extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_networkmanager_transit_gateway_connect_peer_association";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/networkmanager_transit_gateway_connect_peer_association aws_networkmanager_transit_gateway_connect_peer_association} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NetworkmanagerTransitGatewayConnectPeerAssociationConfig
    */
    constructor(scope: Construct, id: string, config: NetworkmanagerTransitGatewayConnectPeerAssociationConfig);
    private _deviceId?;
    get deviceId(): string;
    set deviceId(value: string);
    get deviceIdInput(): string | undefined;
    private _globalNetworkId?;
    get globalNetworkId(): string;
    set globalNetworkId(value: string);
    get globalNetworkIdInput(): string | undefined;
    get id(): string;
    private _linkId?;
    get linkId(): string;
    set linkId(value: string);
    resetLinkId(): void;
    get linkIdInput(): string | undefined;
    private _transitGatewayConnectPeerArn?;
    get transitGatewayConnectPeerArn(): string;
    set transitGatewayConnectPeerArn(value: string);
    get transitGatewayConnectPeerArnInput(): string | undefined;
    private _timeouts;
    get timeouts(): NetworkmanagerTransitGatewayConnectPeerAssociationTimeoutsOutputReference;
    putTimeouts(value: NetworkmanagerTransitGatewayConnectPeerAssociationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): NetworkmanagerTransitGatewayConnectPeerAssociationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=networkmanager-transit-gateway-connect-peer-association.d.ts.map