import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS VPC
*/
export interface NetworkmanagerTransitGatewayRegistrationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/networkmanager_transit_gateway_registration#global_network_id NetworkmanagerTransitGatewayRegistration#global_network_id}
    */
    readonly globalNetworkId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/networkmanager_transit_gateway_registration#transit_gateway_arn NetworkmanagerTransitGatewayRegistration#transit_gateway_arn}
    */
    readonly transitGatewayArn: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/networkmanager_transit_gateway_registration#timeouts NetworkmanagerTransitGatewayRegistration#timeouts}
    */
    readonly timeouts?: NetworkmanagerTransitGatewayRegistrationTimeouts;
}
export interface NetworkmanagerTransitGatewayRegistrationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/networkmanager_transit_gateway_registration#create NetworkmanagerTransitGatewayRegistration#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/networkmanager_transit_gateway_registration#delete NetworkmanagerTransitGatewayRegistration#delete}
    */
    readonly delete?: string;
}
export declare function networkmanagerTransitGatewayRegistrationTimeoutsToTerraform(struct?: NetworkmanagerTransitGatewayRegistrationTimeoutsOutputReference | NetworkmanagerTransitGatewayRegistrationTimeouts | cdktf.IResolvable): any;
export declare class NetworkmanagerTransitGatewayRegistrationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NetworkmanagerTransitGatewayRegistrationTimeouts | undefined;
    set internalValue(value: NetworkmanagerTransitGatewayRegistrationTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/networkmanager_transit_gateway_registration aws_networkmanager_transit_gateway_registration}
*/
export declare class NetworkmanagerTransitGatewayRegistration extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_networkmanager_transit_gateway_registration";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/networkmanager_transit_gateway_registration aws_networkmanager_transit_gateway_registration} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NetworkmanagerTransitGatewayRegistrationConfig
    */
    constructor(scope: Construct, id: string, config: NetworkmanagerTransitGatewayRegistrationConfig);
    private _globalNetworkId?;
    get globalNetworkId(): string;
    set globalNetworkId(value: string);
    get globalNetworkIdInput(): string | undefined;
    get id(): string;
    private _transitGatewayArn?;
    get transitGatewayArn(): string;
    set transitGatewayArn(value: string);
    get transitGatewayArnInput(): string | undefined;
    private _timeouts;
    get timeouts(): NetworkmanagerTransitGatewayRegistrationTimeoutsOutputReference;
    putTimeouts(value: NetworkmanagerTransitGatewayRegistrationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): NetworkmanagerTransitGatewayRegistrationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=networkmanager-transit-gateway-registration.d.ts.map