import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
* AWS VPC
*/
export interface VpcEndpointServiceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/vpc_endpoint_service#acceptance_required VpcEndpointService#acceptance_required}
    */
    readonly acceptanceRequired: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/vpc_endpoint_service#allowed_principals VpcEndpointService#allowed_principals}
    */
    readonly allowedPrincipals?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/vpc_endpoint_service#gateway_load_balancer_arns VpcEndpointService#gateway_load_balancer_arns}
    */
    readonly gatewayLoadBalancerArns?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/vpc_endpoint_service#network_load_balancer_arns VpcEndpointService#network_load_balancer_arns}
    */
    readonly networkLoadBalancerArns?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/vpc_endpoint_service#private_dns_name VpcEndpointService#private_dns_name}
    */
    readonly privateDnsName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/vpc_endpoint_service#tags VpcEndpointService#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/aws/r/vpc_endpoint_service#tags_all VpcEndpointService#tags_all}
    */
    readonly tagsAll?: {
        [key: string]: string;
    };
}
export interface VpcEndpointServicePrivateDnsNameConfiguration {
}
export declare function vpcEndpointServicePrivateDnsNameConfigurationToTerraform(struct?: VpcEndpointServicePrivateDnsNameConfiguration): any;
export declare class VpcEndpointServicePrivateDnsNameConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VpcEndpointServicePrivateDnsNameConfiguration | undefined;
    set internalValue(value: VpcEndpointServicePrivateDnsNameConfiguration | undefined);
    get name(): string;
    get state(): string;
    get type(): string;
    get value(): string;
}
export declare class VpcEndpointServicePrivateDnsNameConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VpcEndpointServicePrivateDnsNameConfigurationOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/aws/r/vpc_endpoint_service aws_vpc_endpoint_service}
*/
export declare class VpcEndpointService extends cdktf.TerraformResource {
    static readonly tfResourceType = "aws_vpc_endpoint_service";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/aws/r/vpc_endpoint_service aws_vpc_endpoint_service} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options VpcEndpointServiceConfig
    */
    constructor(scope: Construct, id: string, config: VpcEndpointServiceConfig);
    private _acceptanceRequired?;
    get acceptanceRequired(): boolean | cdktf.IResolvable;
    set acceptanceRequired(value: boolean | cdktf.IResolvable);
    get acceptanceRequiredInput(): boolean | cdktf.IResolvable | undefined;
    private _allowedPrincipals?;
    get allowedPrincipals(): string[];
    set allowedPrincipals(value: string[]);
    resetAllowedPrincipals(): void;
    get allowedPrincipalsInput(): string[] | undefined;
    get arn(): string;
    get availabilityZones(): string[];
    get baseEndpointDnsNames(): string[];
    private _gatewayLoadBalancerArns?;
    get gatewayLoadBalancerArns(): string[];
    set gatewayLoadBalancerArns(value: string[]);
    resetGatewayLoadBalancerArns(): void;
    get gatewayLoadBalancerArnsInput(): string[] | undefined;
    get id(): string;
    get managesVpcEndpoints(): cdktf.IResolvable;
    private _networkLoadBalancerArns?;
    get networkLoadBalancerArns(): string[];
    set networkLoadBalancerArns(value: string[]);
    resetNetworkLoadBalancerArns(): void;
    get networkLoadBalancerArnsInput(): string[] | undefined;
    private _privateDnsName?;
    get privateDnsName(): string;
    set privateDnsName(value: string);
    resetPrivateDnsName(): void;
    get privateDnsNameInput(): string | undefined;
    private _privateDnsNameConfiguration;
    get privateDnsNameConfiguration(): VpcEndpointServicePrivateDnsNameConfigurationList;
    get serviceName(): string;
    get serviceType(): string;
    get state(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _tagsAll?;
    get tagsAll(): {
        [key: string]: string;
    };
    set tagsAll(value: {
        [key: string]: string;
    });
    resetTagsAll(): void;
    get tagsAllInput(): {
        [key: string]: string;
    } | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=vpc-endpoint-service.d.ts.map